/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.vsphere.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.hive.vsphere.v1.OSDisk;
import io.fabric8.openshift.api.model.hive.vsphere.v1.OSDiskFluent;

public class OSDiskBuilder
extends OSDiskFluent<OSDiskBuilder>
implements VisitableBuilder<OSDisk, OSDiskBuilder> {
    OSDiskFluent<?> fluent;
    Boolean validationEnabled;

    public OSDiskBuilder() {
        this(false);
    }

    public OSDiskBuilder(Boolean validationEnabled) {
        this(new OSDisk(), validationEnabled);
    }

    public OSDiskBuilder(OSDiskFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public OSDiskBuilder(OSDiskFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new OSDisk(), validationEnabled);
    }

    public OSDiskBuilder(OSDiskFluent<?> fluent, OSDisk instance) {
        this(fluent, instance, false);
    }

    public OSDiskBuilder(OSDiskFluent<?> fluent, OSDisk instance, Boolean validationEnabled) {
        this.fluent = fluent;
        OSDisk oSDisk = instance = instance != null ? instance : new OSDisk();
        if (instance != null) {
            fluent.withDiskSizeGB(instance.getDiskSizeGB());
            fluent.withDiskSizeGB(instance.getDiskSizeGB());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public OSDiskBuilder(OSDisk instance) {
        this(instance, (Boolean)false);
    }

    public OSDiskBuilder(OSDisk instance, Boolean validationEnabled) {
        this.fluent = this;
        OSDisk oSDisk = instance = instance != null ? instance : new OSDisk();
        if (instance != null) {
            this.withDiskSizeGB(instance.getDiskSizeGB());
            this.withDiskSizeGB(instance.getDiskSizeGB());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public OSDisk build() {
        OSDisk buildable = new OSDisk(this.fluent.getDiskSizeGB());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

