/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.Collection;
import org.apache.cassandra.cql3.ColumnSpecification;

public interface AssignmentTestable {
    public TestResult testAssignment(String var1, ColumnSpecification var2);

    public static enum TestResult {
        EXACT_MATCH,
        WEAKLY_ASSIGNABLE,
        NOT_ASSIGNABLE;


        public boolean isAssignable() {
            return this != NOT_ASSIGNABLE;
        }

        public boolean isExactMatch() {
            return this == EXACT_MATCH;
        }

        public static TestResult testAll(String keyspace, ColumnSpecification receiver, Collection<? extends AssignmentTestable> toTest) {
            TestResult res = EXACT_MATCH;
            for (AssignmentTestable assignmentTestable : toTest) {
                if (assignmentTestable == null) {
                    res = WEAKLY_ASSIGNABLE;
                    continue;
                }
                TestResult t = assignmentTestable.testAssignment(keyspace, receiver);
                if (t == NOT_ASSIGNABLE) {
                    return NOT_ASSIGNABLE;
                }
                if (t != WEAKLY_ASSIGNABLE) continue;
                res = WEAKLY_ASSIGNABLE;
            }
            return res;
        }
    }
}

