/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph.matching;

import org.psjava.algo.graph.bfs.BFS;
import org.psjava.algo.graph.bfs.BFSVisitor;
import org.psjava.algo.graph.dfs.DFSVisitorBase;
import org.psjava.algo.graph.dfs.MultiSourceDFS;
import org.psjava.algo.graph.matching.MaximumBipartiteMatchingAlgorithm;
import org.psjava.algo.graph.matching.MaximumBipartiteMatchingResult;
import org.psjava.ds.Collection;
import org.psjava.ds.array.DynamicArray;
import org.psjava.ds.array.FirstInArray;
import org.psjava.ds.array.LastInArray;
import org.psjava.ds.graph.BipartiteGraph;
import org.psjava.ds.graph.BipartiteGraphEdge;
import org.psjava.ds.graph.DirectedEdge;
import org.psjava.ds.graph.EdgeFilteredSubNewGraph;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.graph.MutableDirectedGraph;
import org.psjava.ds.map.MutableMap;
import org.psjava.ds.map.ValuesInMap;
import org.psjava.goods.GoodMutableMapFactory;
import org.psjava.util.DataFilter;
import org.psjava.util.FilteredIterable;
import org.psjava.util.VisitorStopper;
import org.psjava.util.ZeroTo;

public class HopcroftKarpAlgorithm {
    public static MaximumBipartiteMatchingAlgorithm getInstance() {
        return new MaximumBipartiteMatchingAlgorithm(){

            @Override
            public <V> MaximumBipartiteMatchingResult<V> calc(BipartiteGraph<V> bg) {
                Object bfsMark;
                Collection bfsFinishes;
                Graph adj = HopcroftKarpAlgorithm.wrapAsGraph(bg);
                while (!(bfsFinishes = HopcroftKarpAlgorithm.bfs(adj, bfsMark = new Object())).isEmpty()) {
                    HopcroftKarpAlgorithm.dfs(adj, bfsFinishes, bfsMark);
                }
                return HopcroftKarpAlgorithm.createResult(adj);
            }
        };
    }

    private static <V> Graph<Vertex<V>, Edge<V>> wrapAsGraph(BipartiteGraph<V> bg) {
        MutableMap vertex = GoodMutableMapFactory.getInstance().create();
        for (Object v : bg.getLeftVertices()) {
            vertex.add(v, new Vertex(v, Side.LEFT));
        }
        for (Object v : bg.getRightVertices()) {
            vertex.add(v, new Vertex(v, Side.RIGHT));
        }
        MutableDirectedGraph<Vertex<Vertex>, Edge<Vertex>> graph = MutableDirectedGraph.create();
        for (Vertex vertex2 : ValuesInMap.get(vertex)) {
            graph.insertVertex(vertex2);
        }
        for (BipartiteGraphEdge bipartiteGraphEdge : bg.getEdges()) {
            EdgeStatus status = new EdgeStatus();
            graph.addEdge(new Edge((Vertex)vertex.get(bipartiteGraphEdge.left()), (Vertex)vertex.get(bipartiteGraphEdge.right()), status));
            graph.addEdge(new Edge((Vertex)vertex.get(bipartiteGraphEdge.right()), (Vertex)vertex.get(bipartiteGraphEdge.left()), status));
        }
        return graph;
    }

    private static <V> Collection<Vertex<V>> bfs(Graph<Vertex<V>, Edge<V>> adj, final Object mark) {
        final DynamicArray<Vertex<V>> finishes = DynamicArray.create();
        BFS.traverse(EdgeFilteredSubNewGraph.wrap(adj, new DataFilter<Edge<V>>(){

            @Override
            public boolean isAccepted(Edge<V> edge) {
                if (edge.from.side == Side.LEFT) {
                    return !edge.status.inMatch;
                }
                return edge.status.inMatch;
            }
        }), FilteredIterable.create(adj.getVertices(), new DataFilter<Vertex<V>>(){

            @Override
            public boolean isAccepted(Vertex<V> v) {
                return v.side == Side.LEFT && v.free;
            }
        }), new BFSVisitor<Vertex<V>, Edge<V>>(){
            int finishDepth = -1;

            @Override
            public void onDiscover(Vertex<V> vertex, int depth, VisitorStopper stopper) {
                if (this.finishDepth == -1 || depth <= this.finishDepth) {
                    if (vertex.side == Side.RIGHT && vertex.free) {
                        this.finishDepth = depth;
                        finishes.addToLast(vertex);
                    }
                } else {
                    stopper.stop();
                }
            }

            @Override
            public void onWalk(Edge<V> e) {
                e.status.bfsMark = mark;
            }
        });
        return finishes;
    }

    private static <V> void dfs(Graph<Vertex<V>, Edge<V>> adj, Collection<Vertex<V>> bfsFinishes, final Object bfsMark) {
        MultiSourceDFS.traverse(EdgeFilteredSubNewGraph.wrap(adj, new DataFilter<Edge<V>>(){

            @Override
            public boolean isAccepted(Edge<V> edge) {
                return edge.status.bfsMark == bfsMark;
            }
        }), bfsFinishes, new DFSVisitorBase<Vertex<V>, Edge<V>>(){
            DynamicArray<Edge<V>> path = DynamicArray.create();

            @Override
            public void onWalkDown(Edge<V> edge) {
                this.path.addToLast(edge);
            }

            @Override
            public void onWalkUp(Edge<V> downedEdge) {
                this.path.removeLast();
            }

            @Override
            public void onDiscovered(Vertex<V> v, int depth, VisitorStopper stopper) {
                if (this.wasBfsStart(v)) {
                    for (int index : ZeroTo.get(this.path.size())) {
                        this.path.get((int)index).status.inMatch = index % 2 == 0;
                    }
                    FirstInArray.getFirst(this.path).from.free = false;
                    LastInArray.getLast(this.path).to.free = false;
                }
            }

            private boolean wasBfsStart(Vertex<V> v) {
                return v.side == Side.LEFT && v.free;
            }
        });
    }

    private static <V> MaximumBipartiteMatchingResult<V> createResult(Graph<Vertex<V>, Edge<V>> adj) {
        final MutableMap match = GoodMutableMapFactory.getInstance().create();
        for (Vertex vertex : adj.getVertices()) {
            for (Edge<Vertex> e : adj.getEdges(vertex)) {
                if (!e.status.inMatch) continue;
                match.add(((Vertex)e.from()).original, ((Vertex)e.to()).original);
            }
        }
        return new MaximumBipartiteMatchingResult<V>(){

            @Override
            public V getMatchedVertex(V v) {
                return match.get(v);
            }

            @Override
            public int getMaxMatchCount() {
                return match.size() / 2;
            }

            @Override
            public boolean hasMatch(V v) {
                return match.containsKey(v);
            }
        };
    }

    private HopcroftKarpAlgorithm() {
    }

    private static class Edge<V>
    implements DirectedEdge<Vertex<V>> {
        final Vertex<V> from;
        final Vertex<V> to;
        final EdgeStatus status;

        Edge(Vertex<V> from, Vertex<V> to, EdgeStatus status) {
            this.from = from;
            this.to = to;
            this.status = status;
        }

        @Override
        public Vertex<V> from() {
            return this.from;
        }

        @Override
        public Vertex<V> to() {
            return this.to;
        }
    }

    private static class EdgeStatus {
        boolean inMatch = false;
        Object bfsMark = null;

        private EdgeStatus() {
        }
    }

    private static class Vertex<V> {
        V original;
        Side side;
        boolean free = true;

        Vertex(V original, Side side) {
            this.original = original;
            this.side = side;
        }
    }

    private static enum Side {
        LEFT,
        RIGHT;

    }
}

