/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.thresholds;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.service.reads.thresholds.WarningsSnapshot;

public class WarnAbortCounter {
    final Set<InetAddressAndPort> warnings = Collections.newSetFromMap(new ConcurrentHashMap());
    final AtomicLong maxWarningValue = new AtomicLong();
    final Set<InetAddressAndPort> aborts = Collections.newSetFromMap(new ConcurrentHashMap());
    final AtomicLong maxAbortsValue = new AtomicLong();

    void addWarning(InetAddressAndPort from, long value) {
        this.maxWarningValue.accumulateAndGet(value, Math::max);
        this.warnings.add(from);
    }

    void addAbort(InetAddressAndPort from, long value) {
        this.maxAbortsValue.accumulateAndGet(value, Math::max);
        this.aborts.add(from);
    }

    public WarningsSnapshot.Warnings snapshot() {
        return WarningsSnapshot.Warnings.create(WarningsSnapshot.Counter.create(this.warnings, this.maxWarningValue), WarningsSnapshot.Counter.create(this.aborts, this.maxAbortsValue));
    }
}

