/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.cassandra.cql3.functions.AbstractFunction;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.FunctionArguments;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.transport.ProtocolVersion;

public abstract class NativeFunction
extends AbstractFunction {
    protected NativeFunction(String name, AbstractType<?> returnType, AbstractType<?> ... argTypes) {
        super(FunctionName.nativeFunction(name), Arrays.asList(argTypes), returnType);
    }

    @Override
    public final boolean isNative() {
        return true;
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Nullable
    public NativeFunction withLegacyName() {
        return null;
    }

    @Override
    public Arguments newArguments(ProtocolVersion version) {
        return FunctionArguments.newInstanceForNativeFunction(version, this.argTypes);
    }
}

