/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.postings;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.agrona.collections.LongArrayList;
import org.apache.cassandra.index.sai.disk.ResettableByteBuffersIndexOutput;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.io.IndexOutputWriter;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.packed.DirectWriter;

@NotThreadSafe
public class PostingsWriter
implements Closeable {
    private static final int BLOCK_SIZE = 128;
    private static final String POSTINGS_MUST_BE_SORTED_ERROR_MSG = "Postings must be sorted ascending, got [%s] after [%s]";
    private final IndexOutput dataOutput;
    private final int blockSize;
    private final long[] deltaBuffer;
    private final LongArrayList blockOffsets = new LongArrayList();
    private final LongArrayList blockMaximumPostings = new LongArrayList();
    private final ResettableByteBuffersIndexOutput inMemoryOutput = new ResettableByteBuffersIndexOutput("blockOffsets");
    private final long startOffset;
    private int bufferUpto;
    private long firstPosting = Long.MIN_VALUE;
    private long lastPosting = Long.MIN_VALUE;
    private long maxDelta;
    private long totalPostings;

    public PostingsWriter(IndexDescriptor indexDescriptor, IndexIdentifier indexIdentifier) throws IOException {
        this(indexDescriptor, indexIdentifier, 128);
    }

    public PostingsWriter(IndexOutputWriter dataOutput) throws IOException {
        this(dataOutput, 128);
    }

    @VisibleForTesting
    PostingsWriter(IndexDescriptor indexDescriptor, IndexIdentifier indexIdentifier, int blockSize) throws IOException {
        this(indexDescriptor.openPerIndexOutput(IndexComponent.POSTING_LISTS, indexIdentifier, true), blockSize);
    }

    private PostingsWriter(IndexOutputWriter dataOutput, int blockSize) throws IOException {
        this.blockSize = blockSize;
        this.dataOutput = dataOutput;
        this.startOffset = dataOutput.getFilePointer();
        this.deltaBuffer = new long[blockSize];
        SAICodecUtils.writeHeader(dataOutput);
    }

    public long getFilePointer() {
        return this.dataOutput.getFilePointer();
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public void complete() throws IOException {
        SAICodecUtils.writeFooter(this.dataOutput);
    }

    @Override
    public void close() throws IOException {
        this.dataOutput.close();
    }

    public long write(PostingList postings) throws IOException {
        long posting;
        Preconditions.checkArgument((postings != null ? 1 : 0) != 0, (Object)"Expected non-null posting list.");
        Preconditions.checkArgument((postings.size() > 0L ? 1 : 0) != 0, (Object)"Expected non-empty posting list.");
        this.lastPosting = Long.MIN_VALUE;
        this.resetBlockCounters();
        this.blockOffsets.clear();
        this.blockMaximumPostings.clear();
        int size = 0;
        while ((posting = postings.nextPosting()) != Long.MAX_VALUE) {
            this.writePosting(posting);
            ++size;
            ++this.totalPostings;
        }
        assert (size > 0) : "No postings were written";
        this.finish();
        long summaryOffset = this.dataOutput.getFilePointer();
        this.writeSummary(size);
        return summaryOffset;
    }

    public long getTotalPostings() {
        return this.totalPostings;
    }

    private void writePosting(long posting) throws IOException {
        if (this.lastPosting == Long.MIN_VALUE) {
            this.firstPosting = posting;
            this.deltaBuffer[this.bufferUpto++] = 0L;
        } else {
            if (posting < this.lastPosting) {
                throw new IllegalArgumentException(String.format(POSTINGS_MUST_BE_SORTED_ERROR_MSG, posting, this.lastPosting));
            }
            long delta = posting - this.lastPosting;
            this.maxDelta = Math.max(this.maxDelta, delta);
            this.deltaBuffer[this.bufferUpto++] = delta;
        }
        this.lastPosting = posting;
        if (this.bufferUpto == this.blockSize) {
            this.addBlockToSkipTable();
            this.writePostingsBlock();
            this.resetBlockCounters();
        }
    }

    private void finish() throws IOException {
        if (this.bufferUpto > 0) {
            this.addBlockToSkipTable();
            this.writePostingsBlock();
        }
    }

    private void resetBlockCounters() {
        this.firstPosting = Long.MIN_VALUE;
        this.bufferUpto = 0;
        this.maxDelta = 0L;
    }

    private void addBlockToSkipTable() {
        this.blockOffsets.add(Long.valueOf(this.dataOutput.getFilePointer()));
        this.blockMaximumPostings.add(Long.valueOf(this.lastPosting));
    }

    private void writeSummary(int exactSize) throws IOException {
        this.dataOutput.writeVInt(this.blockSize);
        this.dataOutput.writeVInt(exactSize);
        this.writeSkipTable();
    }

    private void writeSkipTable() throws IOException {
        assert (this.blockOffsets.size() == this.blockMaximumPostings.size());
        this.dataOutput.writeVInt(this.blockOffsets.size());
        this.inMemoryOutput.reset();
        this.writeSortedFoRBlock(this.blockOffsets, this.inMemoryOutput);
        this.dataOutput.writeVLong(this.inMemoryOutput.getFilePointer());
        this.inMemoryOutput.copyTo(this.dataOutput);
        this.writeSortedFoRBlock(this.blockMaximumPostings, this.dataOutput);
    }

    private void writePostingsBlock() throws IOException {
        int bitsPerValue;
        int n = bitsPerValue = this.maxDelta == 0L ? 0 : DirectWriter.unsignedBitsRequired((long)this.maxDelta);
        if (this.firstPosting != Long.MIN_VALUE) {
            this.dataOutput.writeVLong(this.firstPosting);
        }
        this.dataOutput.writeByte((byte)bitsPerValue);
        if (bitsPerValue > 0) {
            int index;
            DirectWriter writer = DirectWriter.getInstance((DataOutput)this.dataOutput, (long)this.blockSize, (int)bitsPerValue);
            for (index = 0; index < this.bufferUpto; ++index) {
                writer.add(this.deltaBuffer[index]);
            }
            if (this.bufferUpto < this.blockSize) {
                for (index = this.bufferUpto; index < this.blockSize; ++index) {
                    writer.add(0L);
                }
            }
            writer.finish();
        }
    }

    private void writeSortedFoRBlock(LongArrayList values, IndexOutput output) throws IOException {
        long maxValue = values.getLong(values.size() - 1);
        assert (values.size() > 0);
        int bitsPerValue = maxValue == 0L ? 0 : DirectWriter.unsignedBitsRequired((long)maxValue);
        output.writeByte((byte)bitsPerValue);
        if (bitsPerValue > 0) {
            DirectWriter writer = DirectWriter.getInstance((DataOutput)output, (long)values.size(), (int)bitsPerValue);
            for (int i = 0; i < values.size(); ++i) {
                writer.add(values.getLong(i));
            }
            writer.finish();
        }
    }
}

