/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslHandler;
import java.nio.channels.ClosedChannelException;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternodeConnectionUtils {
    public static String SSL_HANDLER_NAME = "ssl";
    public static String DISCARD_HANDLER_NAME = "discard";
    public static String SSL_FACTORY_CONTEXT_DESCRIPTION = "server_encryption_options";
    private static final Logger logger = LoggerFactory.getLogger(InternodeConnectionUtils.class);

    public static Certificate[] certificates(Channel channel) {
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SSL_HANDLER_NAME);
        Certificate[] certificates = null;
        if (sslHandler != null) {
            try {
                certificates = sslHandler.engine().getSession().getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                logger.debug("Failed to get peer certificates for peer {}", (Object)channel.remoteAddress(), (Object)e);
            }
        }
        return certificates;
    }

    public static boolean isSSLError(Throwable cause) {
        return cause instanceof ClosedChannelException && cause.getCause() == null && cause.getStackTrace()[0].getClassName().contains("SslHandler") && cause.getStackTrace()[0].getMethodName().contains("channelInactive");
    }

    public static class ByteBufDiscardHandler
    extends ChannelInboundHandlerAdapter {
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof ByteBuf) {
                ((ByteBuf)msg).release();
            } else {
                ctx.fireChannelRead(msg);
            }
        }
    }
}

