/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.disk.Io;
import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.disk.ReaderSupplier;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.util.Accountable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;

public class OnDiskGraphIndex<T>
implements GraphIndex<T>,
AutoCloseable,
Accountable {
    private final ReaderSupplier readerSupplier;
    private final long neighborsOffset;
    private final int size;
    private final int entryNode;
    private final int maxDegree;
    private final int dimension;

    public OnDiskGraphIndex(ReaderSupplier readerSupplier, long offset) {
        this.readerSupplier = readerSupplier;
        this.neighborsOffset = offset + 16L;
        try (RandomAccessReader reader = readerSupplier.get();){
            reader.seek(offset);
            this.size = reader.readInt();
            this.dimension = reader.readInt();
            this.entryNode = reader.readInt();
            this.maxDegree = reader.readInt();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing OnDiskGraph at offset " + offset, e);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int maxDegree() {
        return this.maxDegree;
    }

    public OnDiskView getView() {
        return new OnDiskView(this.readerSupplier.get());
    }

    @Override
    public NodesIterator getNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ramBytesUsed() {
        return 24L;
    }

    @Override
    public void close() throws IOException {
        this.readerSupplier.close();
    }

    public static <T> void write(GraphIndex<T> graph, RandomAccessVectorValues<T> vectors, DataOutput out) throws IOException {
        assert (graph.size() == vectors.size()) : String.format("graph size %d != vectors size %d", graph.size(), vectors.size());
        GraphIndex.View<T> view = graph.getView();
        out.writeInt(graph.size());
        out.writeInt(vectors.dimension());
        out.writeInt(view.entryNode());
        out.writeInt(graph.maxDegree());
        for (int node = 0; node < graph.size(); ++node) {
            int n;
            out.writeInt(node);
            Io.writeFloats(out, (float[])vectors.vectorValue(node));
            NodesIterator neighbors = view.getNeighborsIterator(node);
            out.writeInt(neighbors.size());
            for (n = 0; n < neighbors.size(); ++n) {
                out.writeInt(neighbors.nextInt());
            }
            assert (!neighbors.hasNext());
            while (n < graph.maxDegree()) {
                out.writeInt(-1);
                ++n;
            }
        }
    }

    public class OnDiskView
    implements GraphIndex.View<T>,
    AutoCloseable {
        private final RandomAccessReader reader;
        private final int[] neighbors;

        public OnDiskView(RandomAccessReader reader) {
            this.reader = reader;
            this.neighbors = new int[OnDiskGraphIndex.this.maxDegree];
        }

        @Override
        public T getVector(int node) {
            try {
                long offset = OnDiskGraphIndex.this.neighborsOffset + (long)node * (4L + (long)OnDiskGraphIndex.this.dimension * 4L + 4L * (long)(OnDiskGraphIndex.this.maxDegree + 1)) + 4L;
                float[] vector = new float[OnDiskGraphIndex.this.dimension];
                this.reader.seek(offset);
                this.reader.readFully(vector);
                return vector;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public NodesIterator getNeighborsIterator(int node) {
            try {
                this.reader.seek(OnDiskGraphIndex.this.neighborsOffset + (long)(node + 1) * (4L + (long)OnDiskGraphIndex.this.dimension * 4L) + (long)node * 4L * (long)(OnDiskGraphIndex.this.maxDegree + 1));
                int neighborCount = this.reader.readInt();
                assert (neighborCount <= OnDiskGraphIndex.this.maxDegree) : String.format("neighborCount %d > M %d", neighborCount, OnDiskGraphIndex.this.maxDegree);
                this.reader.read(this.neighbors, 0, neighborCount);
                return new NodesIterator.ArrayNodesIterator(this.neighbors, neighborCount);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public int size() {
            return OnDiskGraphIndex.this.size();
        }

        @Override
        public int entryNode() {
            return OnDiskGraphIndex.this.entryNode;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

