/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.VertxGen;

@VertxGen
public enum OAuth2FlowType {
    AUTH_CODE("authorization_code"),
    IMPLICIT("implicit"),
    PASSWORD("password"),
    CLIENT("client_credentials"),
    AUTH_JWT("urn:ietf:params:oauth:grant-type:jwt-bearer"),
    AAD_OBO("urn:ietf:params:oauth:grant-type:jwt-bearer");

    private final String grantType;

    private OAuth2FlowType(String grantType) {
        this.grantType = grantType;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public static OAuth2FlowType getFlow(String grantType) {
        for (OAuth2FlowType flow : OAuth2FlowType.values()) {
            if (!flow.grantType.equals(grantType)) continue;
            return flow;
        }
        return null;
    }
}

