/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.livemigration;

import com.google.inject.Inject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.ext.web.RoutingContext;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.livemigration.LiveMigrationMap;

public class LiveMigrationApiEnableDisableHandler {
    final LiveMigrationMap liveMigrationMap;
    final InstancesMetadata instancesMetadata;

    @Inject
    public LiveMigrationApiEnableDisableHandler(LiveMigrationMap liveMigrationMap, InstancesMetadata instancesMetadata) {
        this.liveMigrationMap = liveMigrationMap;
        this.instancesMetadata = instancesMetadata;
    }

    public void isSource(RoutingContext rc) {
        InstanceMetadata instanceMeta = this.getLocalInstanceMeta(rc);
        if (this.liveMigrationMap.isSource(instanceMeta)) {
            rc.next();
        } else {
            rc.fail(HttpResponseStatus.NOT_FOUND.code());
        }
    }

    public void isDestination(RoutingContext rc) {
        InstanceMetadata instanceMeta = this.getLocalInstanceMeta(rc);
        if (this.liveMigrationMap.isDestination(instanceMeta)) {
            rc.next();
        } else {
            rc.fail(HttpResponseStatus.NOT_FOUND.code());
        }
    }

    public void isSourceOrDestination(RoutingContext rc) {
        InstanceMetadata instanceMeta = this.getLocalInstanceMeta(rc);
        if (this.liveMigrationMap.isAny(instanceMeta)) {
            rc.next();
        } else {
            rc.fail(HttpResponseStatus.NOT_FOUND.code());
        }
    }

    private InstanceMetadata getLocalInstanceMeta(RoutingContext rc) {
        String host = AbstractHandler.extractHostAddressWithoutPort(rc.request());
        return this.instancesMetadata.instanceFromHost(host);
    }
}

