/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.NameValidationHelper;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class DbRelationshipValidator
extends ConfigurationNodeValidator {
    DbRelationshipValidator() {
    }

    void validate(DbRelationship relationship, ValidationResult validationResult) {
        if (relationship.getTargetEntity() == null) {
            this.addFailure(validationResult, relationship, "DbRelationship '%s' has no target entity", this.toString(relationship));
        } else if (relationship.getJoins().isEmpty()) {
            this.addFailure(validationResult, relationship, "DbRelationship '%s' has no joins", this.toString(relationship));
        } else {
            for (DbJoin join : relationship.getJoins()) {
                if (join.getSource() == null && join.getTarget() == null) {
                    this.addFailure(validationResult, relationship, "DbRelationship '%s' has a join with no source and target attributes selected", this.toString(relationship));
                    continue;
                }
                if (join.getSource() == null) {
                    this.addFailure(validationResult, relationship, "DbRelationship '%s' has a join with no source attribute selected", this.toString(relationship));
                    continue;
                }
                if (join.getTarget() != null) continue;
                this.addFailure(validationResult, relationship, "DbRelationship '%s' has a join with no target attribute selected", this.toString(relationship));
            }
        }
        if (Util.isEmptyString(relationship.getName())) {
            this.addFailure(validationResult, relationship, "Unnamed DbRelationship", new Object[0]);
        } else if (relationship.getSourceEntity().getAttribute(relationship.getName()) != null) {
            this.addFailure(validationResult, relationship, "Name of DbRelationship '%s' conflicts with the name of one of DbAttributes in the same entity", this.toString(relationship));
        } else {
            NameValidationHelper helper = NameValidationHelper.getInstance();
            String invalidChars = helper.invalidCharsInDbPathComponent(relationship.getName());
            if (invalidChars != null) {
                this.addFailure(validationResult, relationship, "Name of DbRelationship '%s' contains invalid characters: %s", this.toString(relationship), invalidChars);
            }
        }
        this.checkForDuplicates(relationship, validationResult);
        this.checkOnGeneratedStrategyConflict(relationship, validationResult);
        this.checkToMany(relationship, validationResult);
    }

    private void checkToMany(DbRelationship relationship, ValidationResult validationResult) {
        if (relationship != null && relationship.getReverseRelationship() != null && relationship.isToMany() && relationship.getReverseRelationship().isToMany()) {
            this.addFailure(validationResult, relationship, "Relationship '%s' and reverse '%s' are both toMany", relationship.getName(), relationship.getReverseRelationship().getName());
        }
        this.checkTypesOfAttributesInRelationship(relationship, validationResult);
    }

    private void checkTypesOfAttributesInRelationship(DbRelationship relationship, ValidationResult validationResult) {
        for (DbJoin join : relationship.getJoins()) {
            if (join.getSource() == null || join.getTarget() == null || join.getSource().getType() == join.getTarget().getType()) continue;
            this.addFailure(validationResult, relationship, "Attributes '%s' and '%s' have different types in a relationship '%s'", join.getSourceName(), join.getTargetName(), relationship.getName());
        }
    }

    private void checkOnGeneratedStrategyConflict(DbRelationship relationship, ValidationResult validationResult) {
        if (relationship.isToDependentPK()) {
            Collection<DbAttribute> attributes = relationship.getTargetEntity().getGeneratedAttributes();
            for (DbAttribute attribute : attributes) {
                if (!attribute.isGenerated()) continue;
                this.addFailure(validationResult, relationship, "'To Dep Pk' incompatible with Database-Generated on '%s' relationship", this.toString(relationship));
            }
        }
    }

    private void checkForDuplicates(DbRelationship relationship, ValidationResult validationResult) {
        if (relationship != null && relationship.getName() != null && relationship.getTargetEntityName() != null) {
            String dbRelationshipPath = relationship.getTargetEntityName() + "." + this.getJoins(relationship);
            DbEntity entity = relationship.getSourceEntity();
            for (DbRelationship comparisonRelationship : entity.getRelationships()) {
                String comparisonDbRelationshipPath;
                if (relationship == comparisonRelationship || !dbRelationshipPath.equals(comparisonDbRelationshipPath = comparisonRelationship.getTargetEntityName() + "." + this.getJoins(comparisonRelationship))) continue;
                this.addFailure(validationResult, relationship, "DbEntity '%s' contains a duplicate DbRelationship mapping ('%s' -> '%s')", entity.getName(), relationship.getName(), dbRelationshipPath);
                return;
            }
        }
    }

    private String getJoins(DbRelationship relationship) {
        ArrayList<String> joins = new ArrayList<String>();
        for (DbJoin join : relationship.getJoins()) {
            joins.add("[source=" + join.getSourceName() + ",target=" + join.getTargetName() + "]");
        }
        Collections.sort(joins);
        return Util.join(joins, ",");
    }

    private String toString(DbRelationship relationship) {
        if (relationship.getSourceEntity() == null) {
            return "[null source entity]." + relationship.getName();
        }
        return relationship.getSourceEntity().getName() + "." + relationship.getName();
    }
}

