/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.components.labels;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;

public class RichTextValue
implements Serializable,
Cloneable {
    public static RTFEditorKit editorKit = new RTFEditorKit();
    protected String richText;
    protected String plainText;

    public RichTextValue() {
    }

    public RichTextValue(Document document) {
        this.setRichText(RichTextValue.getRichText(document));
    }

    public RichTextValue(String string) {
        this(RichTextValue.createDefaultDocument(string));
    }

    public void insertInto(Document document) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.richText.getBytes());
        try {
            document.remove(0, document.getLength());
            editorKit.read(byteArrayInputStream, document, 0);
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getRichText() {
        return this.richText;
    }

    public void setRichText(String string) {
        this.richText = string;
        this.plainText = RichTextValue.getPlainText(this);
    }

    public String toString() {
        return this.plainText;
    }

    public static String getRichText(Document document) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            editorKit.write(byteArrayOutputStream, document, 0, document.getLength());
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static String getPlainText(RichTextValue richTextValue) {
        Document document = RichTextValue.createDefaultDocument();
        richTextValue.insertInto(document);
        try {
            return document.getText(0, document.getLength()).trim();
        }
        catch (BadLocationException badLocationException) {
            return richTextValue.getRichText();
        }
    }

    protected static Document createDefaultDocument() {
        return RichTextValue.createDefaultDocument(null);
    }

    public static Document createDefaultDocument(String string) {
        Document document = editorKit.createDefaultDocument();
        if (string != null) {
            try {
                document.insertString(0, string, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return document;
    }
}

