/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db.merge;

import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.merge.DataMapMerger;
import org.apache.cayenne.dbsync.merge.context.MergeDirection;
import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactoryProvider;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.AbstractToDbToken;
import org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator;
import org.apache.cayenne.dbsync.naming.NoStemStemmer;
import org.apache.cayenne.dbsync.reverse.dbimport.DefaultDbImportAction;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DefaultModelMergeDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.LoggingDbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.ModelMergeDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.ProxyModelMergeDelegate;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.TableFilter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ValidationResultBrowser;
import org.apache.cayenne.modeler.dialog.db.merge.MergerOptionsView;
import org.apache.cayenne.modeler.dialog.db.merge.MergerTokenSelectorController;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.validation.ValidationResult;
import org.slf4j.LoggerFactory;

public class MergerOptions
extends CayenneController {
    protected MergerOptionsView view;
    protected ObjectBinding sqlBinding;
    protected DBConnectionInfo connectionInfo;
    protected DataMap dataMap;
    protected DbAdapter adapter;
    protected String textForSQL;
    protected MergerTokenSelectorController tokens;
    protected String defaultCatalog;
    protected String defaultSchema;
    private MergerTokenFactoryProvider mergerTokenFactoryProvider;

    public MergerOptions(ProjectController parent, String title, DBConnectionInfo connectionInfo, DataMap dataMap, String defaultCatalog, String defaultSchema, MergerTokenFactoryProvider mergerTokenFactoryProvider) {
        super(parent);
        this.mergerTokenFactoryProvider = mergerTokenFactoryProvider;
        this.dataMap = dataMap;
        this.tokens = new MergerTokenSelectorController(parent);
        this.view = new MergerOptionsView(this.tokens.getView());
        this.connectionInfo = connectionInfo;
        this.defaultCatalog = defaultCatalog;
        this.defaultSchema = defaultSchema;
        this.view.setTitle(title);
        this.initController();
        this.prepareMigrator();
        this.createSQL();
        this.refreshView();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    public String getTextForSQL() {
        return this.textForSQL;
    }

    protected void initController() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        this.sqlBinding = builder.bindToTextArea(this.view.getSql(), "textForSQL");
        builder.bindToAction(this.view.getGenerateButton(), "generateSchemaAction()");
        builder.bindToAction(this.view.getSaveSqlButton(), "storeSQLAction()");
        builder.bindToAction(this.view.getCancelButton(), "closeAction()");
        this.view.getTabs().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (MergerOptions.this.view.getTabs().getSelectedIndex() == 1) {
                    MergerOptions.this.refreshGeneratorAction();
                }
            }
        });
    }

    protected void prepareMigrator() {
        try {
            DataMap dbImport;
            this.adapter = this.connectionInfo.makeAdapter(this.getApplication().getClassLoadingService());
            MergerTokenFactory mergerTokenFactory = (MergerTokenFactory)this.mergerTokenFactoryProvider.get(this.adapter);
            this.tokens.setMergerTokenFactory(mergerTokenFactory);
            FiltersConfig filters = FiltersConfig.create(this.defaultCatalog, this.defaultSchema, TableFilter.everything(), PatternFilter.INCLUDE_NOTHING);
            DataMapMerger merger = DataMapMerger.builder(mergerTokenFactory).filters(filters).build();
            DbLoaderConfiguration config = new DbLoaderConfiguration();
            config.setFiltersConfig(filters);
            DataSource dataSource = this.connectionInfo.makeDataSource(this.getApplication().getClassLoadingService());
            try (Connection conn = dataSource.getConnection();){
                dbImport = new DbLoader(this.adapter, conn, config, new LoggingDbLoaderDelegate(LoggerFactory.getLogger(DbLoader.class)), new DefaultObjectNameGenerator(NoStemStemmer.getInstance())).load();
            }
            catch (SQLException e) {
                throw new CayenneRuntimeException("Can't doLoad dataMap from db.", (Throwable)e, new Object[0]);
            }
            this.tokens.setTokens(merger.createMergeTokens(this.dataMap, dbImport));
        }
        catch (Exception ex) {
            this.reportError("Error loading adapter", ex);
        }
    }

    protected void createSQL() {
        Object lineEnd;
        StringBuilder buf = new StringBuilder();
        Iterator<MergerToken> it = this.tokens.getSelectedTokens().iterator();
        String batchTerminator = this.adapter.getBatchTerminator();
        Object object = lineEnd = batchTerminator != null ? "\n" + batchTerminator + "\n\n" : "\n\n";
        while (it.hasNext()) {
            MergerToken token = it.next();
            if (!(token instanceof AbstractToDbToken)) continue;
            AbstractToDbToken tdb = (AbstractToDbToken)token;
            for (String sql : tdb.createSql(this.adapter)) {
                buf.append(sql);
                buf.append((String)lineEnd);
            }
        }
        this.textForSQL = buf.toString();
    }

    protected void refreshView() {
        this.sqlBinding.updateView();
    }

    public void startupAction() {
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    public void refreshGeneratorAction() {
        this.refreshSQLAction();
    }

    public void refreshSQLAction() {
        this.createSQL();
        this.sqlBinding.updateView();
    }

    public void generateSchemaAction() {
        DataSource dataSource;
        this.refreshGeneratorAction();
        List<MergerToken> tokensToMigrate = this.tokens.getSelectedTokens();
        if (tokensToMigrate.isEmpty()) {
            JOptionPane.showMessageDialog(this.getView(), "Nothing to migrate.");
            return;
        }
        try {
            dataSource = this.connectionInfo.makeDataSource(this.getApplication().getClassLoadingService());
        }
        catch (SQLException ex) {
            this.reportError("Migration Error", ex);
            return;
        }
        LinkedList<ObjEntity> loadedObjEntities = new LinkedList<ObjEntity>();
        MergerContext mergerContext = MergerContext.builder(this.dataMap).syntheticDataNode(dataSource, this.adapter).delegate(this.createDelegate(loadedObjEntities)).build();
        boolean modelChanged = this.applyTokens(tokensToMigrate, mergerContext);
        DefaultDbImportAction.flattenManyToManyRelationships(this.dataMap, loadedObjEntities, mergerContext.getNameGenerator());
        this.notifyProjectModified(modelChanged);
        this.reportFailures(mergerContext);
        if (this.tokens.isReverse()) {
            this.getApplication().getUndoManager().discardAllEdits();
        }
    }

    private ModelMergeDelegate createDelegate(final Collection<ObjEntity> loadedObjEntities) {
        return new ProxyModelMergeDelegate(new DefaultModelMergeDelegate()){

            @Override
            public void objEntityAdded(ObjEntity ent) {
                loadedObjEntities.add(ent);
                super.objEntityAdded(ent);
            }
        };
    }

    private boolean applyTokens(List<MergerToken> tokensToMigrate, MergerContext mergerContext) {
        boolean modelChanged = false;
        try {
            for (MergerToken tok : tokensToMigrate) {
                int numOfFailuresBefore = this.getFailuresCount(mergerContext);
                tok.execute(mergerContext);
                if (!modelChanged && tok.getDirection().equals((Object)MergeDirection.TO_MODEL)) {
                    modelChanged = true;
                }
                if (numOfFailuresBefore != this.getFailuresCount(mergerContext)) continue;
                this.tokens.removeToken(tok);
            }
        }
        catch (Throwable th) {
            this.reportError("Migration Error", th);
        }
        return modelChanged;
    }

    private int getFailuresCount(MergerContext mergerContext) {
        return mergerContext.getValidationResult().getFailures().size();
    }

    private void reportFailures(MergerContext mergerContext) {
        ValidationResult failures = mergerContext.getValidationResult();
        if (failures == null || !failures.hasFailures()) {
            JOptionPane.showMessageDialog(this.getView(), "Migration Complete.");
        } else {
            new ValidationResultBrowser(this).startupAction("Migration Complete", "Migration finished. The following problem(s) were ignored.", failures);
        }
    }

    private void notifyProjectModified(boolean modelChanged) {
        if (!modelChanged) {
            return;
        }
        Project project = this.getApplication().getProject();
        project.setModified(true);
        ProjectController projectController = this.getProjectController();
        projectController.setDirty(true);
        projectController.fireDataMapEvent(new DataMapEvent((Object)Application.getFrame(), this.dataMap, 3));
        projectController.fireDataMapEvent(new DataMapEvent((Object)Application.getFrame(), this.dataMap, 2));
    }

    public void storeSQLAction() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogType(1);
        fc.setDialogTitle("Save SQL Script");
        Resource projectDir = this.getApplication().getProject().getConfigurationResource();
        if (projectDir != null) {
            fc.setCurrentDirectory(new File(projectDir.getURL().getPath()));
        }
        if (fc.showSaveDialog(this.getView()) == 0) {
            this.refreshGeneratorAction();
            try {
                File file = fc.getSelectedFile();
                FileWriter fw = new FileWriter(file);
                PrintWriter pw = new PrintWriter(fw);
                pw.print(this.textForSQL);
                pw.flush();
                pw.close();
            }
            catch (IOException ex) {
                this.reportError("Error Saving SQL", ex);
            }
        }
    }

    private ProjectController getProjectController() {
        return this.getApplication().getFrameController().getProjectController();
    }

    public void closeAction() {
        this.view.dispose();
    }
}

