/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import java.security.Key;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.crypto.key.KeySource;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.DefaultValueDecryptor;
import org.apache.cayenne.crypto.transformer.value.DefaultValueEncryptor;
import org.apache.cayenne.crypto.transformer.value.ValueDecryptor;
import org.apache.cayenne.crypto.transformer.value.ValueEncryptor;
import org.apache.cayenne.crypto.transformer.value.ValueTransformerFactory;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValueTransformerFactory
implements ValueTransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultValueTransformerFactory.class);
    public static final String DB_TO_BYTE_CONVERTERS_KEY = "org.apache.cayenne.crypto.transformer.value.DefaultValueTransformerFactory.dbToBytes";
    public static final String OBJECT_TO_BYTE_CONVERTERS_KEY = "org.apache.cayenne.crypto.transformer.value.DefaultValueTransformerFactory.objectToBytes";
    private final Key defaultKey;
    private final Map<String, BytesConverter<?>> objectToBytes;
    private final Map<Integer, BytesConverter<?>> dbToBytes;
    private final ConcurrentMap<DbAttribute, ValueEncryptor> encryptors;
    private final ConcurrentMap<DbAttribute, ValueDecryptor> decryptors;

    public DefaultValueTransformerFactory(@Inject KeySource keySource, @Inject(value="org.apache.cayenne.crypto.transformer.value.DefaultValueTransformerFactory.dbToBytes") Map<String, BytesConverter<?>> dbToBytes, @Inject(value="org.apache.cayenne.crypto.transformer.value.DefaultValueTransformerFactory.objectToBytes") Map<String, BytesConverter<?>> objectToBytes) {
        this.defaultKey = keySource.getKey(keySource.getDefaultKeyAlias());
        this.encryptors = new ConcurrentHashMap<DbAttribute, ValueEncryptor>();
        this.decryptors = new ConcurrentHashMap<DbAttribute, ValueDecryptor>();
        this.objectToBytes = objectToBytes;
        HashMap m = new HashMap();
        for (Map.Entry<String, BytesConverter<?>> extraConverter : dbToBytes.entrySet()) {
            m.put(Integer.valueOf(extraConverter.getKey()), extraConverter.getValue());
        }
        this.dbToBytes = m;
    }

    @Override
    public ValueDecryptor decryptor(DbAttribute a) {
        ValueDecryptor e = (ValueDecryptor)this.decryptors.get(a);
        if (e == null) {
            ValueDecryptor newTransformer = this.createDecryptor(a);
            ValueDecryptor oldTransformer = this.decryptors.putIfAbsent(a, newTransformer);
            e = oldTransformer != null ? oldTransformer : newTransformer;
        }
        return e;
    }

    @Override
    public ValueEncryptor encryptor(DbAttribute a) {
        ValueEncryptor e = (ValueEncryptor)this.encryptors.get(a);
        if (e == null) {
            ValueEncryptor newTransformer = this.createEncryptor(a);
            ValueEncryptor oldTransformer = this.encryptors.putIfAbsent(a, newTransformer);
            e = oldTransformer != null ? oldTransformer : newTransformer;
        }
        return e;
    }

    protected ValueEncryptor createEncryptor(DbAttribute a) {
        String type = this.getJavaType(a);
        BytesConverter<?> toBytes = this.objectToBytes.get(type);
        if (toBytes == null) {
            throw new IllegalArgumentException("The type " + type + " for attribute " + String.valueOf(a) + " has no object-to-bytes conversion");
        }
        BytesConverter<?> fromBytes = this.dbToBytes.get(a.getType());
        if (fromBytes == null) {
            throw new IllegalArgumentException("The type " + TypesMapping.getSqlNameByType((int)a.getType()) + " for attribute " + String.valueOf(a) + " has no bytes-to-db conversion");
        }
        return new DefaultValueEncryptor(toBytes, fromBytes);
    }

    protected ValueDecryptor createDecryptor(DbAttribute a) {
        BytesConverter<?> toBytes = this.dbToBytes.get(a.getType());
        if (toBytes == null) {
            throw new IllegalArgumentException("The type " + TypesMapping.getSqlNameByType((int)a.getType()) + " for attribute " + String.valueOf(a) + " has no db-to-bytes conversion");
        }
        String type = this.getJavaType(a);
        BytesConverter<?> fromBytes = this.objectToBytes.get(type);
        if (fromBytes == null) {
            throw new IllegalArgumentException("The type " + type + " for attribute " + String.valueOf(a) + " has no bytes-to-object conversion");
        }
        return new DefaultValueDecryptor(toBytes, fromBytes, this.defaultKey);
    }

    protected String getJavaType(DbAttribute a) {
        DbEntity dbEntity = a.getEntity();
        DataMap dataMap = dbEntity.getDataMap();
        HashSet<String> javaTypes = new HashSet<String>();
        for (ObjEntity objEntity : dataMap.getMappedEntities(dbEntity)) {
            for (ObjAttribute oa : objEntity.getAttributes()) {
                if (oa.getDbAttributePath().length() > 1 || !a.getName().equals(oa.getDbAttributePath().first().value())) continue;
                javaTypes.add(oa.getType());
            }
        }
        if (javaTypes.size() != 1) {
            String javaType = TypesMapping.getJavaBySqlType((DbAttribute)a);
            String attributeName = dbEntity.getName() + "." + a.getName();
            String msg = javaTypes.size() > 1 ? "ObjAttributes with different java types" : "No ObjAttributes";
            logger.warn(msg + " bound to DbAttribute '" + attributeName + "', " + javaType + " type will be used.");
            return javaType;
        }
        return (String)javaTypes.iterator().next();
    }
}

