/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetNotNullToDb
extends AbstractToDbToken.EntityAndColumn {
    public SetNotNullToDb(DbEntity entity, DbAttribute column) {
        super(entity, column);
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        StringBuilder sqlBuffer = new StringBuilder();
        QuotingStrategy context = adapter.getQuotingStrategy(this.getEntity().getDataMap().isQuotingSQLIdentifiers());
        sqlBuffer.append("ALTER TABLE ");
        sqlBuffer.append(context.quoteFullyQualifiedName(this.getEntity()));
        sqlBuffer.append(" ALTER COLUMN ");
        sqlBuffer.append(context.quoteString(this.getColumn().getName()));
        sqlBuffer.append(" SET NOT NULL");
        return Collections.singletonList(sqlBuffer.toString());
    }

    @Override
    public String getTokenName() {
        return "Set Not Null";
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createSetAllowNullToModel(this.getEntity(), this.getColumn());
    }
}

