/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.PrintWriter;
import java.sql.Driver;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.AbstractDbLoaderDelegate;
import org.apache.cayenne.access.DbLoader;
import org.apache.cayenne.access.DbLoaderDelegate;
import org.apache.cayenne.conn.DriverDataSource;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.naming.NamingStrategy;
import org.apache.cayenne.tools.CayenneTask;
import org.apache.cayenne.util.DeleteRuleUpdater;
import org.apache.cayenne.util.Util;
import org.apache.tools.ant.BuildException;

public class DbImporterTask
extends CayenneTask {
    private boolean overwriteExisting = true;
    private String schemaName;
    private String tablePattern;
    private boolean importProcedures = false;
    private String procedurePattern;
    private boolean meaningfulPk = false;
    private String namingStrategy = "org.apache.cayenne.map.naming.SmartNamingStrategy";

    public void execute() {
        this.log(String.format("connection settings - [driver: %s, url: %s, username: %s, password: %s]", this.driver, this.url, this.userName, this.password), 3);
        this.log(String.format("importer options - [map: %s, overwriteExisting: %s, schemaName: %s, tablePattern: %s, importProcedures: %s, procedurePattern: %s, meaningfulPk: %s, namingStrategy: %s]", this.map, this.overwriteExisting, this.schemaName, this.tablePattern, this.importProcedures, this.procedurePattern, this.meaningfulPk, this.namingStrategy), 3);
        this.validateAttributes();
        try {
            DriverDataSource dataSource = new DriverDataSource((Driver)Class.forName(this.driver).newInstance(), this.url, this.userName, this.password);
            LoaderDelegate loaderDelegate = new LoaderDelegate();
            DbLoader loader = new DbLoader(dataSource.getConnection(), this.adapter, (DbLoaderDelegate)loaderDelegate);
            loader.setCreatingMeaningfulPK(this.meaningfulPk);
            if (this.namingStrategy != null) {
                NamingStrategy namingStrategyInst = (NamingStrategy)Class.forName(this.namingStrategy).newInstance();
                loader.setNamingStrategy(namingStrategyInst);
            }
            DataMap dataMap = this.map.exists() ? this.loadDataMap() : new DataMap();
            loader.loadDataMapFromDB(this.schemaName, this.tablePattern, dataMap);
            for (ObjEntity addedObjEntity : loaderDelegate.getAddedObjEntities()) {
                DeleteRuleUpdater.updateObjEntity((ObjEntity)addedObjEntity);
            }
            if (this.importProcedures) {
                loader.loadProceduresFromDB(this.schemaName, this.procedurePattern, dataMap);
            }
            this.map.delete();
            PrintWriter pw = new PrintWriter(this.map);
            dataMap.encodeAsXML(pw);
            pw.close();
        }
        catch (Exception ex) {
            Throwable th = Util.unwindException((Throwable)ex);
            String message = "Error importing database schema";
            if (th.getLocalizedMessage() != null) {
                message = message + ": " + th.getLocalizedMessage();
            }
            this.log(message, 0);
            throw new BuildException(message, th);
        }
    }

    protected void validateAttributes() throws BuildException {
        StringBuilder error = new StringBuilder("");
        if (this.map == null) {
            error.append("The 'map' attribute must be set.\n");
        }
        if (this.driver == null) {
            error.append("The 'driver' attribute must be set.\n");
        }
        if (this.url == null) {
            error.append("The 'adapter' attribute must be set.\n");
        }
        if (error.length() > 0) {
            throw new BuildException(error.toString());
        }
    }

    public void setOverwriteExisting(boolean overwriteExisting) {
        this.overwriteExisting = overwriteExisting;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTablePattern(String tablePattern) {
        this.tablePattern = tablePattern;
    }

    public void setImportProcedures(boolean importProcedures) {
        this.importProcedures = importProcedures;
    }

    public void setProcedurePattern(String procedurePattern) {
        this.procedurePattern = procedurePattern;
    }

    public void setMeaningfulPk(boolean meaningfulPk) {
        this.meaningfulPk = meaningfulPk;
    }

    public void setNamingStrategy(String namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    final class LoaderDelegate
    extends AbstractDbLoaderDelegate {
        LoaderDelegate() {
        }

        public boolean overwriteDbEntity(DbEntity ent) throws CayenneException {
            return DbImporterTask.this.overwriteExisting;
        }

        public void dbEntityAdded(DbEntity ent) {
            super.dbEntityAdded(ent);
            DbImporterTask.this.log("Added DB entity: " + ent.getName());
        }

        public void dbEntityRemoved(DbEntity ent) {
            super.dbEntityRemoved(ent);
            DbImporterTask.this.log("Removed DB entity: " + ent.getName());
        }

        public void objEntityAdded(ObjEntity ent) {
            super.objEntityAdded(ent);
            DbImporterTask.this.log("Added obj entity: " + ent.getName());
        }

        public void objEntityRemoved(ObjEntity ent) {
            super.objEntityRemoved(ent);
            DbImporterTask.this.log("Removed obj entity: " + ent.getName());
        }
    }
}

