/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.select;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.select.DiscriminatorBuilder;
import org.apache.cayenne.access.select.EntityRowReader;
import org.apache.cayenne.access.select.EntitySegment;
import org.apache.cayenne.access.select.EntitySegmentBuilder;
import org.apache.cayenne.access.select.EntitySelectColumn;
import org.apache.cayenne.access.select.EntityTreeRowReader;
import org.apache.cayenne.access.select.RowReader;
import org.apache.cayenne.access.select.SelectDescriptor;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTTrue;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.reflect.ClassDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntityTreeSegmentBuilder {
    private QueryMetadata metadata;
    protected ExtendedTypeMap extendedTypes;
    private List<Expression> entityQualifiers;
    private List<RowReader<?>> entityReaders;
    protected ClassDescriptor classDescriptor;
    protected List<EntitySelectColumn> columns;
    protected Map<String, Integer> columnMap;

    EntityTreeSegmentBuilder(QueryMetadata metadata, ExtendedTypeMap extendedTypes, ClassDescriptor classDescriptor) {
        this.metadata = metadata;
        this.extendedTypes = extendedTypes;
        this.classDescriptor = classDescriptor;
        this.entityQualifiers = new ArrayList<Expression>();
        this.entityReaders = new ArrayList();
        this.columns = new ArrayList<EntitySelectColumn>();
        this.columnMap = new HashMap<String, Integer>();
    }

    SelectDescriptor<Object> buildSegment() {
        EntityInheritanceTree inheritanceTree = this.classDescriptor.getEntityInheritanceTree();
        if (inheritanceTree != null) {
            return this.buildNonLeafSegment(inheritanceTree);
        }
        return this.buildLeafSegment();
    }

    SelectDescriptor<Object> buildLeafSegment() {
        EntityRowReader rowReader = this.processSuperclasses(this.classDescriptor.getEntity());
        return new EntitySegment(rowReader, this.columns);
    }

    SelectDescriptor<Object> buildNonLeafSegment(EntityInheritanceTree inheritanceTree) {
        EntityRowReader superRowReader = null;
        ObjEntity superEntity = this.classDescriptor.getEntity().getSuperEntity();
        if (superEntity != null) {
            superRowReader = this.processSuperclasses(superEntity);
        }
        this.processSubclasses(inheritanceTree, superRowReader);
        EntityRowReader discriminatorReader = this.mergeColumns(null, new DiscriminatorBuilder(this.extendedTypes, inheritanceTree).buildColumns());
        int size = this.entityQualifiers.size();
        Expression[] entityQualifiers = this.entityQualifiers.toArray(new Expression[size]);
        RowReader[] entityReaders = this.entityReaders.toArray(new RowReader[size]);
        EntityTreeRowReader rowReader = new EntityTreeRowReader(discriminatorReader, entityQualifiers, entityReaders);
        return new EntitySegment(rowReader, this.columns);
    }

    private EntityRowReader mergeColumns(String entityName, List<EntitySelectColumn> columnsToMerge) {
        int[] indexes = new int[columnsToMerge.size()];
        for (int i = 0; i < indexes.length; ++i) {
            EntitySelectColumn column = columnsToMerge.get(i);
            Integer columnIndex = this.columnMap.get(column.getDataRowKey());
            if (columnIndex == null) {
                columnIndex = this.columns.size();
                this.columnMap.put(column.getDataRowKey(), columnIndex);
                this.columns.add(column);
            }
            indexes[i] = columnIndex + 1;
        }
        return new EntityRowReader(entityName, columnsToMerge, indexes);
    }

    private EntityRowReader processSuperclasses(ObjEntity entity) {
        List<EntitySelectColumn> entityColumns = new EntitySegmentBuilder(this.metadata, this.extendedTypes, entity).buildColumns();
        EntityRowReader rowReader = this.mergeColumns(entity.getName(), entityColumns);
        ObjEntity superEntity = entity.getSuperEntity();
        if (superEntity != null) {
            rowReader.setSuperReader(this.processSuperclasses(superEntity));
        }
        return rowReader;
    }

    private void processSubclasses(EntityInheritanceTree node, EntityRowReader superReader) {
        EntityRowReader reader = this.processSubclass(node);
        reader.setSuperReader(superReader);
        for (EntityInheritanceTree childNode : node.getChildren()) {
            this.processSubclasses(childNode, reader);
        }
    }

    private EntityRowReader processSubclass(EntityInheritanceTree node) {
        List<EntitySelectColumn> entityColumns = new EntitySegmentBuilder(this.metadata, this.extendedTypes, node.getEntity()).buildColumns();
        EntityRowReader rowReader = this.mergeColumns(node.getEntity().getName(), entityColumns);
        if (!node.getEntity().isAbstract()) {
            Expression qualifier = node.getDbQualifier();
            if (qualifier == null) {
                qualifier = new ASTTrue();
            }
            this.entityQualifiers.add(qualifier);
            this.entityReaders.add(rowReader);
        }
        return rowReader;
    }
}

