/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.view.swing;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Beans;
import javax.swing.JRadioButton;
import javax.swing.JToolTip;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.Control;
import org.scopemvc.core.Controller;
import org.scopemvc.core.PropertyView;
import org.scopemvc.core.Selector;
import org.scopemvc.util.UIStrings;
import org.scopemvc.view.swing.Refreshable;
import org.scopemvc.view.swing.SwingBoundModel;
import org.scopemvc.view.swing.SwingUtil;
import org.scopemvc.view.swing.ValidationHelper;
import org.scopemvc.view.util.ModelBindable;

public class SRadioButton
extends JRadioButton
implements PropertyView,
ItemListener,
ModelBindable,
Refreshable {
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$view$swing$SRadioButton == null ? (class$org$scopemvc$view$swing$SRadioButton = SRadioButton.class$("org.scopemvc.view.swing.SRadioButton")) : class$org$scopemvc$view$swing$SRadioButton);
    private SwingBoundModel boundModel = new SwingBoundModel(this);
    private ValidationHelper validationHelper = new ValidationHelper(this);
    private String controlID;
    private boolean valueIsNull = false;
    private boolean readOnly = false;
    private boolean userEnabled = true;
    static /* synthetic */ Class class$org$scopemvc$view$swing$SRadioButton;

    public SRadioButton() {
        this.addItemListener(this);
        this.setReadOnly(!Beans.isDesignTime());
    }

    public SRadioButton(String string) {
        this();
        this.setControlID(string);
    }

    public SRadioButton(String string, Selector selector) {
        this();
        this.setControlID(string);
        this.setSelector(selector);
    }

    public final Object getBoundModel() {
        return this.boundModel.getBoundModel();
    }

    public final Selector getSelector() {
        return this.boundModel.getSelector();
    }

    public final String getControlID() {
        return this.controlID;
    }

    public Object getViewValue() {
        if (this.valueIsNull) {
            return null;
        }
        if (this.isSelected()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Controller getController() {
        return null;
    }

    public void issueControl(Control control) {
        SwingUtil.issueControl(this, control);
    }

    public final void setControlID(String string) {
        this.controlID = string;
        if (this.controlID != null && (this.getText() == null || this.getText().length() == 0)) {
            this.setText(UIStrings.get(this.controlID));
        }
    }

    public final void setSelector(Selector selector) {
        this.boundModel.setSelector(selector);
    }

    public void setEnabled(boolean bl) {
        this.userEnabled = bl;
        super.setEnabled(this.userEnabled && !this.readOnly);
    }

    public void setBoundModel(Object object) {
        this.boundModel.setBoundModel(object);
    }

    public void setSelector(String string) {
        this.boundModel.setSelector(string);
    }

    public void setSelectorString(String string) {
        this.setSelector(string);
    }

    public void setSelected(boolean bl) {
        if (bl && !this.isSelected()) {
            super.setSelected(true);
        } else if (!bl && this.isSelected()) {
            super.setSelected(false);
        }
    }

    public void setController(Controller controller) {
        throw new UnsupportedOperationException("Can't assign a Controller to a " + this.getClass());
    }

    public void updateFromProperty(Object object, boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateFromProperty: " + object + ", " + bl);
        }
        if (object == null) {
            this.valueIsNull = true;
            this.setReadOnly(true);
            return;
        }
        if (!(object instanceof Boolean)) {
            LOG.warn("Expecting a Boolean property, not a property of type " + object.getClass() + ", property selector is " + Selector.asString(this.getSelector()));
            this.valueIsNull = true;
            this.setReadOnly(true);
            return;
        }
        this.valueIsNull = false;
        this.setReadOnly(bl);
        boolean bl2 = (Boolean)object;
        this.setSelected(bl2);
    }

    public void validationFailed(Exception exception) {
        this.validationHelper.validationFailed(exception);
    }

    public void validationSuccess() {
        this.validationHelper.validationSuccess();
    }

    public JToolTip createToolTip() {
        return this.validationHelper.createToolTip(super.createToolTip());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.valueIsNull = false;
        if (this.isEnabled()) {
            this.boundModel.updateModel();
        }
        if (this.controlID != null) {
            Control control = new Control(this.controlID);
            this.issueControl(control);
        }
    }

    public void refresh() {
        Object object = this.boundModel.getPropertyValue();
        boolean bl = this.boundModel.getPropertyReadOnly();
        this.updateFromProperty(object, bl);
    }

    private void setReadOnly(boolean bl) {
        this.readOnly = bl;
        super.setEnabled(this.userEnabled && !this.readOnly);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

