/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbKeyGenerator;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.dbentity.PKGeneratorPanel;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class PKCustomSequenceGeneratorPanel
extends PKGeneratorPanel {
    protected TextAdapter customPKName;
    protected TextAdapter customPKSize;

    public PKCustomSequenceGeneratorPanel(ProjectController mediator) {
        super(mediator);
        this.initView();
    }

    private void initView() {
        JLabel note = new JLabel("* Custom sequences are supported on Oracle and Postgres");
        note.setFont(note.getFont().deriveFont(2).deriveFont(11.0f));
        this.customPKName = new TextAdapter(new JTextField()){

            protected void updateModel(String text) throws ValidationException {
                PKCustomSequenceGeneratorPanel.this.setPKName(text);
            }
        };
        this.customPKSize = new TextAdapter(new JTextField()){

            protected void updateModel(String text) throws ValidationException {
                PKCustomSequenceGeneratorPanel.this.setPKSize(text);
            }
        };
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("right:70dlu, 3dlu, 20dlu, 3dlu, fill:177dlu", ""));
        builder.setDefaultDialogBorder();
        builder.append("Sequence Name:", (Component)this.customPKName.getComponent(), 3);
        builder.append("Cached PK Size:", (Component)this.customPKSize.getComponent());
        builder.nextLine();
        builder.append("", (Component)note, 3);
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    public void onInit(DbEntity entity) {
        this.resetStrategy(entity, false, true);
        if (entity.getPrimaryKeyGenerator() == null) {
            DbKeyGenerator generator = new DbKeyGenerator();
            generator.setGeneratorType("ORACLE");
            entity.setPrimaryKeyGenerator(generator);
        }
    }

    public void setDbEntity(DbEntity entity) {
        DbKeyGenerator generator = entity.getPrimaryKeyGenerator();
        if (generator != null) {
            this.customPKName.setText(generator.getGeneratorName());
            this.customPKSize.setText(generator.getKeyCacheSize() != null ? generator.getKeyCacheSize().toString() : "0");
        } else {
            this.customPKName.setText(null);
            this.customPKSize.setText(null);
        }
    }

    protected void setPKSize(String text) {
        DbKeyGenerator generator;
        if (this.mediator.getCurrentDbEntity() == null || this.mediator.getCurrentDbEntity().getPrimaryKeyGenerator() == null) {
            return;
        }
        int cacheSize = 0;
        if (text != null && text.trim().length() > 0) {
            try {
                cacheSize = Integer.parseInt(text);
            }
            catch (NumberFormatException nfex) {
                throw new ValidationException("Invalid number");
            }
        }
        if (!Util.nullSafeEquals((Object)(generator = this.mediator.getCurrentDbEntity().getPrimaryKeyGenerator()).getKeyCacheSize(), (Object)new Integer(cacheSize))) {
            generator.setKeyCacheSize(new Integer(cacheSize));
            this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, (Entity)generator.getDbEntity()));
        }
    }

    protected void setPKName(String text) {
        DbKeyGenerator generator;
        if (this.mediator.getCurrentDbEntity() == null || this.mediator.getCurrentDbEntity().getPrimaryKeyGenerator() == null) {
            return;
        }
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if (!Util.nullSafeEquals((Object)text, (Object)(generator = this.mediator.getCurrentDbEntity().getPrimaryKeyGenerator()).getName())) {
            generator.setGeneratorName(text);
            this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, (Entity)generator.getDbEntity()));
        }
    }
}

