/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class EmbeddableAttribute
implements XMLSerializable,
Serializable {
    protected String name;
    protected String type;
    protected String dbAttributeName;
    protected Embeddable embeddable;

    public EmbeddableAttribute() {
    }

    public EmbeddableAttribute(String name) {
        this.name = name;
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<embeddable-attribute name=\"" + this.getName() + '\"');
        if (this.getType() != null) {
            encoder.print(" type=\"");
            encoder.print(this.getType());
            encoder.print('\"');
        }
        if (this.dbAttributeName != null) {
            encoder.print(" db-attribute-name=\"");
            encoder.print(Util.encodeXmlAttribute(this.dbAttributeName));
            encoder.print('\"');
        }
        encoder.println("/>");
    }

    public String getDbAttributeName() {
        return this.dbAttributeName;
    }

    public void setDbAttributeName(String dbAttributeName) {
        this.dbAttributeName = dbAttributeName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Embeddable getEmbeddable() {
        return this.embeddable;
    }

    public void setEmbeddable(Embeddable embeddable) {
        this.embeddable = embeddable;
    }
}

