/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.webapp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.shaded.javax.servlet.Servlet;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.Loader;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.resource.Resource;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.Descriptor;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.MetaDataComplete;
import org.apache.hadoop.shaded.org.eclipse.jetty.xml.XmlParser;
import org.xml.sax.InputSource;

public class WebDescriptor
extends Descriptor {
    private static final Logger LOG = Log.getLogger(WebDescriptor.class);
    protected static XmlParser _parserSingleton;
    protected MetaDataComplete _metaDataComplete;
    protected int _majorVersion = 3;
    protected int _minorVersion = 0;
    protected ArrayList<String> _classNames = new ArrayList();
    protected boolean _distributable;
    protected boolean _isOrdered = false;
    protected List<String> _ordering = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureParser() throws ClassNotFoundException {
        Class<WebDescriptor> clazz = WebDescriptor.class;
        synchronized (WebDescriptor.class) {
            if (_parserSingleton == null) {
                _parserSingleton = WebDescriptor.newParser(this.isValidating());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this._parser = _parserSingleton.isValidating() == this.isValidating() ? _parserSingleton : WebDescriptor.newParser(this.isValidating());
            return;
        }
    }

    public static XmlParser newParser(boolean validating) throws ClassNotFoundException {
        XmlParser xmlParser = new XmlParser(validating){
            boolean mapped = false;

            @Override
            protected InputSource resolveEntity(String pid, String sid) {
                if (!this.mapped) {
                    this.mapResources();
                    this.mapped = true;
                }
                InputSource is = super.resolveEntity(pid, sid);
                return is;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void mapResources() {
                URL dtd22 = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/web-app_2_2.dtd");
                URL dtd23 = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/web-app_2_3.dtd");
                URL j2ee14xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/j2ee_1_4.xsd");
                URL javaee5 = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/javaee_5.xsd");
                URL javaee6 = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/javaee_6.xsd");
                URL javaee7 = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/javaee_7.xsd");
                URL webapp24xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/web-app_2_4.xsd");
                URL webapp25xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/web-app_2_5.xsd");
                URL webapp30xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/web-app_3_0.xsd");
                URL webapp31xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/web-app_3_1.xsd");
                URL webcommon30xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/web-common_3_0.xsd");
                URL webcommon31xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/web-common_3_1.xsd");
                URL webfragment30xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/web-fragment_3_0.xsd");
                URL webfragment31xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/web-fragment_3_1.xsd");
                URL schemadtd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/XMLSchema.dtd");
                URL xmlxsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/xml.xsd");
                URL webservice11xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/j2ee_web_services_client_1_1.xsd");
                URL webservice12xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/javaee_web_services_client_1_2.xsd");
                URL webservice13xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/javaee_web_services_client_1_3.xsd");
                URL webservice14xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/javaee_web_services_client_1_4.xsd");
                URL datatypesdtd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/datatypes.dtd");
                URL jsp20xsd = null;
                URL jsp21xsd = null;
                URL jsp22xsd = null;
                URL jsp23xsd = null;
                try {
                    jsp20xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/jsp_2_0.xsd");
                    jsp21xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/jsp_2_1.xsd");
                    jsp22xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/jsp_2_2.xsd");
                    jsp23xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/resources/jsp_2_3.xsd");
                }
                catch (Exception e) {
                    LOG.ignore(e);
                }
                finally {
                    if (jsp20xsd == null) {
                        jsp20xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/jsp/resources/jsp_2_0.xsd");
                    }
                    if (jsp21xsd == null) {
                        jsp21xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/jsp/resources/jsp_2_1.xsd");
                    }
                    if (jsp22xsd == null) {
                        jsp22xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/jsp/resources/jsp_2_2.xsd");
                    }
                    if (jsp23xsd == null) {
                        jsp23xsd = Loader.getResource(Servlet.class, "org/apache/hadoop/shaded/javax/servlet/jsp/resources/jsp_2_3.xsd");
                    }
                }
                this.redirectEntity("web-app_2_2.dtd", dtd22);
                this.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", dtd22);
                this.redirectEntity("web.dtd", dtd23);
                this.redirectEntity("web-app_2_3.dtd", dtd23);
                this.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", dtd23);
                this.redirectEntity("XMLSchema.dtd", schemadtd);
                this.redirectEntity("http://www.w3.org/2001/XMLSchema.dtd", schemadtd);
                this.redirectEntity("-//W3C//DTD XMLSCHEMA 200102//EN", schemadtd);
                this.redirectEntity("jsp_2_0.xsd", jsp20xsd);
                this.redirectEntity("http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", jsp20xsd);
                this.redirectEntity("http://java.sun.com/xml/ns/javaee/jsp_2_1.xsd", jsp21xsd);
                this.redirectEntity("jsp_2_2.xsd", jsp22xsd);
                this.redirectEntity("http://java.sun.com/xml/ns/javaee/jsp_2_2.xsd", jsp22xsd);
                this.redirectEntity("jsp_2_3.xsd", jsp23xsd);
                this.redirectEntity("http://xmlns.jcp.org/xml/ns/javaee/jsp_2_3.xsd", jsp23xsd);
                this.redirectEntity("j2ee_1_4.xsd", j2ee14xsd);
                this.redirectEntity("http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", j2ee14xsd);
                this.redirectEntity("http://java.sun.com/xml/ns/javaee/javaee_5.xsd", javaee5);
                this.redirectEntity("http://java.sun.com/xml/ns/javaee/javaee_6.xsd", javaee6);
                this.redirectEntity("http://xmlns.jcp.org/xml/ns/javaee/javaee_7.xsd", javaee7);
                this.redirectEntity("web-app_2_4.xsd", webapp24xsd);
                this.redirectEntity("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", webapp24xsd);
                this.redirectEntity("web-app_2_5.xsd", webapp25xsd);
                this.redirectEntity("http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", webapp25xsd);
                this.redirectEntity("web-app_3_0.xsd", webapp30xsd);
                this.redirectEntity("http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd", webapp30xsd);
                this.redirectEntity("web-common_3_0.xsd", webcommon30xsd);
                this.redirectEntity("http://java.sun.com/xml/ns/javaee/web-common_3_0.xsd", webcommon30xsd);
                this.redirectEntity("web-fragment_3_0.xsd", webfragment30xsd);
                this.redirectEntity("http://java.sun.com/xml/ns/javaee/web-fragment_3_0.xsd", webfragment30xsd);
                this.redirectEntity("web-app_3_1.xsd", webapp31xsd);
                this.redirectEntity("http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd", webapp31xsd);
                this.redirectEntity("web-common_3_1.xsd", webcommon30xsd);
                this.redirectEntity("http://xmlns.jcp.org/xml/ns/javaee/web-common_3_1.xsd", webcommon31xsd);
                this.redirectEntity("web-fragment_3_1.xsd", webfragment30xsd);
                this.redirectEntity("http://xmlns.jcp.org/xml/ns/javaee/web-fragment_3_1.xsd", webfragment31xsd);
                this.redirectEntity("xml.xsd", xmlxsd);
                this.redirectEntity("http://www.w3.org/2001/xml.xsd", xmlxsd);
                this.redirectEntity("datatypes.dtd", datatypesdtd);
                this.redirectEntity("http://www.w3.org/2001/datatypes.dtd", datatypesdtd);
                this.redirectEntity("j2ee_web_services_client_1_1.xsd", webservice11xsd);
                this.redirectEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", webservice11xsd);
                this.redirectEntity("javaee_web_services_client_1_2.xsd", webservice12xsd);
                this.redirectEntity("http://www.ibm.com/webservices/xsd/javaee_web_services_client_1_2.xsd", webservice12xsd);
                this.redirectEntity("javaee_web_services_client_1_3.xsd", webservice13xsd);
                this.redirectEntity("http://java.sun.com/xml/ns/javaee/javaee_web_services_client_1_3.xsd", webservice13xsd);
                this.redirectEntity("javaee_web_services_client_1_4.xsd", webservice14xsd);
                this.redirectEntity("http://xmlns.jcp.org/xml/ns/javaee/javaee_web_services_client_1_4.xsd", webservice14xsd);
            }
        };
        return xmlParser;
    }

    public WebDescriptor(Resource xml) {
        super(xml);
    }

    @Override
    public void parse() throws Exception {
        super.parse();
        this.processVersion();
        this.processOrdering();
    }

    public MetaDataComplete getMetaDataComplete() {
        return this._metaDataComplete;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public void processVersion() {
        String version = this._root.getAttribute("version", "DTD");
        if ("DTD".equals(version)) {
            this._majorVersion = 2;
            this._minorVersion = 3;
            String dtd = this._parser.getDTD();
            if (dtd != null && dtd.indexOf("web-app_2_2") >= 0) {
                this._majorVersion = 2;
                this._minorVersion = 2;
            }
        } else {
            int dot = version.indexOf(".");
            if (dot > 0) {
                this._majorVersion = Integer.parseInt(version.substring(0, dot));
                this._minorVersion = Integer.parseInt(version.substring(dot + 1));
            }
        }
        if (this._majorVersion <= 2 && this._minorVersion < 5) {
            this._metaDataComplete = MetaDataComplete.True;
        } else {
            String s2 = this._root.getAttribute("metadata-complete");
            if (s2 == null) {
                this._metaDataComplete = MetaDataComplete.NotSet;
            } else {
                MetaDataComplete metaDataComplete = this._metaDataComplete = Boolean.valueOf(s2) != false ? MetaDataComplete.True : MetaDataComplete.False;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._xml.toString() + ": Calculated metadatacomplete = " + (Object)((Object)this._metaDataComplete) + " with version=" + version, new Object[0]);
        }
    }

    public void processOrdering() {
        XmlParser.Node ordering = this._root.get("absolute-ordering");
        if (ordering == null) {
            return;
        }
        this._isOrdered = true;
        Iterator iter = ordering.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XmlParser.Node)) continue;
            node = (XmlParser.Node)o;
            if (node.getTag().equalsIgnoreCase("others")) {
                this._ordering.add("others");
                continue;
            }
            if (!node.getTag().equalsIgnoreCase("name")) continue;
            this._ordering.add(node.toString(false, true));
        }
    }

    public void addClassName(String className) {
        if (!this._classNames.contains(className)) {
            this._classNames.add(className);
        }
    }

    public ArrayList<String> getClassNames() {
        return this._classNames;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public boolean isDistributable() {
        return this._distributable;
    }

    @Override
    public void setValidating(boolean validating) {
        this._validating = validating;
    }

    public boolean isValidating() {
        return this._validating;
    }

    public boolean isOrdered() {
        return this._isOrdered;
    }

    public List<String> getOrdering() {
        return this._ordering;
    }
}

