/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NettyManagedBuffer;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.RequestMessage;

public final class RpcRequest
extends RequestMessage {
    public final long requestId;

    public RpcRequest(long requestId, ManagedBuffer message) {
        super(message);
        this.requestId = requestId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.RPC_REQUEST;
    }

    @Override
    public int encodedLength() {
        return 12;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        buf.writeInt((int)this.body().size());
    }

    public static RpcRequest decode(ByteBuf buf) {
        return RpcRequest.decode(buf, true);
    }

    public static RpcRequest decode(ByteBuf buf, boolean decodeBody) {
        long requestId = buf.readLong();
        buf.readInt();
        if (decodeBody) {
            return new RpcRequest(requestId, new NettyManagedBuffer(buf));
        }
        return new RpcRequest(requestId, NettyManagedBuffer.EmptyBuffer);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestId, this.body()});
    }

    public boolean equals(Object other) {
        if (other instanceof RpcRequest) {
            RpcRequest o = (RpcRequest)other;
            return this.requestId == o.requestId && super.equals(o);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("requestId", this.requestId).add("body", (Object)this.body()).toString();
    }
}

