/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client;

import java.io.Closeable;
import java.util.Collection;
import java.util.Objects;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.ClientFactory;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.client.api.AdminApi;
import org.apache.ratis.client.api.AsyncApi;
import org.apache.ratis.client.api.BlockingApi;
import org.apache.ratis.client.api.DataStreamApi;
import org.apache.ratis.client.api.GroupManagementApi;
import org.apache.ratis.client.api.LeaderElectionManagementApi;
import org.apache.ratis.client.api.MessageStreamApi;
import org.apache.ratis.client.api.SnapshotManagementApi;
import org.apache.ratis.client.impl.ClientImplUtils;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RaftClient
extends Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(RaftClient.class);

    public ClientId getId();

    public RaftPeerId getLeaderId();

    public RaftClientRpc getClientRpc();

    public AdminApi admin();

    public GroupManagementApi getGroupManagementApi(RaftPeerId var1);

    public SnapshotManagementApi getSnapshotManagementApi();

    public SnapshotManagementApi getSnapshotManagementApi(RaftPeerId var1);

    public LeaderElectionManagementApi getLeaderElectionManagementApi(RaftPeerId var1);

    public BlockingApi io();

    public AsyncApi async();

    public MessageStreamApi getMessageStreamApi();

    public DataStreamApi getDataStreamApi();

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ClientId clientId;
        private RaftClientRpc clientRpc;
        private RaftGroup group;
        private RaftPeerId leaderId;
        private RaftPeer primaryDataStreamServer;
        private RaftProperties properties;
        private Parameters parameters;
        private RetryPolicy retryPolicy = RetryPolicies.retryForeverNoSleep();

        private Builder() {
        }

        public RaftClient build() {
            Collection peers;
            if (this.clientId == null) {
                this.clientId = ClientId.randomId();
            }
            if (this.properties != null && this.clientRpc == null) {
                RpcType rpcType = RaftConfigKeys.Rpc.type((RaftProperties)this.properties, arg_0 -> ((Logger)LOG).debug(arg_0));
                ClientFactory factory = ClientFactory.cast(rpcType.newFactory(this.parameters));
                this.clientRpc = factory.newRaftClientRpc(this.clientId, this.properties);
            }
            Objects.requireNonNull(this.group, "The 'group' field is not initialized.");
            if (this.primaryDataStreamServer == null && !(peers = this.group.getPeers()).isEmpty()) {
                this.primaryDataStreamServer = (RaftPeer)peers.iterator().next();
            }
            return ClientImplUtils.newRaftClient(this.clientId, this.group, this.leaderId, this.primaryDataStreamServer, Objects.requireNonNull(this.clientRpc, "The 'clientRpc' field is not initialized."), this.retryPolicy, this.properties, this.parameters);
        }

        public Builder setClientId(ClientId clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setRaftGroup(RaftGroup grp) {
            this.group = grp;
            return this;
        }

        public Builder setLeaderId(RaftPeerId leaderId) {
            this.leaderId = leaderId;
            return this;
        }

        public Builder setPrimaryDataStreamServer(RaftPeer primaryDataStreamServer) {
            this.primaryDataStreamServer = primaryDataStreamServer;
            return this;
        }

        public Builder setClientRpc(RaftClientRpc clientRpc) {
            this.clientRpc = clientRpc;
            return this;
        }

        public Builder setProperties(RaftProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder setParameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }
    }
}

