/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker;

import com.google.common.base.Throwables;
import com.google.protobuf.GeneratedMessageV3;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.FileManagedBuffers;
import org.apache.celeborn.common.meta.TimeWindow;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NioManagedBuffer;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.BufferStreamEnd;
import org.apache.celeborn.common.network.protocol.ChunkFetchFailure;
import org.apache.celeborn.common.network.protocol.ChunkFetchRequest;
import org.apache.celeborn.common.network.protocol.ChunkFetchSuccess;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.OpenStream;
import org.apache.celeborn.common.network.protocol.OpenStreamWithCredit;
import org.apache.celeborn.common.network.protocol.ReadAddCredit;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.protocol.RpcResponse;
import org.apache.celeborn.common.network.protocol.StreamChunkSlice;
import org.apache.celeborn.common.network.protocol.StreamHandle;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.PbBufferStreamEnd;
import org.apache.celeborn.common.protocol.PbChunkFetchRequest;
import org.apache.celeborn.common.protocol.PbOpenStream;
import org.apache.celeborn.common.protocol.PbReadAddCredit;
import org.apache.celeborn.common.protocol.PbStreamChunkSlice;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.StreamType;
import org.apache.celeborn.common.util.ExceptionUtils;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.service.deploy.worker.Worker;
import org.apache.celeborn.service.deploy.worker.WorkerSource;
import org.apache.celeborn.service.deploy.worker.WorkerSource$;
import org.apache.celeborn.service.deploy.worker.storage.ChunkStreamManager;
import org.apache.celeborn.service.deploy.worker.storage.CreditStreamManager;
import org.apache.celeborn.service.deploy.worker.storage.PartitionFilesSorter;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r%a\u0001\u0002\u00180\u0001qB\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005\u001f\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003W\u0011!i\u0006A!b\u0001\n\u0003q\u0006\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u000b\u0011\u0004A\u0011A3\t\u000f)\u0004!\u0019!C\u0001W\"1!\u000f\u0001Q\u0001\n1Dqa\u001d\u0001C\u0002\u0013\u0005A\u000f\u0003\u0004\u007f\u0001\u0001\u0006I!\u001e\u0005\t\u007f\u0002\u0011\r\u0011\"\u0001\u0002\u0002!A\u0011\u0011\u0002\u0001!\u0002\u0013\t\u0019\u0001C\u0006\u0002\f\u0001\u0001\r\u00111A\u0005\u0002\u00055\u0001bCA\u000b\u0001\u0001\u0007\t\u0019!C\u0001\u0003/A1\"a\t\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0010!Y\u0011Q\u0005\u0001A\u0002\u0003\u0007I\u0011AA\u0014\u0011-\ty\u0003\u0001a\u0001\u0002\u0004%\t!!\r\t\u0017\u0005U\u0002\u00011A\u0001B\u0003&\u0011\u0011\u0006\u0005\n\u0003o\u0001\u0001\u0019!C\u0001\u0003sA\u0011\"!\u0015\u0001\u0001\u0004%\t!a\u0015\t\u0011\u0005]\u0003\u0001)Q\u0005\u0003wAq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002f\u0001!\t!a\u001a\t\u000f\u0005M\u0005\u0001\"\u0011\u0002\u0016\"9\u00111\u0013\u0001\u0005B\u0005}\u0006bBAc\u0001\u0011%\u0011q\u0019\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\t\t\u000f\u0001C\u0005\u0003GD\u0011B!\u0005\u0001#\u0003%IAa\u0005\t\u000f\t%\u0002\u0001\"\u0003\u0003,!I!q\u000b\u0001\u0012\u0002\u0013%!\u0011\f\u0005\n\u0005;\u0002\u0011\u0013!C\u0005\u0005?BqAa\u0019\u0001\t\u0013\u0011)\u0007C\u0004\u0003\u0004\u0002!IA!\"\t\u000f\tE\u0005\u0001\"\u0001\u0003\u0014\"9!\u0011\u0013\u0001\u0005\u0002\t]\u0005b\u0002BU\u0001\u0011\u0005!1\u0016\u0005\b\u0005g\u0003A\u0011\u0001B[\u0011\u001d\u00119\r\u0001C!\u0005\u0013DqAa3\u0001\t\u0003\u0012i\rC\u0004\u0003R\u0002!\tEa5\t\u000f\t]\u0007\u0001\"\u0011\u0003Z\"9!1\u001f\u0001\u0005\u0002\tU\bbBB\u0001\u0001\u0011\u000511\u0001\u0002\r\r\u0016$8\r\u001b%b]\u0012dWM\u001d\u0006\u0003aE\naa^8sW\u0016\u0014(B\u0001\u001a4\u0003\u0019!W\r\u001d7ps*\u0011A'N\u0001\bg\u0016\u0014h/[2f\u0015\t1t'\u0001\u0005dK2,'m\u001c:o\u0015\tA\u0014(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!P$\u0011\u0005y*U\"A \u000b\u0005\u0001\u000b\u0015AB:feZ,'O\u0003\u0002C\u0007\u00069a.\u001a;x_J\\'B\u0001#6\u0003\u0019\u0019w.\\7p]&\u0011ai\u0010\u0002\u0013\u0005\u0006\u001cX-T3tg\u0006<W\rS1oI2,'\u000f\u0005\u0002I\u00176\t\u0011J\u0003\u0002K\u0007\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002M\u0013\n9Aj\\4hS:<\u0017\u0001B2p]\u001a,\u0012a\u0014\t\u0003!Fk\u0011aQ\u0005\u0003%\u000e\u0013AbQ3mK\n|'O\\\"p]\u001a\fQaY8oM\u0002\nQ\u0002\u001e:b]N\u0004xN\u001d;D_:4W#\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0005e\u000b\u0015\u0001B;uS2L!a\u0017-\u0003\u001bQ\u0013\u0018M\\:q_J$8i\u001c8g\u00039!(/\u00198ta>\u0014HoQ8oM\u0002\nAb^8sW\u0016\u00148k\\;sG\u0016,\u0012a\u0018\t\u0003A\u0006l\u0011aL\u0005\u0003E>\u0012AbV8sW\u0016\u00148k\\;sG\u0016\fQb^8sW\u0016\u00148k\\;sG\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003gO\"L\u0007C\u00011\u0001\u0011\u0015iu\u00011\u0001P\u0011\u0015!v\u00011\u0001W\u0011\u0015iv\u00011\u0001`\u0003I\u0019\u0007.\u001e8l'R\u0014X-Y7NC:\fw-\u001a:\u0016\u00031\u0004\"!\u001c9\u000e\u00039T!a\\\u0018\u0002\u000fM$xN]1hK&\u0011\u0011O\u001c\u0002\u0013\u0007\",hn[*ue\u0016\fW.T1oC\u001e,'/A\ndQVt7n\u0015;sK\u0006lW*\u00198bO\u0016\u0014\b%\u0001\rnCb\u001c\u0005.\u001e8l\u0005\u0016Lgn\u001a+sC:\u001ch-\u001a:sK\u0012,\u0012!\u001e\t\u0004mf\\X\"A<\u000b\u0003a\fQa]2bY\u0006L!A_<\u0003\r=\u0003H/[8o!\t1H0\u0003\u0002~o\n!Aj\u001c8h\u0003ei\u0017\r_\"ik:\\')Z5oOR\u0013\u0018M\\:gKJ\u0014X\r\u001a\u0011\u0002'\r\u0014X\rZ5u'R\u0014X-Y7NC:\fw-\u001a:\u0016\u0005\u0005\r\u0001cA7\u0002\u0006%\u0019\u0011q\u00018\u0003'\r\u0013X\rZ5u'R\u0014X-Y7NC:\fw-\u001a:\u0002)\r\u0014X\rZ5u'R\u0014X-Y7NC:\fw-\u001a:!\u00039\u0019Ho\u001c:bO\u0016l\u0015M\\1hKJ,\"!a\u0004\u0011\u00075\f\t\"C\u0002\u0002\u00149\u0014ab\u0015;pe\u0006<W-T1oC\u001e,'/\u0001\nti>\u0014\u0018mZ3NC:\fw-\u001a:`I\u0015\fH\u0003BA\r\u0003?\u00012A^A\u000e\u0013\r\tib\u001e\u0002\u0005+:LG\u000fC\u0005\u0002\"=\t\t\u00111\u0001\u0002\u0010\u0005\u0019\u0001\u0010J\u0019\u0002\u001fM$xN]1hK6\u000bg.Y4fe\u0002\n\u0001\u0003]1si&$\u0018n\u001c8t'>\u0014H/\u001a:\u0016\u0005\u0005%\u0002cA7\u0002,%\u0019\u0011Q\u00068\u0003)A\u000b'\u000f^5uS>tg)\u001b7fgN{'\u000f^3s\u0003Q\u0001\u0018M\u001d;ji&|gn]*peR,'o\u0018\u0013fcR!\u0011\u0011DA\u001a\u0011%\t\tCEA\u0001\u0002\u0004\tI#A\tqCJ$\u0018\u000e^5p]N\u001cvN\u001d;fe\u0002\n!B]3hSN$XM]3e+\t\tY\u0004\u0005\u0003\u0002>\u00055SBAA \u0015\u0011\t\t%a\u0011\u0002\r\u0005$x.\\5d\u0015\u0011\t)%a\u0012\u0002\u0015\r|gnY;se\u0016tGOC\u0002Z\u0003\u0013R!!a\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\nyDA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\u000fe\u0016<\u0017n\u001d;fe\u0016$w\fJ3r)\u0011\tI\"!\u0016\t\u0013\u0005\u0005R#!AA\u0002\u0005m\u0012a\u0003:fO&\u001cH/\u001a:fI\u0002\nA!\u001b8jiR!\u0011\u0011DA/\u0011\u0019\u0001t\u00031\u0001\u0002`A\u0019\u0001-!\u0019\n\u0007\u0005\rtF\u0001\u0004X_J\\WM]\u0001\u000fO\u0016$(+Y<GS2,\u0017J\u001c4p)\u0019\tI'!\u001e\u0002\u0010B!\u00111NA9\u001b\t\tiGC\u0002\u0002p\r\u000bA!\\3uC&!\u00111OA7\u0005!1\u0015\u000e\\3J]\u001a|\u0007bBA<1\u0001\u0007\u0011\u0011P\u0001\u000bg\",hM\u001a7f\u0017\u0016L\b\u0003BA>\u0003\u0013sA!! \u0002\u0006B\u0019\u0011qP<\u000e\u0005\u0005\u0005%bAABw\u00051AH]8pizJ1!a\"x\u0003\u0019\u0001&/\u001a3fM&!\u00111RAG\u0005\u0019\u0019FO]5oO*\u0019\u0011qQ<\t\u000f\u0005E\u0005\u00041\u0001\u0002z\u0005Aa-\u001b7f\u001d\u0006lW-A\u0004sK\u000e,\u0017N^3\u0015\u0011\u0005e\u0011qSAS\u0003kCq!!'\u001a\u0001\u0004\tY*\u0001\u0004dY&,g\u000e\u001e\t\u0005\u0003;\u000b\t+\u0004\u0002\u0002 *\u0019\u0011\u0011T!\n\t\u0005\r\u0016q\u0014\u0002\u0010)J\fgn\u001d9peR\u001cE.[3oi\"9\u0011qU\rA\u0002\u0005%\u0016aA7tOB!\u00111VAY\u001b\t\tiKC\u0002\u00020\u0006\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003g\u000biK\u0001\bSKF,Xm\u001d;NKN\u001c\u0018mZ3\t\u000f\u0005]\u0016\u00041\u0001\u0002:\u0006A1-\u00197mE\u0006\u001c7\u000e\u0005\u0003\u0002\u001e\u0006m\u0016\u0002BA_\u0003?\u00131C\u00159d%\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.$b!!\u0007\u0002B\u0006\r\u0007bBAM5\u0001\u0007\u00111\u0014\u0005\b\u0003OS\u0002\u0019AAU\u0003AA\u0017M\u001c3mKJ\u00038MU3rk\u0016\u001cH\u000f\u0006\u0005\u0002\u001a\u0005%\u00171ZAk\u0011\u001d\tIj\u0007a\u0001\u00037Cq!!4\u001c\u0001\u0004\ty-\u0001\u0006sa\u000e\u0014V-];fgR\u0004B!a+\u0002R&!\u00111[AW\u0005)\u0011\u0006o\u0019*fcV,7\u000f\u001e\u0005\b\u0003o[\u0002\u0019AA]\u0003YA\u0017M\u001c3mK2+w-Y2z%B\u001cW*Z:tC\u001e,G\u0003CA\r\u00037\fi.a8\t\u000f\u0005eE\u00041\u0001\u0002\u001c\"9\u0011Q\u001a\u000fA\u0002\u0005=\u0007bBA\\9\u0001\u0007\u0011\u0011X\u0001\u0019Q\u0006tG\r\\3Pa\u0016t7\u000b\u001e:fC6Le\u000e^3s]\u0006dGCFA\r\u0003K\f9/!;\u0002l\u0006U\u0018\u0011`A\u007f\u0005\u0003\u0011YAa\u0004\t\u000f\u0005eU\u00041\u0001\u0002\u001c\"9\u0011qO\u000fA\u0002\u0005e\u0004bBAI;\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003[l\u0002\u0019AAx\u0003)\u0019H/\u0019:u\u0013:$W\r\u001f\t\u0004m\u0006E\u0018bAAzo\n\u0019\u0011J\u001c;\t\u000f\u0005]X\u00041\u0001\u0002p\u0006AQM\u001c3J]\u0012,\u0007\u0010C\u0004\u0002|v\u0001\r!a<\u0002\u001b%t\u0017\u000e^5bY\u000e\u0013X\rZ5u\u0011\u0019\ty0\ba\u0001w\u0006a!\u000f]2SKF,Xm\u001d;JI\"9!1A\u000fA\u0002\t\u0015\u0011\u0001C5t\u0019\u0016<\u0017mY=\u0011\u0007Y\u00149!C\u0002\u0003\n]\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0003\u000eu\u0001\n\u00111\u0001\u0003\u0006\u0005\u0001\"/Z1e\u0019>\u001c\u0017\r\\*ik\u001a4G.\u001a\u0005\b\u0003ok\u0002\u0019AA]\u0003\tB\u0017M\u001c3mK>\u0003XM\\*ue\u0016\fW.\u00138uKJt\u0017\r\u001c\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!Q\u0003\u0016\u0005\u0005\u000b\u00119b\u000b\u0002\u0003\u001aA!!1\u0004B\u0013\u001b\t\u0011iB\u0003\u0003\u0003 \t\u0005\u0012!C;oG\",7m[3e\u0015\r\u0011\u0019c^\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0014\u0005;\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003I\u0011X\r\u001d7z'R\u0014X-Y7IC:$G.\u001a:\u0015!\u0005e!Q\u0006B\u0018\u0005g\u00119Da\u000f\u0003>\tM\u0003bBAM?\u0001\u0007\u00111\u0014\u0005\u0007\u0005cy\u0002\u0019A>\u0002\u0013I,\u0017/^3ti&#\u0007B\u0002B\u001b?\u0001\u000710\u0001\u0005tiJ,\u0017-\\%e\u0011\u001d\u0011Id\ba\u0001\u0003_\f\u0011B\\;n\u0007\",hn[:\t\u000f\t\rq\u00041\u0001\u0003\u0006!I!qH\u0010\u0011\u0002\u0003\u0007!\u0011I\u0001\b_\u001a47/\u001a;t!\u0019\u0011\u0019E!\u0012\u0003J5\u0011\u0011qI\u0005\u0005\u0005\u000f\n9E\u0001\u0003MSN$\b\u0003\u0002B&\u0005#j!A!\u0014\u000b\t\t=\u0013\u0011J\u0001\u0005Y\u0006tw-C\u0002~\u0005\u001bB\u0011B!\u0016 !\u0003\u0005\r!!\u001f\u0002\u0011\u0019LG.\u001a9bi\"\fAD]3qYf\u001cFO]3b[\"\u000bg\u000e\u001a7fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0003\\)\"!\u0011\tB\f\u0003q\u0011X\r\u001d7z'R\u0014X-Y7IC:$G.\u001a:%I\u00164\u0017-\u001e7uI]*\"A!\u0019+\t\u0005e$qC\u0001\u0015Q\u0006tG\r\\3Sa\u000eLu*\u0012=dKB$\u0018n\u001c8\u0015\u001d\u0005e!q\rB5\u0005W\u0012iGa\u001c\u0003\u0000!9\u0011\u0011\u0014\u0012A\u0002\u0005m\u0005B\u0002B\u0019E\u0001\u00071\u0010C\u0004\u0002x\t\u0002\r!!\u001f\t\u000f\u0005E%\u00051\u0001\u0002z!9!\u0011\u000f\u0012A\u0002\tM\u0014aA5pKB!!Q\u000fB>\u001b\t\u00119H\u0003\u0003\u0003z\u0005%\u0013AA5p\u0013\u0011\u0011iHa\u001e\u0003\u0017%{U\t_2faRLwN\u001c\u0005\b\u0005\u0003\u0013\u0003\u0019AA]\u0003-\u0011\boY\"bY2\u0014\u0017mY6\u0002%!\fg\u000e\u001a7f%B\u001cW\t_2faRLwN\u001c\u000b\u000b\u00033\u00119I!#\u0003\f\n5\u0005bBAMG\u0001\u0007\u00111\u0014\u0005\u0007\u0005c\u0019\u0003\u0019A>\t\u000f\tE4\u00051\u0001\u0003t!9!qR\u0012A\u0002\u0005e\u0016a\u0005:qGJ+7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0017!\u00075b]\u0012dW-\u00128e'R\u0014X-Y7Ge>l7\t\\5f]R$B!!\u0007\u0003\u0016\"1!Q\u0007\u0013A\u0002m$b!!\u0007\u0003\u001a\nm\u0005B\u0002B\u001bK\u0001\u00071\u0010C\u0004\u0003\u001e\u0016\u0002\rAa(\u0002\u0015M$(/Z1n)f\u0004X\r\u0005\u0003\u0003\"\n\u0015VB\u0001BR\u0015\r\tykQ\u0005\u0005\u0005O\u0013\u0019K\u0001\u0006TiJ,\u0017-\u001c+za\u0016\f1\u0003[1oI2,'+Z1e\u0003\u0012$7I]3eSR$b!!\u0007\u0003.\nE\u0006b\u0002BXM\u0001\u0007\u0011q^\u0001\u0007GJ,G-\u001b;\t\r\tUb\u00051\u0001|\u0003]A\u0017M\u001c3mK\u000eCWO\\6GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0006\u0005\u0002\u001a\t]&\u0011\u0018Bb\u0011\u001d\tIj\na\u0001\u00037CqAa/(\u0001\u0004\u0011i,\u0001\ttiJ,\u0017-\\\"ik:\\7\u000b\\5dKB!\u00111\u0016B`\u0013\u0011\u0011\t-!,\u0003!M#(/Z1n\u0007\",hn[*mS\u000e,\u0007b\u0002BcO\u0001\u0007\u0011\u0011V\u0001\u0004e\u0016\f\u0018aD2iK\u000e\\'+Z4jgR,'/\u001a3\u0015\u0005\t\u0015\u0011!D2iC:tW\r\\!di&4X\r\u0006\u0003\u0002\u001a\t=\u0007bBAMS\u0001\u0007\u00111T\u0001\u0010G\"\fgN\\3m\u0013:\f7\r^5wKR!\u0011\u0011\u0004Bk\u0011\u001d\tIJ\u000ba\u0001\u00037\u000bq\"\u001a=dKB$\u0018n\u001c8DCV<\u0007\u000e\u001e\u000b\u0007\u00033\u0011YN!=\t\u000f\tu7\u00061\u0001\u0003`\u0006)1-Y;tKB!!\u0011\u001dBv\u001d\u0011\u0011\u0019Oa:\u000f\t\u0005}$Q]\u0005\u0002q&\u0019!\u0011^<\u0002\u000fA\f7m[1hK&!!Q\u001eBx\u0005%!\u0006N]8xC\ndWMC\u0002\u0003j^Dq!!',\u0001\u0004\tY*\u0001\rdY\u0016\fg.\u001e9FqBL'/\u001a3TQV4g\r\\3LKf$B!!\u0007\u0003x\"9!\u0011 \u0017A\u0002\tm\u0018AE3ya&\u0014X\rZ*ik\u001a4G.Z&fsN\u0004bAa\u0011\u0003~\u0006e\u0014\u0002\u0002B\u0000\u0003\u000f\u0012q\u0001S1tQN+G/A\ntKR\u0004\u0016M\u001d;ji&|gn]*peR,'\u000f\u0006\u0003\u0002\u001a\r\u0015\u0001bBB\u0004[\u0001\u0007\u0011\u0011F\u0001\u0015a\u0006\u0014H/\u001b;j_:4\u0015\u000e\\3t'>\u0014H/\u001a:")
public class FetchHandler
extends BaseMessageHandler
implements Logging {
    private final CelebornConf conf;
    private final TransportConf transportConf;
    private final WorkerSource workerSource;
    private final ChunkStreamManager chunkStreamManager;
    private final Option<Object> maxChunkBeingTransferred;
    private final CreditStreamManager creditStreamManager;
    private StorageManager storageManager;
    private PartitionFilesSorter partitionsSorter;
    private AtomicBoolean registered;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        FetchHandler fetchHandler = this;
        synchronized (fetchHandler) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public CelebornConf conf() {
        return this.conf;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    public WorkerSource workerSource() {
        return this.workerSource;
    }

    public ChunkStreamManager chunkStreamManager() {
        return this.chunkStreamManager;
    }

    public Option<Object> maxChunkBeingTransferred() {
        return this.maxChunkBeingTransferred;
    }

    public CreditStreamManager creditStreamManager() {
        return this.creditStreamManager;
    }

    public StorageManager storageManager() {
        return this.storageManager;
    }

    public void storageManager_$eq(StorageManager x$1) {
        this.storageManager = x$1;
    }

    public PartitionFilesSorter partitionsSorter() {
        return this.partitionsSorter;
    }

    public void partitionsSorter_$eq(PartitionFilesSorter x$1) {
        this.partitionsSorter = x$1;
    }

    public AtomicBoolean registered() {
        return this.registered;
    }

    public void registered_$eq(AtomicBoolean x$1) {
        this.registered = x$1;
    }

    public void init(Worker worker) {
        this.workerSource().addGauge(WorkerSource$.MODULE$.CHUNK_STREAM_COUNT(), this.workerSource().addGauge$default$2(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.chunkStreamManager().getStreamsCount());
        this.workerSource().addGauge(WorkerSource$.MODULE$.CREDIT_STREAM_COUNT(), this.workerSource().addGauge$default$2(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.creditStreamManager().getStreamsCount());
        this.workerSource().addGauge(WorkerSource$.MODULE$.ACTIVE_MAP_PARTITION_COUNT(), this.workerSource().addGauge$default$2(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.creditStreamManager().getActiveMapPartitionCount());
        this.storageManager_$eq(worker.storageManager());
        this.partitionsSorter_$eq(worker.partitionsSorter());
        this.registered_$eq(worker.registered());
    }

    /*
     * WARNING - void declaration
     */
    public FileInfo getRawFileInfo(String shuffleKey, String fileName) {
        void var3_3;
        FileInfo fileInfo = this.storageManager().getFileInfo(shuffleKey, fileName);
        if (fileInfo == null) {
            String errMsg = new StringBuilder(26).append("Could not find file ").append(fileName).append(" for ").append(shuffleKey).append(".").toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errMsg);
            throw new FileNotFoundException(errMsg);
        }
        return var3_3;
    }

    public void receive(TransportClient client, RequestMessage msg, RpcResponseCallback callback) {
        this.handleRpcRequest(client, (RpcRequest)msg, callback);
    }

    public void receive(TransportClient client, RequestMessage msg) {
        RequestMessage requestMessage = msg;
        if (requestMessage instanceof BufferStreamEnd) {
            BufferStreamEnd bufferStreamEnd = (BufferStreamEnd)requestMessage;
            this.handleEndStreamFromClient(bufferStreamEnd.getStreamId());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (requestMessage instanceof ReadAddCredit) {
            ReadAddCredit readAddCredit = (ReadAddCredit)requestMessage;
            this.handleReadAddCredit(readAddCredit.getCredit(), readAddCredit.getStreamId());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (requestMessage instanceof ChunkFetchRequest) {
            ChunkFetchRequest chunkFetchRequest = (ChunkFetchRequest)requestMessage;
            this.handleChunkFetchRequest(client, chunkFetchRequest.streamChunkSlice, (RequestMessage)chunkFetchRequest);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (requestMessage != null) {
                RequestMessage requestMessage2 = requestMessage;
                throw new IllegalArgumentException(new StringBuilder(25).append("Unknown message type id: ").append(requestMessage2.type().id()).toString());
            }
            throw new MatchError((Object)requestMessage);
        }
    }

    private void handleRpcRequest(TransportClient client, RpcRequest rpcRequest, RpcResponseCallback callback) {
        GeneratedMessageV3 message = null;
        try {
            message = TransportMessage.fromByteBuffer((ByteBuffer)rpcRequest.body().nioByteBuffer()).getParsedPayload();
        }
        catch (CelebornIOException exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Handle request with legacy RPCs", exception);
            this.handleLegacyRpcMessage(client, rpcRequest, callback);
            return;
        }
        GeneratedMessageV3 generatedMessageV3 = message;
        if (generatedMessageV3 instanceof PbOpenStream) {
            PbOpenStream pbOpenStream = (PbOpenStream)generatedMessageV3;
            this.handleOpenStreamInternal(client, pbOpenStream.getShuffleKey(), pbOpenStream.getFileName(), pbOpenStream.getStartIndex(), pbOpenStream.getEndIndex(), pbOpenStream.getInitialCredit(), rpcRequest.requestId, false, pbOpenStream.getReadLocalShuffle(), callback);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (generatedMessageV3 instanceof PbBufferStreamEnd) {
            PbBufferStreamEnd pbBufferStreamEnd = (PbBufferStreamEnd)generatedMessageV3;
            this.handleEndStreamFromClient(pbBufferStreamEnd.getStreamId(), pbBufferStreamEnd.getStreamType());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (generatedMessageV3 instanceof PbReadAddCredit) {
            PbReadAddCredit pbReadAddCredit = (PbReadAddCredit)generatedMessageV3;
            this.handleReadAddCredit(pbReadAddCredit.getCredit(), pbReadAddCredit.getStreamId());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (generatedMessageV3 instanceof PbChunkFetchRequest) {
            PbChunkFetchRequest pbChunkFetchRequest = (PbChunkFetchRequest)generatedMessageV3;
            this.handleChunkFetchRequest(client, StreamChunkSlice.fromProto((PbStreamChunkSlice)pbChunkFetchRequest.getStreamChunkSlice()), (RequestMessage)rpcRequest);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (generatedMessageV3 != null) {
            GeneratedMessageV3 generatedMessageV32 = generatedMessageV3;
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Unknown message ").append(generatedMessageV32).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)generatedMessageV3);
        }
    }

    private void handleLegacyRpcMessage(TransportClient client, RpcRequest rpcRequest, RpcResponseCallback callback) {
        block4: {
            try {
                Message message = Message.decode((ByteBuffer)rpcRequest.body().nioByteBuffer());
                Message.Type type = message.type();
                if (Message.Type.OPEN_STREAM.equals(type)) {
                    OpenStream openStream = (OpenStream)message;
                    this.handleOpenStreamInternal(client, new String(openStream.shuffleKey, StandardCharsets.UTF_8), new String(openStream.fileName, StandardCharsets.UTF_8), openStream.startMapIndex, openStream.endMapIndex, 0, rpcRequest.requestId, true, false, callback);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (Message.Type.OPEN_STREAM_WITH_CREDIT.equals(type)) {
                    OpenStreamWithCredit openStreamWithCredit = (OpenStreamWithCredit)message;
                    this.handleOpenStreamInternal(client, new String(openStreamWithCredit.shuffleKey, StandardCharsets.UTF_8), new String(openStreamWithCredit.fileName, StandardCharsets.UTF_8), openStreamWithCredit.startIndex, openStreamWithCredit.endIndex, openStreamWithCredit.initialCredit, rpcRequest.requestId, true, false, callback);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Received an unknown message type id: ").append(message.type().id()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Catch an error when handle legacy rpc message.", e);
            }
        }
    }

    private void handleOpenStreamInternal(TransportClient client, String shuffleKey, String fileName, int startIndex, int endIndex, int initialCredit, long rpcRequestId, boolean isLegacy, boolean readLocalShuffle, RpcResponseCallback callback) {
        this.workerSource().startTimer(WorkerSource$.MODULE$.OPEN_STREAM_TIME(), shuffleKey);
        try {
            try {
                Object object;
                ObjectRef fileInfo = ObjectRef.create((Object)this.getRawFileInfo(shuffleKey, fileName));
                PartitionType partitionType = ((FileInfo)fileInfo.elem).getPartitionType();
                if (PartitionType.REDUCE.equals(partitionType)) {
                    BoxedUnit boxedUnit;
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Received open stream request ").append(shuffleKey).append(" ").append(fileName).append(" ").append(startIndex).append(" ").append(endIndex).append(" get file name ").append(fileName).append(" from client channel ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString());
                    long streamId = this.chunkStreamManager().nextStreamId();
                    if (endIndex != Integer.MAX_VALUE || endIndex == Integer.MAX_VALUE && !((FileInfo)fileInfo.elem).addStream(streamId)) {
                        fileInfo.elem = this.partitionsSorter().getSortedFileInfo(shuffleKey, fileName, (FileInfo)fileInfo.elem, startIndex, endIndex);
                    }
                    if (readLocalShuffle) {
                        this.chunkStreamManager().registerStream(streamId, shuffleKey, fileName);
                        this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler(client, rpcRequestId, streamId, ((FileInfo)fileInfo.elem).numChunks(), isLegacy, ((FileInfo)fileInfo.elem).getChunkOffsets(), ((FileInfo)fileInfo.elem).getFilePath());
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (((FileInfo)fileInfo.elem).isHdfs()) {
                        this.chunkStreamManager().registerStream(streamId, shuffleKey, fileName);
                        this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler(client, rpcRequestId, streamId, 0, isLegacy, this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$6(), this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$7());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.chunkStreamManager().registerStream(streamId, shuffleKey, new FileManagedBuffers((FileInfo)fileInfo.elem, this.transportConf()), fileName, this.storageManager().getFetchTimeMetric(((FileInfo)fileInfo.elem).getFile()));
                        if (((FileInfo)fileInfo.elem).numChunks() == 0) {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("StreamId ").append(streamId).append(", fileName ").append(fileName).append(", mapRange ").append("[").append(startIndex).append("-").append(endIndex).append("] is empty. Received from client channel ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString());
                        } else {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("StreamId ").append(streamId).append(", fileName ").append(fileName).append(", numChunks ").append(((FileInfo)fileInfo$1.elem).numChunks()).append(", ").append("mapRange [").append(startIndex).append("-").append(endIndex).append("]. Received from client channel ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString());
                        }
                        this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler(client, rpcRequestId, streamId, ((FileInfo)fileInfo.elem).numChunks(), isLegacy, this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$6(), this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$7());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else if (PartitionType.MAP.equals(partitionType)) {
                    Consumer<Long> creditStreamHandler = new Consumer<Long>(this, client, rpcRequestId, isLegacy){
                        private final /* synthetic */ FetchHandler $outer;
                        private final TransportClient client$1;
                        private final long rpcRequestId$1;
                        private final boolean isLegacy$1;

                        public Consumer<Long> andThen(Consumer<? super Long> x$1) {
                            return Consumer.super.andThen(x$1);
                        }

                        public void accept(Long streamId) {
                            this.$outer.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler(this.client$1, this.rpcRequestId$1, Predef$.MODULE$.Long2long(streamId), 0, this.isLegacy$1, this.$outer.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$6(), this.$outer.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$7());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.client$1 = client$1;
                            this.rpcRequestId$1 = rpcRequestId$1;
                            this.isLegacy$1 = isLegacy$1;
                        }
                    };
                    object = BoxesRunTime.boxToLong((long)this.creditStreamManager().registerStream(creditStreamHandler, client.getChannel(), initialCredit, startIndex, endIndex, (FileInfo)fileInfo.elem));
                } else if (PartitionType.MAPGROUP.equals(partitionType)) {
                    object = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)partitionType);
                }
                this.workerSource().incCounter(WorkerSource$.MODULE$.OPEN_STREAM_SUCCESS_COUNT());
            }
            catch (IOException e) {
                this.workerSource().incCounter(WorkerSource$.MODULE$.OPEN_STREAM_FAIL_COUNT());
                this.handleRpcIOException(client, rpcRequestId, shuffleKey, fileName, e, callback);
            }
        }
        finally {
            this.workerSource().stopTimer(WorkerSource$.MODULE$.OPEN_STREAM_TIME(), shuffleKey);
        }
    }

    private boolean handleOpenStreamInternal$default$9() {
        return false;
    }

    public void org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler(TransportClient client, long requestId, long streamId, int numChunks, boolean isLegacy, List<Long> offsets, String filepath) {
        if (isLegacy) {
            client.getChannel().writeAndFlush((Object)new RpcResponse(requestId, (ManagedBuffer)new NioManagedBuffer(new StreamHandle(streamId, numChunks).toByteBuffer())));
        } else {
            PbStreamHandler.Builder pbStreamHandlerBuilder = PbStreamHandler.newBuilder().setStreamId(streamId).setNumChunks(numChunks);
            Object object = offsets != null ? pbStreamHandlerBuilder.addAllChunkOffsets(offsets) : BoxedUnit.UNIT;
            Object object2 = new StringOps(Predef$.MODULE$.augmentString(filepath)).nonEmpty() ? pbStreamHandlerBuilder.setFullPath(filepath) : BoxedUnit.UNIT;
            PbStreamHandler pbStreamHandler = pbStreamHandlerBuilder.build();
            client.getChannel().writeAndFlush((Object)new RpcResponse(requestId, (ManagedBuffer)new NioManagedBuffer(new TransportMessage(MessageType.STREAM_HANDLER, pbStreamHandler.toByteArray()).toByteBuffer())));
        }
    }

    public List<Long> org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$6() {
        return null;
    }

    public String org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$7() {
        return "";
    }

    private void handleRpcIOException(TransportClient client, long requestId, String shuffleKey, String fileName, IOException ioe, RpcResponseCallback rpcCallback) {
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Read file: ").append(fileName).append(" with shuffleKey: ").append(shuffleKey).append(" error from ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString(), ioe);
        this.handleRpcException(client, requestId, ioe, rpcCallback);
    }

    private void handleRpcException(TransportClient client, long requestId, IOException ioe, RpcResponseCallback rpcResponseCallback) {
        rpcResponseCallback.onFailure(ExceptionUtils.wrapIOExceptionToUnRetryable((Throwable)ioe));
    }

    public void handleEndStreamFromClient(long streamId) {
        this.handleEndStreamFromClient(streamId, StreamType.CreditStream);
    }

    public void handleEndStreamFromClient(long streamId, StreamType streamType) {
        StreamType streamType2 = streamType;
        if (StreamType.ChunkStream.equals(streamType2)) {
            Tuple2<String, String> tuple2 = this.chunkStreamManager().getShuffleKeyAndFileName(streamId);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String shuffleKey = (String)tuple2._1();
            String fileName = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)shuffleKey, (Object)fileName);
            Tuple2 tuple23 = tuple22;
            String shuffleKey2 = (String)tuple23._1();
            String fileName2 = (String)tuple23._2();
            this.getRawFileInfo(shuffleKey2, fileName2).closeStream(streamId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (StreamType.CreditStream.equals(streamType2)) {
            this.creditStreamManager().notifyStreamEndByClient(streamId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Received a PbBufferStreamEnd message with unknown type ").append(streamType).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void handleReadAddCredit(int credit, long streamId) {
        this.creditStreamManager().addCredit(credit, streamId);
    }

    public void handleChunkFetchRequest(TransportClient client, StreamChunkSlice streamChunkSlice, RequestMessage req) {
        Object object = new Object();
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Received req from ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).append(" to fetch block ").append(streamChunkSlice).toString());
            this.maxChunkBeingTransferred().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)threshold -> {
                long chunksBeingTransferred = this.chunkStreamManager().chunksBeingTransferred();
                if (chunksBeingTransferred > threshold) {
                    String message = new StringBuilder(70).append("Worker is too busy. The number of chunks being transferred ").append(chunksBeingTransferred).append(" exceeds ").append(CelebornConf$.MODULE$.MAX_CHUNKS_BEING_TRANSFERRED().key()).append(" ").append(Utils$.MODULE$.bytesToString(threshold)).append(".").toString();
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                    this.workerSource().incCounter(WorkerSource$.MODULE$.FETCH_CHUNK_FAIL_COUNT());
                    client.getChannel().writeAndFlush((Object)new ChunkFetchFailure(streamChunkSlice, message));
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
            });
            String reqStr = req.toString();
            this.workerSource().startTimer(WorkerSource$.MODULE$.FETCH_CHUNK_TIME(), reqStr);
            TimeWindow fetchTimeMetric = this.chunkStreamManager().getFetchTimeMetric(streamChunkSlice.streamId);
            long fetchBeginTime = System.nanoTime();
            try {
                ManagedBuffer buf = this.chunkStreamManager().getChunk(streamChunkSlice.streamId, streamChunkSlice.chunkIndex, streamChunkSlice.offset, streamChunkSlice.len);
                this.chunkStreamManager().chunkBeingSent(streamChunkSlice.streamId);
                client.getChannel().writeAndFlush((Object)new ChunkFetchSuccess(streamChunkSlice, buf)).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(this, streamChunkSlice, fetchTimeMetric, fetchBeginTime, reqStr){
                    private final /* synthetic */ FetchHandler $outer;
                    private final StreamChunkSlice streamChunkSlice$1;
                    private final TimeWindow fetchTimeMetric$1;
                    private final long fetchBeginTime$1;
                    private final String reqStr$1;

                    public void operationComplete(Future<? super Void> future) {
                        if (future.isSuccess()) {
                            if (this.$outer.log().isDebugEnabled()) {
                                this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Sending ChunkFetchSuccess operation succeeded, chunk ").append($this.streamChunkSlice$1).toString());
                            }
                        } else {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Sending ChunkFetchSuccess operation failed, chunk ").append($this.streamChunkSlice$1).toString(), future.cause());
                        }
                        this.$outer.workerSource().incCounter(WorkerSource$.MODULE$.FETCH_CHUNK_SUCCESS_COUNT());
                        this.$outer.chunkStreamManager().chunkSent(this.streamChunkSlice$1.streamId);
                        if (this.fetchTimeMetric$1 != null) {
                            this.fetchTimeMetric$1.update(System.nanoTime() - this.fetchBeginTime$1);
                        }
                        this.$outer.workerSource().stopTimer(WorkerSource$.MODULE$.FETCH_CHUNK_TIME(), this.reqStr$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.streamChunkSlice$1 = streamChunkSlice$1;
                        this.fetchTimeMetric$1 = fetchTimeMetric$1;
                        this.fetchBeginTime$1 = fetchBeginTime$1;
                        this.reqStr$1 = reqStr$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$operationComplete$1(org.apache.celeborn.service.deploy.worker.FetchHandler$$anon$2 ), $anonfun$operationComplete$2(org.apache.celeborn.service.deploy.worker.FetchHandler$$anon$2 )}, serializedLambda);
                    }
                });
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error opening block ").append(streamChunkSlice).append(" for request from ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString(), e);
                this.workerSource().incCounter(WorkerSource$.MODULE$.FETCH_CHUNK_FAIL_COUNT());
                client.getChannel().writeAndFlush((Object)new ChunkFetchFailure(streamChunkSlice, Throwables.getStackTraceAsString((Throwable)e)));
                this.workerSource().stopTimer(WorkerSource$.MODULE$.FETCH_CHUNK_TIME(), reqStr);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public boolean checkRegistered() {
        return this.registered().get();
    }

    public void channelActive(TransportClient client) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("channel active ").append(client.getSocketAddress()).toString());
        this.workerSource().incCounter(WorkerSource$.MODULE$.ACTIVE_CONNECTION_COUNT());
        super.channelActive(client);
    }

    public void channelInactive(TransportClient client) {
        this.workerSource().incCounter(WorkerSource$.MODULE$.ACTIVE_CONNECTION_COUNT(), -1L);
        this.creditStreamManager().connectionTerminated(client.getChannel());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("channel inactive ").append(client.getSocketAddress()).toString());
    }

    public void exceptionCaught(Throwable cause, TransportClient client) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("exception caught ").append(client.getSocketAddress()).toString(), cause);
    }

    public void cleanupExpiredShuffleKey(HashSet<String> expiredShuffleKeys) {
        block0: {
            this.chunkStreamManager().cleanupExpiredShuffleKey(expiredShuffleKeys);
            if (this.partitionsSorter() == null) break block0;
            this.partitionsSorter().cleanupExpiredShuffleKey(expiredShuffleKeys);
        }
    }

    public void setPartitionsSorter(PartitionFilesSorter partitionFilesSorter) {
        this.partitionsSorter_$eq(partitionFilesSorter);
    }

    public FetchHandler(CelebornConf conf, TransportConf transportConf, WorkerSource workerSource) {
        this.conf = conf;
        this.transportConf = transportConf;
        this.workerSource = workerSource;
        Logging.$init$((Logging)this);
        this.chunkStreamManager = new ChunkStreamManager();
        this.maxChunkBeingTransferred = conf.shuffleIoMaxChunksBeingTransferred();
        this.creditStreamManager = new CreditStreamManager(conf.partitionReadBuffersMin(), conf.partitionReadBuffersMax(), conf.creditStreamThreadsPerMountpoint(), conf.readBuffersToTriggerReadMin());
        this.registered = new AtomicBoolean(false);
    }
}

