/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.shuffledb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.celeborn.common.util.PbSerDeUtils;
import org.apache.celeborn.service.deploy.worker.shuffledb.StoreVersion;
import org.fusesource.leveldbjni.JniDBFactory;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelDBProvider {
    private static final Logger logger = LoggerFactory.getLogger(LevelDBProvider.class);

    public static DB initLevelDB(File dbFile, StoreVersion version) throws IOException {
        DB tmpDb = null;
        if (dbFile != null) {
            Options options = new Options();
            options.createIfMissing(false);
            options.logger((org.iq80.leveldb.Logger)new LevelDBLogger());
            try {
                tmpDb = JniDBFactory.factory.open(dbFile, options);
            }
            catch (NativeDB.DBException e) {
                if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                    logger.info("Creating state database at " + dbFile);
                    options.createIfMissing(true);
                    try {
                        tmpDb = JniDBFactory.factory.open(dbFile, options);
                    }
                    catch (NativeDB.DBException dbExc) {
                        throw new IOException("Unable to create state store", dbExc);
                    }
                }
                logger.error("error opening leveldb file {}.  Creating new file, will not be able to recover state for existing applications", (Object)dbFile, (Object)e);
                if (dbFile.isDirectory()) {
                    for (File f : dbFile.listFiles()) {
                        if (f.delete()) continue;
                        logger.warn("error deleting {}", (Object)f.getPath());
                    }
                }
                if (!dbFile.delete()) {
                    logger.warn("error deleting {}", (Object)dbFile.getPath());
                }
                options.createIfMissing(true);
                try {
                    tmpDb = JniDBFactory.factory.open(dbFile, options);
                }
                catch (NativeDB.DBException dbExc) {
                    throw new IOException("Unable to create state store", dbExc);
                }
            }
            LevelDBProvider.checkVersion(tmpDb, version);
        }
        return tmpDb;
    }

    public static void checkVersion(DB db, StoreVersion newversion) throws IOException {
        byte[] bytes = db.get(StoreVersion.KEY);
        if (bytes == null) {
            LevelDBProvider.storeVersion(db, newversion);
        } else {
            ArrayList versions = PbSerDeUtils.fromPbStoreVersion((byte[])bytes);
            StoreVersion version = new StoreVersion((Integer)versions.get(0), (Integer)versions.get(1));
            if (version.major != newversion.major) {
                throw new IOException("cannot read state DB with version " + version + ", incompatible with current version " + newversion);
            }
            LevelDBProvider.storeVersion(db, newversion);
        }
    }

    public static void storeVersion(DB db, StoreVersion version) throws IOException {
        db.put(StoreVersion.KEY, PbSerDeUtils.toPbStoreVersion((int)version.major, (int)version.minor));
    }

    private static class LevelDBLogger
    implements org.iq80.leveldb.Logger {
        private static final Logger LOG = LoggerFactory.getLogger(LevelDBLogger.class);

        private LevelDBLogger() {
        }

        public void log(String message) {
            LOG.info(message);
        }
    }
}

