/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.message.ControlMessages$;
import org.apache.celeborn.common.protocol.message.Message;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.shaded.com.google.protobuf.ByteString;
import org.apache.celeborn.shaded.com.google.protobuf.GeneratedMessageV3;
import org.apache.celeborn.shaded.io.netty.channel.unix.Errors;
import org.apache.celeborn.shaded.org.apache.commons.lang3.SystemUtils;
import org.apache.celeborn.shaded.org.apache.commons.lang3.time.FastDateFormat;
import org.apache.celeborn.shaded.org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;

public final class Utils$
implements Logging {
    public static Utils$ MODULE$;
    private InetAddress localIpAddress;
    private final long[] siByteSizes;
    private final String[] siByteSuffixes;
    private final boolean isWindows;
    private final boolean isMac;
    private final boolean isMacOnAppleSilicon;
    private Option<String> customHostname;
    private final ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults;
    private int maxDefaultNettyThreads;
    private final String SORTED_SUFFIX;
    private final String INDEX_SUFFIX;
    private final String SUFFIX_HDFS_WRITE_SUCCESS;
    private final String COMPATIBLE_HDFS_REGEX;
    private final int UNKNOWN_APP_SHUFFLE_ID;
    private final FastDateFormat dateFmt;
    private transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new Utils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public Seq<String> stringToSeq(String str) {
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])str.split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$stringToSeq$2(x$2))));
    }

    public scala.collection.immutable.Map<String, String> getSystemProperties() {
        return ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(System.getProperties().stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)key -> new Tuple2(key, (Object)System.getProperty(key)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public long timeStringAsMs(String str) {
        return JavaUtils.timeStringAsMs(str);
    }

    public long timeStringAsSeconds(String str) {
        return JavaUtils.timeStringAsSec(str);
    }

    public long byteStringAsBytes(String str) {
        return JavaUtils.byteStringAsBytes(str);
    }

    public long byteStringAsKb(String str) {
        return JavaUtils.byteStringAsKb(str);
    }

    public long byteStringAsMb(String str) {
        return JavaUtils.byteStringAsMb(str);
    }

    public long byteStringAsGb(String str) {
        return JavaUtils.byteStringAsGb(str);
    }

    public int memoryStringToMb(String str) {
        return (int)(JavaUtils.byteStringAsBytes(str) / 1024L / 1024L);
    }

    public String bytesToString(long size) {
        int i;
        for (i = 0; i < this.siByteSizes.length - 1 && size < 2L * this.siByteSizes[i]; ++i) {
        }
        return new StringOps(Predef$.MODULE$.augmentString("%.1f %s")).formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)size / (double)this.siByteSizes[i])), this.siByteSuffixes[i]}));
    }

    public String bytesToString(BigInt size) {
        long EiB = 0x1000000000000000L;
        if (size.isValidLong()) {
            return this.bytesToString(size.toLong());
        }
        if (size.$less((Object)scala.package$.MODULE$.BigInt().apply(2048L).$times(BigInt$.MODULE$.long2bigInt(EiB)))) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f EiB")).formatLocal(Locale.US, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scala.package$.MODULE$.BigDecimal().apply(size).$div(BigDecimal$.MODULE$.long2bigDecimal(EiB))}));
        }
        return new java.lang.StringBuilder(2).append(scala.package$.MODULE$.BigDecimal().apply(size, new MathContext(3, RoundingMode.HALF_UP)).toString()).append(" B").toString();
    }

    public String megabytesToString(long megabytes) {
        return this.bytesToString(megabytes * 1024L * 1024L);
    }

    public String msDurationToString(long ms) {
        int second = 1000;
        int minute = 60 * second;
        int hour = 60 * minute;
        Locale locale = Locale.US;
        long l = ms;
        if (l < (long)second) {
            return new StringOps(Predef$.MODULE$.augmentString("%d ms")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l)}));
        }
        if (l < (long)minute) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f s")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)second))}));
        }
        if (l < (long)hour) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f m")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)minute))}));
        }
        return new StringOps(Predef$.MODULE$.augmentString("%.2f h")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)hour))}));
    }

    public String nanoDurationToString(long ns) {
        long ms = 1000000L;
        long second = 1000L * ms;
        long minute = 60L * second;
        long hour = 60L * minute;
        Locale locale = Locale.US;
        long l = ns;
        if (l < ms) {
            return new StringOps(Predef$.MODULE$.augmentString("%d ns")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l)}));
        }
        if (l < second) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f ms")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)ms))}));
        }
        if (l < minute) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f s")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)second))}));
        }
        if (l < hour) {
            return new StringOps(Predef$.MODULE$.augmentString("%.1f m")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)minute))}));
        }
        return new StringOps(Predef$.MODULE$.augmentString("%.2f h")).formatLocal(locale, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)((float)l / (float)hour))}));
    }

    public Tuple2<String, Object> extractHostPortFromCelebornUrl(String celebornUrl) throws CelebornException {
        Tuple2 tuple2;
        try {
            int port;
            String host;
            block5: {
                block4: {
                    URI uri = new URI(celebornUrl);
                    host = uri.getHost();
                    port = uri.getPort();
                    String string = uri.getScheme();
                    String string2 = "celeborn";
                    if (string != null ? !string.equals(string2) : string2 != null) break block4;
                    if (host != null && port >= 0 && (uri.getPath() == null || !new StringOps(Predef$.MODULE$.augmentString(uri.getPath())).nonEmpty()) && uri.getFragment() == null && uri.getQuery() == null && uri.getUserInfo() == null) break block5;
                }
                throw new CelebornException(new java.lang.StringBuilder(20).append("Invalid master URL: ").append(celebornUrl).toString());
            }
            tuple2 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
        }
        catch (URISyntaxException e) {
            throw new CelebornException(new java.lang.StringBuilder(20).append("Invalid master URL: ").append(celebornUrl).toString(), e);
        }
        return tuple2;
    }

    public Tuple3<String, Object, String> extractHostPortNameFromCelebornUrl(String celebornUrl) throws CelebornException {
        Tuple3 tuple3;
        try {
            String name;
            int port;
            String host;
            block5: {
                block4: {
                    URI uri = new URI(celebornUrl);
                    host = uri.getHost();
                    port = uri.getPort();
                    name = uri.getUserInfo();
                    String string = uri.getScheme();
                    String string2 = "celeborn";
                    if (string != null ? !string.equals(string2) : string2 != null) break block4;
                    if (host != null && port >= 0 && name != null && (uri.getPath() == null || !new StringOps(Predef$.MODULE$.augmentString(uri.getPath())).nonEmpty()) && uri.getFragment() == null && uri.getQuery() == null) break block5;
                }
                throw new CelebornException(new java.lang.StringBuilder(22).append("Invalid Celeborn URL: ").append(celebornUrl).toString());
            }
            tuple3 = new Tuple3((Object)host, (Object)BoxesRunTime.boxToInteger((int)port), (Object)name);
        }
        catch (URISyntaxException e) {
            throw new CelebornException(new java.lang.StringBuilder(22).append("Invalid Celeborn URL: ").append(celebornUrl).toString(), e);
        }
        return tuple3;
    }

    public <T> T tryOrIOException(Function0<T> block) {
        Object object;
        try {
            object = block.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception encountered", iOException);
                throw iOException;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception encountered", e);
                throw new IOException(e);
            }
            throw throwable;
        }
        return (T)object;
    }

    public void tryLogNonFatalError(Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(29).append("Uncaught exception in thread ").append(Thread.currentThread().getName()).toString(), t);
            }
            throw throwable;
        }
    }

    public void tryOrExit(Function0<BoxedUnit> block) {
        try {
            block.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ControlThrowable) {
                ControlThrowable controlThrowable = (ControlThrowable)throwable2;
                throw (Throwable)controlThrowable;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                throw throwable3;
            }
            throw throwable;
        }
    }

    public <T> Tuple2<T, Object> startServiceOnPort(int startPort, Function1<Object, Tuple2<T, Object>> startService, CelebornConf conf, String serviceName) {
        Object object = new Object();
        try {
            Predef$.MODULE$.require(startPort == 0 || 1024 <= startPort && startPort < 65536, (Function0 & Serializable & scala.Serializable)() -> "startPort should be between 1024 and 65535 (inclusive), or 0 for a random free port.");
            String serviceString = serviceName.isEmpty() ? "" : new java.lang.StringBuilder(3).append(" '").append(serviceName).append("'").toString();
            int maxRetries = conf.portMaxRetries();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxRetries).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
                int tryPort = startPort == 0 ? startPort : MODULE$.userPort(startPort, offset);
                try {
                    Tuple2 tuple2 = (Tuple2)startService.apply((Object)BoxesRunTime.boxToInteger((int)tryPort));
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object service = tuple2._1();
                    int port = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2(service, (Object)BoxesRunTime.boxToInteger((int)port));
                    Object service2 = tuple22._1();
                    int port2 = tuple22._2$mcI$sp();
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(38).append("Successfully started service").append(serviceString).append(" on port ").append(port2).append(".").toString());
                    throw new NonLocalReturnControl(object, (Object)new Tuple2(service2, (Object)BoxesRunTime.boxToInteger((int)port2)));
                }
                catch (Throwable throwable) {
                    Exception exception;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof Exception && MODULE$.isBindCollision(exception = (Exception)throwable2)) {
                        if (offset >= maxRetries) {
                            String exceptionMessage = startPort == 0 ? new java.lang.StringBuilder(164).append(exception.getMessage()).append(": Service").append(serviceString).append(" failed after ").append(maxRetries).append(" retries (on a random free port)! ").append("Consider explicitly setting the appropriate binding address for ").append("the service").append(serviceString).append(" to the correct binding address.").toString() : new java.lang.StringBuilder(151).append(exception.getMessage()).append(": Service").append(serviceString).append(" failed after ").append(maxRetries).append(" retries (starting from ").append(startPort).append(")! Consider explicitly setting ").append("the appropriate port for the service").append(serviceString).append(" to an available port ").append("or increasing ").append(CelebornConf$.MODULE$.PORT_MAX_RETRY().key()).append(".").toString();
                            BindException exception2 = new BindException(exceptionMessage);
                            exception2.setStackTrace(exception.getStackTrace());
                            throw exception2;
                        }
                        if (startPort == 0) {
                            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(111).append("Service").append(serviceString).append(" could not bind on a random free port. ").append("You may check whether configuring an appropriate binding address.").toString());
                        } else {
                            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(50).append("Service").append(serviceString).append(" could not bind on port ").append(tryPort).append(". ").append("Attempting port ").append(tryPort + 1).append(".").toString());
                        }
                    } else {
                        throw throwable;
                    }
                    return;
                }
            });
            throw new CelebornException(new java.lang.StringBuilder(32).append("Failed to start service").append(serviceString).append(" on port ").append(startPort).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple2)ex.value();
        }
    }

    public <T> String startServiceOnPort$default$4() {
        return "";
    }

    public int userPort(int base, int offset) {
        return (base + offset - 1024) % 64512 + 1024;
    }

    public boolean isBindCollision(Throwable exception) {
        while (true) {
            Throwable throwable;
            if ((throwable = exception) instanceof BindException) {
                BindException bindException = (BindException)throwable;
                if (bindException.getMessage() != null) {
                    return true;
                }
                exception = bindException.getCause();
                continue;
            }
            if (throwable instanceof Errors.NativeIoException) {
                Errors.NativeIoException nativeIoException = (Errors.NativeIoException)throwable;
                if (nativeIoException.getMessage() == null || !nativeIoException.getMessage().startsWith("bind() failed: ")) {
                    exception = nativeIoException.getCause();
                    continue;
                }
                return true;
            }
            if (!(throwable instanceof Exception)) break;
            Exception exception2 = (Exception)throwable;
            exception = exception2.getCause();
        }
        return false;
    }

    public String encodeFileNameToURIRawPath(String fileName) {
        Predef$.MODULE$.require(!fileName.contains("/") && !fileName.contains("\\"));
        return new URI("file", null, "localhost", -1, new java.lang.StringBuilder(1).append("/").append(fileName).toString(), null, null).getRawPath().substring(1);
    }

    public <T> Seq<T> randomize(TraversableOnce<T> seq, ClassTag<T> evidence$1) {
        return Predef$.MODULE$.genericWrapArray(this.randomizeInPlace(seq.toArray(evidence$1), this.randomizeInPlace$default$2()));
    }

    public <T> Object randomizeInPlace(Object arr, Random rand) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(ScalaRunTime$.MODULE$.array_length(arr) - 1), 1).by(-1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int j = rand.nextInt(i + 1);
            Object tmp = ScalaRunTime$.MODULE$.array_apply(arr, j);
            ScalaRunTime$.MODULE$.array_update(arr, j, ScalaRunTime$.MODULE$.array_apply(arr, i));
            ScalaRunTime$.MODULE$.array_update(arr, i, tmp);
        });
        return arr;
    }

    public <T> Random randomizeInPlace$default$2() {
        return new Random();
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    public boolean isMac() {
        return this.isMac;
    }

    public boolean isMacOnAppleSilicon() {
        return this.isMacOnAppleSilicon;
    }

    private InetAddress localIpAddress$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if (!this.bitmap$0) {
                this.localIpAddress = this.findLocalInetAddress();
                this.bitmap$0 = true;
            }
        }
        return this.localIpAddress;
    }

    private InetAddress localIpAddress() {
        if (!this.bitmap$0) {
            return this.localIpAddress$lzycompute();
        }
        return this.localIpAddress;
    }

    /*
     * WARNING - void declaration
     */
    private InetAddress findLocalInetAddress() {
        InetAddress inetAddress;
        Object object = new Object();
        try {
            String defaultIpOverride = System.getenv("CELEBORN_LOCAL_IP");
            if (defaultIpOverride != null) {
                inetAddress = InetAddress.getByName(defaultIpOverride);
            } else {
                void var3_3;
                InetAddress address = InetAddress.getLocalHost();
                if (address.isLoopbackAddress()) {
                    Seq activeNetworkIFs = ((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(NetworkInterface.getNetworkInterfaces()).asScala()).toSeq();
                    Seq reOrderedNetworkIFs = this.isWindows() ? activeNetworkIFs : (Seq)activeNetworkIFs.reverse();
                    reOrderedNetworkIFs.foreach((Function1 & Serializable & scala.Serializable)ni -> {
                        Utils$.$anonfun$findLocalInetAddress$1(address, object, ni);
                        return BoxedUnit.UNIT;
                    });
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(95).append("Your hostname, ").append(InetAddress.getLocalHost().getHostName()).append(" resolves to").append(" a loopback address: ").append(address.getHostAddress()).append(", but we couldn't find any").append(" external IP address!").toString());
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Set CELEBORN_LOCAL_IP if you need to bind to another address");
                }
                inetAddress = var3_3;
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                inetAddress = (InetAddress)ex.value();
            }
            throw ex;
        }
        return inetAddress;
    }

    private Option<String> customHostname() {
        return this.customHostname;
    }

    private void customHostname_$eq(Option<String> x$1) {
        this.customHostname = x$1;
    }

    public void setCustomHostname(String hostname) {
        this.checkHost(hostname);
        this.customHostname_$eq((Option<String>)new Some((Object)hostname));
    }

    public String localHostName(CelebornConf conf) {
        return (String)this.customHostname().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (conf.bindPreferIP()) {
                return MODULE$.localIpAddress().getHostAddress();
            }
            return MODULE$.localIpAddress().getCanonicalHostName();
        });
    }

    public void checkHost(String host) {
        if (host != null && host.split(":").length > 2) {
            Predef$.MODULE$.assert(host.startsWith("[") && host.endsWith("]"), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(52).append("Expected hostname or IPv6 IP enclosed in [] but got ").append(host).toString());
            return;
        }
        Predef$.MODULE$.assert(host != null && host.indexOf(58) == -1, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("Expected hostname or IP but got ").append(host).toString());
    }

    public void checkHostPort(String hostPort) {
        if (hostPort != null && hostPort.split(":").length > 2) {
            Predef$.MODULE$.assert(hostPort != null && hostPort.indexOf("]:") != -1, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(31).append("Expected host and port but got ").append(hostPort).toString());
            return;
        }
        Predef$.MODULE$.assert(hostPort != null && hostPort.indexOf(58) != -1, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(31).append("Expected host and port but got ").append(hostPort).toString());
    }

    private ConcurrentHashMap<String, Tuple2<String, Object>> hostPortParseResults() {
        return this.hostPortParseResults;
    }

    public Tuple2<String, Object> parseHostPort(String hostPort) {
        Tuple2<String, Object> tuple2;
        Tuple2<String, Object> cached = this.hostPortParseResults().get(hostPort);
        if (cached != null) {
            return cached;
        }
        if (hostPort != null && hostPort.split(":").length > 2) {
            int index = hostPort.lastIndexOf("]:");
            if (-1 == index) {
                return this.setDefaultPortValue$1(hostPort);
            }
            String port = hostPort.substring(index + 2).trim();
            Tuple2 retVal = new Tuple2((Object)hostPort.substring(0, index + 1).trim(), (Object)(port.isEmpty() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port)).toInt())));
            tuple2 = this.hostPortParseResults().putIfAbsent(hostPort, (Tuple2<String, Object>)retVal);
        } else {
            int index = hostPort.lastIndexOf(58);
            if (-1 == index) {
                return this.setDefaultPortValue$1(hostPort);
            }
            String port = hostPort.substring(index + 1).trim();
            Tuple2 retVal = new Tuple2((Object)hostPort.substring(0, index).trim(), (Object)(port.isEmpty() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port)).toInt())));
            tuple2 = this.hostPortParseResults().putIfAbsent(hostPort, (Tuple2<String, Object>)retVal);
        }
        return this.hostPortParseResults().get(hostPort);
    }

    private int maxDefaultNettyThreads() {
        return this.maxDefaultNettyThreads;
    }

    private void maxDefaultNettyThreads_$eq(int x$1) {
        this.maxDefaultNettyThreads = x$1;
    }

    public TransportConf fromCelebornConf(CelebornConf _conf, String module, int numUsableCores) {
        CelebornConf conf = _conf.clone();
        this.maxDefaultNettyThreads_$eq(conf.maxDefaultNettyThreads());
        int numThreads = this.defaultNumThreads(numUsableCores);
        conf.setIfMissing(new java.lang.StringBuilder(26).append("celeborn.").append(module).append(".io.serverThreads").toString(), Integer.toString(numThreads));
        conf.setIfMissing(new java.lang.StringBuilder(26).append("celeborn.").append(module).append(".io.clientThreads").toString(), Integer.toString(numThreads));
        Object object = "push".equals(module) ? conf.setIfMissing(new java.lang.StringBuilder(34).append("celeborn.").append(module).append(".io.numConnectionsPerPeer").toString(), Integer.toString(numThreads)) : BoxedUnit.UNIT;
        return new TransportConf(module, conf);
    }

    public int fromCelebornConf$default$3() {
        return 0;
    }

    private int defaultNumThreads(int numUsableCores) {
        int availableCores = numUsableCores > 0 ? numUsableCores : Runtime.getRuntime().availableProcessors();
        return package$.MODULE$.min(availableCores, this.maxDefaultNettyThreads());
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public ClassLoader getContextOrClassLoader() {
        return (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClassLoader());
    }

    public boolean classIsLoadable(String clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Class.forName(clazz, false, MODULE$.getContextOrClassLoader())).isSuccess();
    }

    public Class<?> classForName(String className) {
        return Class.forName(className, true, this.getContextOrClassLoader());
    }

    public String getCodeSourceLocation(Class<?> clazz) {
        return new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getPath();
    }

    public String loadDefaultCelebornProperties(CelebornConf conf, String filePath) {
        String path = (String)Option$.MODULE$.apply((Object)filePath).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getDefaultPropertiesFile(MODULE$.getDefaultPropertiesFile$default$1()));
        Option$.MODULE$.apply((Object)path).foreach((Function1 & Serializable & scala.Serializable)confFile -> {
            Utils$.$anonfun$loadDefaultCelebornProperties$2(conf, confFile);
            return BoxedUnit.UNIT;
        });
        return path;
    }

    public String loadDefaultCelebornProperties$default$2() {
        return null;
    }

    public String getDefaultPropertiesFile(scala.collection.immutable.Map<String, String> env) {
        return (String)env.get((Object)"CELEBORN_CONF_DIR").orElse((Function0 & Serializable & scala.Serializable)() -> env.get((Object)"CELEBORN_HOME").map((Function1 & Serializable & scala.Serializable)t -> new java.lang.StringBuilder(4).append((String)t).append(File.separator).append("conf").toString())).map((Function1 & Serializable & scala.Serializable)t -> new File(new java.lang.StringBuilder(22).append((String)t).append(File.separator).append("celeborn-defaults.conf").toString())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isFile())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getAbsolutePath()).orNull(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, String> getDefaultPropertiesFile$default$1() {
        return scala.sys.package$.MODULE$.env();
    }

    public String getDefaultQuotaConfigurationFile(scala.collection.immutable.Map<String, String> env) {
        return (String)env.get((Object)"CELEBORN_CONF_DIR").orElse((Function0 & Serializable & scala.Serializable)() -> env.get((Object)"CELEBORN_HOME").map((Function1 & Serializable & scala.Serializable)t -> new java.lang.StringBuilder(4).append((String)t).append(File.separator).append("conf").toString())).map((Function1 & Serializable & scala.Serializable)t -> new File(new java.lang.StringBuilder(10).append((String)t).append(File.separator).append("quota.yaml").toString())).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isFile())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getAbsolutePath()).orNull(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, String> getDefaultQuotaConfigurationFile$default$1() {
        return scala.sys.package$.MODULE$.env();
    }

    public String trimExceptCRLF(String str) {
        Function1 & Serializable & scala.Serializable nonSpaceOrNaturalLineDelimiter = (Function1 & Serializable & scala.Serializable)ch -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$trimExceptCRLF$1(BoxesRunTime.unboxToChar((Object)ch)));
        int firstPos = new StringOps(Predef$.MODULE$.augmentString(str)).indexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        int lastPos = new StringOps(Predef$.MODULE$.augmentString(str)).lastIndexWhere((Function1)nonSpaceOrNaturalLineDelimiter);
        if (firstPos >= 0 && lastPos >= 0) {
            return str.substring(firstPos, lastPos + 1);
        }
        return "";
    }

    public scala.collection.immutable.Map<String, String> getPropertiesFromFile(String filename) {
        scala.collection.immutable.Map map;
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(31).append("Properties file ").append(file).append(" does not exist").toString());
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(37).append("Properties file ").append(file).append(" is not a normal file").toString());
        try (InputStreamReader inReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            try {
                Properties properties = new Properties();
                properties.load(inReader);
                map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(properties.stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)MODULE$.trimExceptCRLF(properties.getProperty((String)k))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            catch (IOException e) {
                throw new CelebornException(new java.lang.StringBuilder(45).append("Failed when loading Celeborn properties from ").append(filename).toString(), e);
            }
        }
        return map;
    }

    public String makeShuffleKey(String applicationId, int shuffleId) {
        return new java.lang.StringBuilder(1).append(applicationId).append("-").append(shuffleId).toString();
    }

    public Tuple2<String, Object> splitShuffleKey(String shuffleKey) {
        String[] splits = shuffleKey.split("-");
        String appId = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splits)).dropRight(1))).mkString("-");
        int shuffleId = new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splits)).last())).toInt();
        return new Tuple2((Object)appId, (Object)BoxesRunTime.boxToInteger((int)shuffleId));
    }

    public Tuple2<Object, Object> splitPartitionLocationUniqueId(String uniqueId) {
        String[] splits = uniqueId.split("-");
        int partitionId = new StringOps(Predef$.MODULE$.augmentString(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splits)).dropRight(1))).mkString("-"))).toInt();
        int epoch = new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splits)).last())).toInt();
        return new Tuple2.mcII.sp(partitionId, epoch);
    }

    public String makeReducerKey(int shuffleId, int partitionId) {
        return new java.lang.StringBuilder(1).append(shuffleId).append("-").append(partitionId).toString();
    }

    public String makeMapKey(String applicationId, int shuffleId, int mapId, int attemptId) {
        return new java.lang.StringBuilder(3).append(applicationId).append("-").append(shuffleId).append("-").append(mapId).append("-").append(attemptId).toString();
    }

    public String makeMapKey(int shuffleId, int mapId, int attemptId) {
        return new java.lang.StringBuilder(2).append(shuffleId).append("-").append(mapId).append("-").append(attemptId).toString();
    }

    public String shuffleKeyPrefix(String shuffleKey) {
        return new java.lang.StringBuilder(1).append(shuffleKey).append("-").toString();
    }

    public int bytesToInt(byte[] bytes, boolean bigEndian) {
        if (bigEndian) {
            return bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3];
        }
        return bytes[3] << 24 | bytes[2] << 16 | bytes[1] << 8 | bytes[0];
    }

    public boolean bytesToInt$default$2() {
        return true;
    }

    public long timeIt(Function0<BoxedUnit> f) {
        long start = System.currentTimeMillis();
        f.apply$mcV$sp();
        return System.currentTimeMillis() - start;
    }

    public String getThreadDump() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String pid = runtimeMXBean.getName().split("@")[0];
        return this.runCommand(new java.lang.StringBuilder(10).append("jstack -l ").append(pid).toString());
    }

    private String readProcessStdout(Process process) {
        String string;
        try (BufferedSource source = Source$.MODULE$.fromInputStream(process.getInputStream(), Codec$.MODULE$.fallbackSystemCodec());){
            string = source.mkString();
        }
        return string;
    }

    public String runCommand(String cmd) {
        Process process = Runtime.getRuntime().exec(cmd);
        return this.readProcessStdout(process);
    }

    public String runCommandComplex(String cmd) {
        String[] cmds = (String[])((Object[])new String[]{"/bin/sh", "-c", cmd});
        Process process = Runtime.getRuntime().exec(cmds);
        return this.readProcessStdout(process);
    }

    public Process executeCommand(Seq<String> command, File workingDir, scala.collection.immutable.Map<String, String> extraEnvironment, boolean redirectStderr) {
        Object object;
        ProcessBuilder builder = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class))).directory(workingDir);
        Map<String, String> environment = builder.environment();
        extraEnvironment.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$executeCommand$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return environment.put(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        Process process = builder.start();
        if (redirectStderr) {
            String threadName = new java.lang.StringBuilder(28).append("redirect stderr for command ").append(command.head()).toString();
            object = this.processStreamByLine(threadName, process.getErrorStream(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
                this.log$1(s);
                return BoxedUnit.UNIT;
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        return process;
    }

    public File executeCommand$default$2() {
        return new File(".");
    }

    public scala.collection.immutable.Map<String, String> executeCommand$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean executeCommand$default$4() {
        return true;
    }

    public String executeAndGetOutput(Seq<String> command, File workingDir, scala.collection.immutable.Map<String, String> extraEnvironment, boolean redirectStderr) {
        Process process = this.executeCommand(command, workingDir, extraEnvironment, redirectStderr);
        StringBuilder output = new StringBuilder();
        String threadName = new java.lang.StringBuilder(16).append("read stdout for ").append(command.head()).toString();
        Thread stdoutThread = this.processStreamByLine(threadName, process.getInputStream(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
            Utils$.appendToOutput$1(s, output);
            return BoxedUnit.UNIT;
        });
        int exitCode = process.waitFor();
        stdoutThread.join();
        if (exitCode != 0) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(28).append("Process ").append(command).append(" exited with code ").append(exitCode).append(": ").append((CharSequence)output).toString());
            throw new CelebornException(new java.lang.StringBuilder(26).append("Process ").append(command).append(" exited with code ").append(exitCode).toString());
        }
        return output.toString();
    }

    public File executeAndGetOutput$default$2() {
        return new File(".");
    }

    public scala.collection.immutable.Map<String, String> executeAndGetOutput$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean executeAndGetOutput$default$4() {
        return true;
    }

    public Thread processStreamByLine(String threadName, InputStream inputStream, Function1<String, BoxedUnit> processLine) {
        Thread t = new Thread(threadName, inputStream, processLine){
            private final InputStream inputStream$1;
            private final Function1 processLine$1;

            public void run() {
                Source$.MODULE$.fromInputStream(this.inputStream$1, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1 & Serializable & scala.Serializable)line -> {
                    anon.1.$anonfun$run$1(this, line);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$run$1(anon.1 $this, String line) {
                $this.processLine$1.apply((Object)line);
            }
            {
                this.inputStream$1 = inputStream$1;
                this.processLine$1 = processLine$1;
                super(threadName$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.celeborn.common.util.Utils$$anon$1 java.lang.String )}, serializedLambda);
            }
        };
        t.setDaemon(true);
        t.start();
        return t;
    }

    public File createDirectory(String root, String namePrefix) {
        int attempts = 0;
        int maxAttempts = 10;
        File dir = null;
        while (dir == null) {
            if (++attempts > maxAttempts) {
                throw new IOException(new java.lang.StringBuilder(59).append("Failed to create a temp directory (under ").append(root).append(") after ").append(maxAttempts).append(" attempts!").toString());
            }
            try {
                dir = new File(root, new java.lang.StringBuilder(1).append(namePrefix).append("-").append(UUID.randomUUID().toString()).toString());
                if (!dir.exists() && dir.mkdirs()) continue;
                dir = null;
            }
            catch (SecurityException securityException) {
                dir = null;
            }
        }
        return dir.getCanonicalFile();
    }

    public String createDirectory$default$2() {
        return "celeborn";
    }

    public File createTempDir(String root, String namePrefix) {
        File dir = this.createDirectory(root, namePrefix);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(dir){
            private final File dir$1;

            public void run() {
                if (this.dir$1 != null) {
                    JavaUtils.deleteRecursively(this.dir$1);
                    return;
                }
            }
            {
                this.dir$1 = dir$1;
            }
        }));
        return dir;
    }

    public String createTempDir$default$1() {
        return System.getProperty("java.io.tmpdir");
    }

    public String createTempDir$default$2() {
        return "celeborn";
    }

    public String mkString(Seq<String> args, String sep) {
        return args.mkString(sep);
    }

    public String mkString$default$2() {
        return ",";
    }

    public Map<WorkerInfo, Map<String, Integer>> getSlotsPerDisk(HashMap<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>> slots) {
        HashMap<WorkerInfo, Map<String, Integer>> workerSlotsDistribution = new HashMap<WorkerInfo, Map<String, Integer>>();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(slots).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                WorkerInfo workerInfo = (WorkerInfo)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    List primaryPartitionLoc = (List)tuple22._1();
                    List replicaPartitionLoc = (List)tuple22._2();
                    HashMap diskSlotsMap = new HashMap();
                    Utils$.countSlotsByDisk$1(primaryPartitionLoc, diskSlotsMap);
                    Utils$.countSlotsByDisk$1(replicaPartitionLoc, diskSlotsMap);
                    return workerSlotsDistribution.put(workerInfo, diskSlotsMap);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return workerSlotsDistribution;
    }

    public Map<String, Integer> getSlotsPerDisk(List<PartitionLocation> masterLocations, List<PartitionLocation> workerLocations) {
        HashMap<String, Integer> slotDistributions = new HashMap<String, Integer>();
        ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(masterLocations).asScala()).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(workerLocations).asScala()).foreach((Function1 & Serializable & scala.Serializable)location -> {
            String mountPoint = location.getStorageInfo().getMountPoint();
            if (slotDistributions.containsKey(mountPoint)) {
                return slotDistributions.put(mountPoint, Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)slotDistributions.get(mountPoint)) + 1));
            }
            return slotDistributions.put(mountPoint, Predef$.MODULE$.int2Integer(1));
        });
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(33).append("locations to distribution, ").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(masterLocations).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toString(), Buffer$.MODULE$.canBuildFrom())).mkString(",")).append(" ").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(workerLocations).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toString(), Buffer$.MODULE$.canBuildFrom())).mkString(",")).append(" ").append("to ").append(slotDistributions).append(" ").toString());
        return slotDistributions;
    }

    public <T> T tryWithTimeoutAndCallback(Function0<T> block, Function0<T> callback, ThreadPoolExecutor threadPool, long timeoutInSeconds, String errorMessage) {
        Object object;
        Callable futureTask = new Callable<T>(block){
            private final Function0 block$1;

            public T call() {
                return (T)this.block$1.apply();
            }
            {
                this.block$1 = block$1;
            }
        };
        Future future = null;
        try {
            try {
                future = threadPool.submit(futureTask);
                object = future.get(timeoutInSeconds, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(44).append("TimeoutException in thread ").append(Thread.currentThread().getName()).append(",").append(" error message: ").append(errorMessage).toString());
                object = callback.apply();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        finally {
            if (future != null && !future.isCancelled()) {
                future.cancel(true);
            }
        }
        return object;
    }

    public <T> long tryWithTimeoutAndCallback$default$4(Function0<T> block, Function0<T> callback) {
        return 10L;
    }

    public <T> String tryWithTimeoutAndCallback$default$5(Function0<T> block, Function0<T> callback) {
        return "none";
    }

    public Object toTransportMessage(Object message) {
        Object object = message;
        if (object instanceof Message) {
            Message message2 = (Message)object;
            return ControlMessages$.MODULE$.toTransportMessage(message2);
        }
        if (object instanceof GeneratedMessageV3) {
            GeneratedMessageV3 generatedMessageV3 = (GeneratedMessageV3)object;
            return ControlMessages$.MODULE$.toTransportMessage(generatedMessageV3);
        }
        return message;
    }

    public Object fromTransportMessage(Object message) {
        Object object = message;
        if (object instanceof TransportMessage) {
            TransportMessage transportMessage = (TransportMessage)object;
            return ControlMessages$.MODULE$.fromTransportMessage(transportMessage);
        }
        return message;
    }

    public StatusCode toStatusCode(int status) {
        int n = status;
        switch (n) {
            case 0: {
                return StatusCode.SUCCESS;
            }
            case 1: {
                return StatusCode.PARTIAL_SUCCESS;
            }
            case 2: {
                return StatusCode.REQUEST_FAILED;
            }
            case 3: {
                return StatusCode.SHUFFLE_ALREADY_REGISTERED;
            }
            case 4: {
                return StatusCode.SHUFFLE_NOT_REGISTERED;
            }
            case 5: {
                return StatusCode.RESERVE_SLOTS_FAILED;
            }
            case 6: {
                return StatusCode.SLOT_NOT_AVAILABLE;
            }
            case 7: {
                return StatusCode.WORKER_NOT_FOUND;
            }
            case 8: {
                return StatusCode.PARTITION_NOT_FOUND;
            }
            case 9: {
                return StatusCode.REPLICA_PARTITION_NOT_FOUND;
            }
            case 10: {
                return StatusCode.DELETE_FILES_FAILED;
            }
            case 11: {
                return StatusCode.PARTITION_EXISTS;
            }
            case 12: {
                return StatusCode.REVIVE_FAILED;
            }
            case 13: {
                return StatusCode.REPLICATE_DATA_FAILED;
            }
            case 14: {
                return StatusCode.NUM_MAPPER_ZERO;
            }
            case 15: {
                return StatusCode.MAP_ENDED;
            }
            case 16: {
                return StatusCode.STAGE_ENDED;
            }
            case 17: {
                return StatusCode.PUSH_DATA_FAIL_NON_CRITICAL_CAUSE;
            }
            case 18: {
                return StatusCode.PUSH_DATA_WRITE_FAIL_REPLICA;
            }
            case 19: {
                return StatusCode.PUSH_DATA_WRITE_FAIL_PRIMARY;
            }
            case 20: {
                return StatusCode.PUSH_DATA_FAIL_PARTITION_NOT_FOUND;
            }
            case 21: {
                return StatusCode.HARD_SPLIT;
            }
            case 22: {
                return StatusCode.SOFT_SPLIT;
            }
            case 23: {
                return StatusCode.STAGE_END_TIME_OUT;
            }
            case 24: {
                return StatusCode.SHUFFLE_DATA_LOST;
            }
            case 25: {
                return StatusCode.WORKER_SHUTDOWN;
            }
            case 26: {
                return StatusCode.NO_AVAILABLE_WORKING_DIR;
            }
            case 27: {
                return StatusCode.WORKER_EXCLUDED;
            }
            case 28: {
                return StatusCode.WORKER_UNKNOWN;
            }
            case 30: {
                return StatusCode.PUSH_DATA_SUCCESS_PRIMARY_CONGESTED;
            }
            case 31: {
                return StatusCode.PUSH_DATA_SUCCESS_REPLICA_CONGESTED;
            }
            case 38: {
                return StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY;
            }
            case 39: {
                return StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_REPLICA;
            }
            case 40: {
                return StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_PRIMARY;
            }
            case 41: {
                return StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_REPLICA;
            }
            case 42: {
                return StatusCode.PUSH_DATA_TIMEOUT_PRIMARY;
            }
            case 43: {
                return StatusCode.PUSH_DATA_TIMEOUT_REPLICA;
            }
            case 44: {
                return StatusCode.PUSH_DATA_PRIMARY_WORKER_EXCLUDED;
            }
            case 45: {
                return StatusCode.PUSH_DATA_REPLICA_WORKER_EXCLUDED;
            }
            case 46: {
                return StatusCode.FETCH_DATA_TIMEOUT;
            }
            case 47: {
                return StatusCode.REVIVE_INITIALIZED;
            }
            case 48: {
                return StatusCode.DESTROY_SLOTS_MOCK_FAILURE;
            }
            case 49: {
                return StatusCode.COMMIT_FILES_MOCK_FAILURE;
            }
        }
        return null;
    }

    public PartitionSplitMode toShuffleSplitMode(int mode) {
        int n = mode;
        switch (n) {
            case 0: {
                return PartitionSplitMode.SOFT;
            }
            case 1: {
                return PartitionSplitMode.HARD;
            }
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(39).append("invalid shuffle mode ").append(mode).append(", fallback to soft").toString());
        return PartitionSplitMode.SOFT;
    }

    public PartitionType toPartitionType(int value) {
        int n = value;
        switch (n) {
            case 0: {
                return PartitionType.REDUCE;
            }
            case 1: {
                return PartitionType.MAP;
            }
            case 2: {
                return PartitionType.MAPGROUP;
            }
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(51).append("invalid partitionType ").append(value).append(", fallback to ReducePartition").toString());
        return PartitionType.REDUCE;
    }

    public DiskStatus toDiskStatus(int value) {
        int n = value;
        switch (n) {
            case 0: {
                return DiskStatus.HEALTHY;
            }
            case 1: {
                return DiskStatus.READ_OR_WRITE_FAILURE;
            }
            case 2: {
                return DiskStatus.IO_HANG;
            }
            case 3: {
                return DiskStatus.HIGH_DISK_USAGE;
            }
            case 4: {
                return DiskStatus.CRITICAL_ERROR;
            }
        }
        return null;
    }

    public String getPeerPath(String path) {
        if (path.endsWith("0")) {
            return new java.lang.StringBuilder(1).append(path.substring(0, path.length() - 1)).append("1").toString();
        }
        return new java.lang.StringBuilder(1).append(path.substring(0, path.length() - 1)).append("0").toString();
    }

    public String SORTED_SUFFIX() {
        return this.SORTED_SUFFIX;
    }

    public String INDEX_SUFFIX() {
        return this.INDEX_SUFFIX;
    }

    public String SUFFIX_HDFS_WRITE_SUCCESS() {
        return this.SUFFIX_HDFS_WRITE_SUCCESS;
    }

    public String COMPATIBLE_HDFS_REGEX() {
        return this.COMPATIBLE_HDFS_REGEX;
    }

    public int UNKNOWN_APP_SHUFFLE_ID() {
        return this.UNKNOWN_APP_SHUFFLE_ID;
    }

    public boolean isHdfsPath(String path) {
        return path.matches(this.COMPATIBLE_HDFS_REGEX());
    }

    public String getSortedFilePath(String path) {
        return new java.lang.StringBuilder(0).append(path).append(this.SORTED_SUFFIX()).toString();
    }

    public String getIndexFilePath(String path) {
        return new java.lang.StringBuilder(0).append(path).append(this.INDEX_SUFFIX()).toString();
    }

    public String getWriteSuccessFilePath(String path) {
        return new java.lang.StringBuilder(0).append(path).append(this.SUFFIX_HDFS_WRITE_SUCCESS()).toString();
    }

    public ByteString roaringBitmapToByteString(RoaringBitmap roaringBitMap) {
        if (roaringBitMap != null && !roaringBitMap.isEmpty()) {
            ByteBuffer buf = ByteBuffer.allocate(roaringBitMap.serializedSizeInBytes());
            roaringBitMap.serialize(buf);
            buf.rewind();
            return ByteString.copyFrom(buf);
        }
        return ByteString.EMPTY;
    }

    public RoaringBitmap byteStringToRoaringBitmap(ByteString bytes) {
        if (!bytes.isEmpty()) {
            RoaringBitmap roaringBitmap = new RoaringBitmap();
            ByteBuffer buf = bytes.asReadOnlyByteBuffer();
            buf.rewind();
            roaringBitmap.deserialize(buf);
            return roaringBitmap;
        }
        return null;
    }

    public int checkedDownCast(long value) {
        int downCast = (int)value;
        if ((long)downCast != value) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(39).append("Cannot downcast long value ").append(value).append(" to integer.").toString());
        }
        return downCast;
    }

    public void checkFileIntegrity(FileChannel fileChannel, int length) throws IOException {
        long remainingBytes = fileChannel.size() - fileChannel.position();
        if (remainingBytes < (long)length) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(59).append("File remaining bytes not not enough, remaining: ").append(remainingBytes).append(", wanted: ").append(length).append(".").toString());
            throw new RuntimeException(new java.lang.StringBuilder(18).append("File is corrupted ").append(fileChannel).toString());
        }
    }

    public String getShortFormattedFileName(FileInfo fileInfo) {
        String parentFile = fileInfo.getFile().getParent();
        return new java.lang.StringBuilder(1).append(parentFile.substring(parentFile.lastIndexOf("/"), parentFile.length())).append("/").append(fileInfo.getFile().getName()).toString();
    }

    public Tuple2<String, String> parseMetricLabels(String label) {
        String[] labelPart = label.split("=");
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])labelPart)).size() != 2) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(29).append("Illegal metric extra labels: ").append(label).toString());
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)labelPart[0].trim()), (Object)labelPart[1].trim());
    }

    public String getProcessId() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    private FastDateFormat dateFmt() {
        return this.dateFmt;
    }

    public String formatTimestamp(long timestamp) {
        return this.dateFmt().format(timestamp);
    }

    public static final /* synthetic */ boolean $anonfun$stringToSeq$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$2(InetAddress addr) {
        return addr.isLinkLocalAddress() || addr.isLoopbackAddress();
    }

    public static final /* synthetic */ boolean $anonfun$findLocalInetAddress$3(InetAddress x$4) {
        return x$4 instanceof Inet4Address;
    }

    public static final /* synthetic */ void $anonfun$findLocalInetAddress$1(InetAddress address$1, Object nonLocalReturnKey2$1, NetworkInterface ni) {
        Seq addresses = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(ni.getInetAddresses()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)addr -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findLocalInetAddress$2(addr))).toSeq();
        if (addresses.nonEmpty()) {
            InetAddress addr2 = (InetAddress)addresses.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$findLocalInetAddress$3(x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (InetAddress)addresses.head());
            InetAddress strippedAddress = InetAddress.getByAddress(addr2.getAddress());
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(80).append("Your hostname, ").append(InetAddress.getLocalHost().getHostName()).append(" resolves to").append(" a loopback address: ").append(address$1.getHostAddress()).append("; using ").append(strippedAddress.getHostAddress()).append(" instead (on interface ").append(ni.getName()).append(")").toString());
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Set CELEBORN_LOCAL_IP if you need to bind to another address");
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)strippedAddress);
        }
    }

    private final Tuple2 setDefaultPortValue$1(String hostPort$2) {
        Tuple2 retval = new Tuple2((Object)hostPort$2, (Object)BoxesRunTime.boxToInteger((int)0));
        this.hostPortParseResults().put(hostPort$2, (Tuple2<String, Object>)retval);
        return retval;
    }

    public static final /* synthetic */ boolean $anonfun$loadDefaultCelebornProperties$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return k.startsWith("celeborn.");
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$loadDefaultCelebornProperties$2(CelebornConf conf$2, String confFile) {
        ((IterableLike)MODULE$.getPropertiesFromFile(confFile).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$loadDefaultCelebornProperties$3(x0$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                conf$2.setIfMissing(k, v);
                return (String)scala.sys.package$.MODULE$.props().getOrElseUpdate((Object)k, (Function0 & Serializable & scala.Serializable)() -> v);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ boolean $anonfun$trimExceptCRLF$1(char ch) {
        return ch > ' ' || ch == '\r' || ch == '\n';
    }

    public static final /* synthetic */ boolean $anonfun$executeCommand$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private final void log$1(String s) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> s);
    }

    private static final void appendToOutput$1(String s, StringBuilder output$1) {
        output$1.append(s).append("\n");
    }

    private static final void countSlotsByDisk$1(List location, HashMap diskSlotsMap$1) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(location).asScala()).foreach((Function1 & Serializable & scala.Serializable)item -> {
            String mountPoint = item.getStorageInfo().getMountPoint();
            if (diskSlotsMap$1.containsKey(mountPoint)) {
                return diskSlotsMap$1.put(mountPoint, Predef$.MODULE$.int2Integer(1 + Predef$.MODULE$.Integer2int((Integer)diskSlotsMap$1.get(mountPoint))));
            }
            return diskSlotsMap$1.put(mountPoint, Predef$.MODULE$.int2Integer(1));
        });
    }

    private Utils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.siByteSizes = new long[]{0x1000000000000000L, 0x4000000000000L, 0x10000000000L, 0x40000000L, 0x100000L, 1024L, 1L};
        this.siByteSuffixes = (String[])((Object[])new String[]{"EiB", "PiB", "TiB", "GiB", "MiB", "KiB", "B"});
        this.isWindows = SystemUtils.IS_OS_WINDOWS;
        this.isMac = SystemUtils.IS_OS_MAC_OSX;
        this.isMacOnAppleSilicon = SystemUtils.IS_OS_MAC_OSX && SystemUtils.OS_ARCH.equals("aarch64");
        this.customHostname = scala.sys.package$.MODULE$.env().get((Object)"CELEBORN_LOCAL_HOSTNAME");
        this.hostPortParseResults = JavaUtils.newConcurrentHashMap();
        this.maxDefaultNettyThreads = 64;
        this.SORTED_SUFFIX = ".sorted";
        this.INDEX_SUFFIX = ".index";
        this.SUFFIX_HDFS_WRITE_SUCCESS = ".success";
        this.COMPATIBLE_HDFS_REGEX = "^[a-zA-Z0-9]+://.*";
        this.UNKNOWN_APP_SHUFFLE_ID = -1;
        this.dateFmt = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ROOT);
    }
}

