/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.metrics.sink;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.metrics.MetricsSystem$;
import org.apache.celeborn.common.metrics.sink.Sink;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001B\u000f\u001f\u0001-B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005q!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003D\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u001d\u0011\u0006A1A\u0005\u0002MCaA\u0017\u0001!\u0002\u0013!\u0006bB.\u0001\u0005\u0004%\ta\u0015\u0005\u00079\u0002\u0001\u000b\u0011\u0002+\t\u000fu\u0003!\u0019!C\u0001'\"1a\f\u0001Q\u0001\nQCqa\u0018\u0001C\u0002\u0013\u0005\u0001\r\u0003\u0004e\u0001\u0001\u0006I!\u0019\u0005\bK\u0002\u0011\r\u0011\"\u0001T\u0011\u00191\u0007\u0001)A\u0005)\"9q\r\u0001b\u0001\n\u0003\u0019\u0006B\u00025\u0001A\u0003%A\u000bC\u0004j\u0001\t\u0007I\u0011\u00011\t\r)\u0004\u0001\u0015!\u0003b\u0011\u001dY\u0007A1A\u0005\u00021Daa\u001d\u0001!\u0002\u0013i\u0007b\u0002;\u0001\u0005\u0004%\ta\u0015\u0005\u0007k\u0002\u0001\u000b\u0011\u0002+\t\u000fY\u0004!\u0019!C\u0001o\"11\u0010\u0001Q\u0001\naDQ\u0001 \u0001\u0005BuDa!a\u0001\u0001\t\u0003j\bBBA\u0003\u0001\u0011\u0005SPA\u0004DgZ\u001c\u0016N\\6\u000b\u0005}\u0001\u0013\u0001B:j].T!!\t\u0012\u0002\u000f5,GO]5dg*\u00111\u0005J\u0001\u0007G>lWn\u001c8\u000b\u0005\u00152\u0013\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001'\r\u0001AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M\"T\"\u0001\u0010\n\u0005Ur\"\u0001B*j].\f\u0001\u0002\u001d:pa\u0016\u0014H/_\u000b\u0002qA\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0005kRLGNC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}R$A\u0003)s_B,'\u000f^5fg\u0006I\u0001O]8qKJ$\u0018\u0010I\u0001\te\u0016<\u0017n\u001d;ssV\t1\t\u0005\u0002E\u00156\tQI\u0003\u0002\"\r*\u0011q\tS\u0001\tG>$\u0017\r[1mK*\t\u0011*A\u0002d_6L!aS#\u0003\u001d5+GO]5d%\u0016<\u0017n\u001d;ss\u0006I!/Z4jgR\u0014\u0018\u0010I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0003\u0016\u000b\u0005\u00024\u0001!)a'\u0002a\u0001q!)\u0011)\u0002a\u0001\u0007\u0006q1i\u0015,`\u0017\u0016Kv\fU#S\u0013>#U#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0005]c\u0014\u0001\u00027b]\u001eL!!\u0017,\u0003\rM#(/\u001b8h\u0003=\u00195KV0L\u000bf{\u0006+\u0012*J\u001f\u0012\u0003\u0013\u0001D\"T-~[U)W0V\u001d&#\u0016!D\"T-~[U)W0V\u001d&#\u0006%A\u0006D'Z{6*R-`\t&\u0013\u0016\u0001D\"T-~[U)W0E\u0013J\u0003\u0013AE\"T-~#UIR!V\u0019R{\u0006+\u0012*J\u001f\u0012+\u0012!\u0019\t\u0003[\tL!a\u0019\u0018\u0003\u0007%sG/A\nD'Z{F)\u0012$B+2#v\fU#S\u0013>#\u0005%\u0001\tD'Z{F)\u0012$B+2#v,\u0016(J)\u0006\t2i\u0015,`\t\u00163\u0015)\u0016'U?Vs\u0015\n\u0016\u0011\u0002\u001f\r\u001bfk\u0018#F\r\u0006+F\nV0E\u0013J\u000b\u0001cQ*W?\u0012+e)Q+M)~#\u0015J\u0015\u0011\u0002\u0015A|G\u000e\u001c)fe&|G-A\u0006q_2d\u0007+\u001a:j_\u0012\u0004\u0013\u0001\u00039pY2,f.\u001b;\u0016\u00035\u0004\"A\\9\u000e\u0003=T!\u0001\u001d\u001e\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002s_\nAA+[7f+:LG/A\u0005q_2dWK\\5uA\u00059\u0001o\u001c7m\t&\u0014\u0018\u0001\u00039pY2$\u0015N\u001d\u0011\u0002\u0011I,\u0007o\u001c:uKJ,\u0012\u0001\u001f\t\u0003\tfL!A_#\u0003\u0017\r\u001bhOU3q_J$XM]\u0001\ne\u0016\u0004xN\u001d;fe\u0002\nQa\u001d;beR$\u0012A \t\u0003[}L1!!\u0001/\u0005\u0011)f.\u001b;\u0002\tM$x\u000e]\u0001\u0007e\u0016\u0004xN\u001d;")
public class CsvSink
implements Sink {
    private final Properties property;
    private final MetricRegistry registry;
    private final String CSV_KEY_PERIOD;
    private final String CSV_KEY_UNIT;
    private final String CSV_KEY_DIR;
    private final int CSV_DEFAULT_PERIOD;
    private final String CSV_DEFAULT_UNIT;
    private final String CSV_DEFAULT_DIR;
    private final int pollPeriod;
    private final TimeUnit pollUnit;
    private final String pollDir;
    private final CsvReporter reporter;

    public Properties property() {
        return this.property;
    }

    public MetricRegistry registry() {
        return this.registry;
    }

    public String CSV_KEY_PERIOD() {
        return this.CSV_KEY_PERIOD;
    }

    public String CSV_KEY_UNIT() {
        return this.CSV_KEY_UNIT;
    }

    public String CSV_KEY_DIR() {
        return this.CSV_KEY_DIR;
    }

    public int CSV_DEFAULT_PERIOD() {
        return this.CSV_DEFAULT_PERIOD;
    }

    public String CSV_DEFAULT_UNIT() {
        return this.CSV_DEFAULT_UNIT;
    }

    public String CSV_DEFAULT_DIR() {
        return this.CSV_DEFAULT_DIR;
    }

    public int pollPeriod() {
        return this.pollPeriod;
    }

    public TimeUnit pollUnit() {
        return this.pollUnit;
    }

    public String pollDir() {
        return this.pollDir;
    }

    public CsvReporter reporter() {
        return this.reporter;
    }

    @Override
    public void start() {
        this.reporter().start((long)this.pollPeriod(), this.pollUnit());
    }

    @Override
    public void stop() {
        this.reporter().stop();
    }

    @Override
    public void report() {
        this.reporter().report();
    }

    public CsvSink(Properties property, MetricRegistry registry) {
        String string;
        TimeUnit timeUnit;
        int n;
        this.property = property;
        this.registry = registry;
        this.CSV_KEY_PERIOD = "period";
        this.CSV_KEY_UNIT = "unit";
        this.CSV_KEY_DIR = "directory";
        this.CSV_DEFAULT_PERIOD = 10;
        this.CSV_DEFAULT_UNIT = "SECONDS";
        this.CSV_DEFAULT_DIR = "/tmp/";
        Option<String> option = Option$.MODULE$.apply(property.getProperty(this.CSV_KEY_PERIOD()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            n = new StringOps(Predef$.MODULE$.augmentString(s)).toInt();
        } else if (None$.MODULE$.equals(option)) {
            n = this.CSV_DEFAULT_PERIOD();
        } else {
            throw new MatchError(option);
        }
        this.pollPeriod = n;
        Option<String> option2 = Option$.MODULE$.apply(property.getProperty(this.CSV_KEY_UNIT()));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String s = (String)some.value();
            timeUnit = TimeUnit.valueOf(s.toUpperCase(Locale.ROOT));
        } else if (None$.MODULE$.equals(option2)) {
            timeUnit = TimeUnit.valueOf(this.CSV_DEFAULT_UNIT());
        } else {
            throw new MatchError(option2);
        }
        this.pollUnit = timeUnit;
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(this.pollUnit(), this.pollPeriod());
        Option<String> option3 = Option$.MODULE$.apply(property.getProperty(this.CSV_KEY_DIR()));
        if (option3 instanceof Some) {
            String s;
            Some some = (Some)option3;
            string = s = (String)some.value();
        } else if (None$.MODULE$.equals(option3)) {
            string = this.CSV_DEFAULT_DIR();
        } else {
            throw new MatchError(option3);
        }
        this.pollDir = string;
        this.reporter = CsvReporter.forRegistry((MetricRegistry)registry).formatFor(Locale.US).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).build(new File(this.pollDir()));
    }
}

