/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.network.TransportContext;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.server.TransportServer;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.RpcNameConstants;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.RpcEndpointAddress;
import org.apache.celeborn.common.rpc.RpcEndpointNotFoundException;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.RpcEnv;
import org.apache.celeborn.common.rpc.RpcEnvConfig;
import org.apache.celeborn.common.rpc.RpcEnvStoppedException;
import org.apache.celeborn.common.rpc.RpcTimeout;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv$;
import org.apache.celeborn.common.rpc.netty.NettyRpcHandler;
import org.apache.celeborn.common.rpc.netty.OneWayOutboxMessage;
import org.apache.celeborn.common.rpc.netty.Outbox;
import org.apache.celeborn.common.rpc.netty.OutboxMessage;
import org.apache.celeborn.common.rpc.netty.RequestMessage;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier;
import org.apache.celeborn.common.rpc.netty.RpcEndpointVerifier$;
import org.apache.celeborn.common.rpc.netty.RpcFailure;
import org.apache.celeborn.common.rpc.netty.RpcOutboxMessage;
import org.apache.celeborn.common.serializer.JavaSerializerInstance;
import org.apache.celeborn.common.serializer.SerializationStream;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rea\u0001B\u001c9\u0001\u0015C\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\t!\u0015\u0005\t+\u0002\u0011\t\u0011)A\u0005%\"Aa\u000b\u0001B\u0001B\u0003%q\u000bC\u0003^\u0001\u0011\u0005a\fC\u0004d\u0001\t\u0007I\u0011\u00013\t\r%\u0004\u0001\u0015!\u0003f\u0011!Q\u0007A1A\u0005\u0002yZ\u0007B\u0002;\u0001A\u0003%A\u000eC\u0004v\u0001\t\u0007I\u0011\u0002<\t\ri\u0004\u0001\u0015!\u0003x\u0011\u001dY\b\u00011A\u0005\nqD\u0011\"!\u0001\u0001\u0001\u0004%I!a\u0001\t\u000f\u0005U\u0001\u0001)Q\u0005{\"I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0004\u0005\t\u0003G\u0001\u0001\u0015!\u0003\u0002\u001c!I\u0011Q\u0005\u0001C\u0002\u0013\u0005\u0011q\u0005\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002*!I\u0011q\u0007\u0001C\u0002\u0013%\u0011\u0011\b\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002<!Q\u0011q\n\u0001C\u0002\u0013\u0005a(!\u0015\t\u0011\u0005e\u0003\u0001)A\u0005\u0003'B1\"a\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002^!Y\u0011\u0011\u000e\u0001A\u0002\u0003\u0007I\u0011BA6\u0011-\ty\u0007\u0001a\u0001\u0002\u0003\u0006K!a\u0018\t\u0013\u0005e\u0004A1A\u0005\n\u0005m\u0004\u0002CAE\u0001\u0001\u0006I!! \t\u0013\u0005-\u0005A1A\u0005\n\u00055\u0005\u0002CAQ\u0001\u0001\u0006I!a$\t\u0011\u0005\r\u0006\u0001\"\u0001?\u0003KCq!a+\u0001\t\u0003\ti\u000b\u0003\u0006\u0002*\u0002A)\u0019!C!\u0003'Dq!a:\u0001\t\u0003\nI\u000fC\u0004\u0002z\u0002!\t!a?\t\u000f\t\r\u0001\u0001\"\u0001\u0003\u0006!9!1\u0004\u0001\u0005B\tu\u0001b\u0002B\u0012\u0001\u0011%!Q\u0005\u0005\t\u0005w\u0001A\u0011\u0001 \u0003>!A!q\t\u0001\u0005\u0002y\u0012I\u0005\u0003\u0005\u0003T\u0001!\tA\u0010B+\u0011!\u0011y\t\u0001C\u0001}\tE\u0005\u0002\u0003BR\u0001\u0011\u0005aH!*\t\u0011\tu\u0006\u0001\"\u0001?\u0005\u007fCqA!\t\u0001\t\u0003\u0012)\u000eC\u0004\u0003Z\u0002!\tEa7\t\u000f\tu\u0007\u0001\"\u0011\u0003\\\"9!q\u001c\u0001\u0005\n\tm\u0007b\u0002B_\u0001\u0011\u0005#\u0011]\u0004\t\u0005gD\u0004\u0012\u0001 \u0003v\u001a9q\u0007\u000fE\u0001}\t]\bBB/2\t\u0003\u0011y\u0010\u0003\u0006\u0004\u0002E\u0012\r\u0011\"\u0001?\u0007\u0007A\u0001ba\u00042A\u0003%1Q\u0001\u0005\u000b\u0007#\t$\u0019!C\u0001}\rM\u0001\u0002CB\fc\u0001\u0006Ia!\u0006\u0003\u00179+G\u000f^=Sa\u000e,eN\u001e\u0006\u0003si\nQA\\3uifT!a\u000f\u001f\u0002\u0007I\u00048M\u0003\u0002>}\u000511m\\7n_:T!a\u0010!\u0002\u0011\r,G.\u001a2pe:T!!\u0011\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0015aA8sO\u000e\u00011c\u0001\u0001G\u0015B\u0011q\tS\u0007\u0002u%\u0011\u0011J\u000f\u0002\u0007%B\u001cWI\u001c<\u0011\u0005-sU\"\u0001'\u000b\u00055c\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005=c%a\u0002'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0016\u0003I\u0003\"aR*\n\u0005QS$\u0001\u0004*qG\u0016sgoQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0017U\u00064\u0018mU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dKB\u0011\u0001lW\u0007\u00023*\u0011!\fP\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018B\u0001/Z\u0005YQ\u0015M^1TKJL\u0017\r\\5{KJLen\u001d;b]\u000e,\u0017A\u0002\u001fj]&$h\bF\u0002`C\n\u0004\"\u0001\u0019\u0001\u000e\u0003aBQ\u0001\u0015\u0003A\u0002ICQA\u0016\u0003A\u0002]\u000bAbY3mK\n|'O\\\"p]\u001a,\u0012!\u001a\t\u0003M\u001el\u0011\u0001P\u0005\u0003Qr\u0012AbQ3mK\n|'O\\\"p]\u001a\fQbY3mK\n|'O\\\"p]\u001a\u0004\u0013!\u0004;sC:\u001c\bo\u001c:u\u0007>tg-F\u0001m!\ti'/D\u0001o\u0015\ty\u0007/\u0001\u0003vi&d'BA9=\u0003\u001dqW\r^<pe.L!a\u001d8\u0003\u001bQ\u0013\u0018M\\:q_J$8i\u001c8g\u00039!(/\u00198ta>\u0014HoQ8oM\u0002\n!\u0002Z5ta\u0006$8\r[3s+\u00059\bC\u00011y\u0013\tI\bH\u0001\u0006ESN\u0004\u0018\r^2iKJ\f1\u0002Z5ta\u0006$8\r[3sA\u00051qo\u001c:lKJ,\u0012! \t\u0003\u000fzL!a \u001e\u0003\u0017I\u00038-\u00128ea>Lg\u000e^\u0001\u000bo>\u00148.\u001a:`I\u0015\fH\u0003BA\u0003\u0003#\u0001B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0003\u0003\u0017\tQa]2bY\u0006LA!a\u0004\u0002\n\t!QK\\5u\u0011!\t\u0019\u0002DA\u0001\u0002\u0004i\u0018a\u0001=%c\u00059qo\u001c:lKJ\u0004\u0013\u0001\u0005;sC:\u001c\bo\u001c:u\u0007>tG/\u001a=u+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005}Q\"\u00019\n\u0007\u0005\u0005\u0002O\u0001\tUe\u0006t7\u000f]8si\u000e{g\u000e^3yi\u0006\tBO]1ogB|'\u000f^\"p]R,\u0007\u0010\u001e\u0011\u0002\u001b\rd\u0017.\u001a8u\r\u0006\u001cGo\u001c:z+\t\tI\u0003\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\ty\u0003]\u0001\u0007G2LWM\u001c;\n\t\u0005M\u0012Q\u0006\u0002\u0017)J\fgn\u001d9peR\u001cE.[3oi\u001a\u000b7\r^8ss\u0006q1\r\\5f]R4\u0015m\u0019;pef\u0004\u0013\u0001\u0005;j[\u0016|W\u000f^*dQ\u0016$W\u000f\\3s+\t\tY\u0004\u0005\u0003\u0002>\u0005%SBAA \u0015\u0011\t\t%a\u0011\u0002\u0015\r|gnY;se\u0016tGOC\u0002p\u0003\u000bR!!a\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\nyD\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\f\u0011\u0003^5nK>,HoU2iK\u0012,H.\u001a:!\u0003a\u0019G.[3oi\u000e{gN\\3di&|g.\u0012=fGV$xN]\u000b\u0003\u0003'\u0002B!!\u0010\u0002V%!\u0011qKA \u0005I!\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\u00023\rd\u0017.\u001a8u\u0007>tg.Z2uS>tW\t_3dkR|'\u000fI\u0001\u0007g\u0016\u0014h/\u001a:\u0016\u0005\u0005}\u0003\u0003BA1\u0003Kj!!a\u0019\u000b\u0007\u0005m\u0003/\u0003\u0003\u0002h\u0005\r$a\u0004+sC:\u001c\bo\u001c:u'\u0016\u0014h/\u001a:\u0002\u0015M,'O^3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u00055\u0004\"CA\n/\u0005\u0005\t\u0019AA0\u0003\u001d\u0019XM\u001d<fe\u0002B3\u0001GA:!\u0011\t9!!\u001e\n\t\u0005]\u0014\u0011\u0002\u0002\tm>d\u0017\r^5mK\u000691\u000f^8qa\u0016$WCAA?!\u0011\ty(!\"\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u007f\ta!\u0019;p[&\u001c\u0017\u0002BAD\u0003\u0003\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001C:u_B\u0004X\r\u001a\u0011\u0002\u0011=,HOY8yKN,\"!a$\u0011\u0011\u0005u\u0012\u0011SAK\u00037KA!a%\u0002@\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0007\u001d\u000b9*C\u0002\u0002\u001aj\u0012!B\u00159d\u0003\u0012$'/Z:t!\r\u0001\u0017QT\u0005\u0004\u0003?C$AB(vi\n|\u00070A\u0005pkR\u0014w\u000e_3tA\u0005a!/Z7pm\u0016|U\u000f\u001e2pqR!\u0011QAAT\u0011\u001d\tI+\ba\u0001\u0003+\u000bq!\u00193ee\u0016\u001c8/A\u0006ti\u0006\u0014HoU3sm\u0016\u0014HCBA\u0003\u0003_\u000bI\rC\u0004\u00022z\u0001\r!a-\u0002\u0017\tLg\u000eZ!eIJ,7o\u001d\t\u0005\u0003k\u000b\u0019M\u0004\u0003\u00028\u0006}\u0006\u0003BA]\u0003\u0013i!!a/\u000b\u0007\u0005uF)\u0001\u0004=e>|GOP\u0005\u0005\u0003\u0003\fI!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\f9M\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003\u0003\fI\u0001C\u0004\u0002Lz\u0001\r!!4\u0002\tA|'\u000f\u001e\t\u0005\u0003\u000f\ty-\u0003\u0003\u0002R\u0006%!aA%oiV\u0011\u0011Q\u0013\u0015\u0004?\u0005]\u0007\u0003BAm\u0003Gl!!a7\u000b\t\u0005u\u0017q\\\u0001\u000bC:tw\u000e^1uS>t'BAAq\u0003\u0015Q\u0017M^1y\u0013\u0011\t)/a7\u0003\u00119+H\u000e\\1cY\u0016\fQb]3ukB,e\u000e\u001a9pS:$HCBAv\u0003c\f)\u0010E\u0002H\u0003[L1!a<;\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001aDq!a=!\u0001\u0004\t\u0019,\u0001\u0003oC6,\u0007BBA|A\u0001\u0007Q0\u0001\u0005f]\u0012\u0004x.\u001b8u\u0003=\u0019\u0007.Z2l%\u0016<\u0017n\u001d;fe\u0016$GCAA\u007f!\u0011\t9!a@\n\t\t\u0005\u0011\u0011\u0002\u0002\b\u0005>|G.Z1o\u0003m\t7/\u001f8d'\u0016$X\u000f]#oIB|\u0017N\u001c;SK\u001a\u0014\u00150\u00113eeR!!q\u0001B\t!\u0019\u0011IA!\u0004\u0002l6\u0011!1\u0002\u0006\u0005\u0003\u0003\nI!\u0003\u0003\u0003\u0010\t-!A\u0002$viV\u0014X\rC\u0004\u0003\u0014\t\u0002\rA!\u0006\u0002\t\u0005$GM\u001d\t\u0004\u000f\n]\u0011b\u0001B\ru\t\u0011\"\u000b]2F]\u0012\u0004x.\u001b8u\u0003\u0012$'/Z:t\u0003\u0011\u0019Ho\u001c9\u0015\t\u0005\u0015!q\u0004\u0005\b\u0005C\u0019\u0003\u0019AAv\u0003-)g\u000e\u001a9pS:$(+\u001a4\u0002\u0019A|7\u000f\u001e+p\u001fV$(m\u001c=\u0015\r\u0005\u0015!q\u0005B\u0019\u0011\u001d\u0011I\u0003\na\u0001\u0005W\t\u0001B]3dK&4XM\u001d\t\u0004A\n5\u0012b\u0001B\u0018q\t\u0019b*\u001a;usJ\u00038-\u00128ea>Lg\u000e\u001e*fM\"9!1\u0007\u0013A\u0002\tU\u0012aB7fgN\fw-\u001a\t\u0004A\n]\u0012b\u0001B\u001dq\tiq*\u001e;c_blUm]:bO\u0016\fAa]3oIR!\u0011Q\u0001B \u0011\u001d\u0011\u0019$\na\u0001\u0005\u0003\u00022\u0001\u0019B\"\u0013\r\u0011)\u0005\u000f\u0002\u000f%\u0016\fX/Z:u\u001b\u0016\u001c8/Y4f\u00031\u0019'/Z1uK\u000ec\u0017.\u001a8u)\u0011\u0011YE!\u0015\u0011\t\u0005-\"QJ\u0005\u0005\u0005\u001f\niCA\bUe\u0006t7\u000f]8si\u000ec\u0017.\u001a8u\u0011\u001d\tIK\na\u0001\u0003+\u000b1!Y:l+\u0011\u00119F!\u0019\u0015\r\te#1\u0011BC)\u0011\u0011YFa\u001d\u0011\r\t%!Q\u0002B/!\u0011\u0011yF!\u0019\r\u0001\u00119!1M\u0014C\u0002\t\u0015$!\u0001+\u0012\t\t\u001d$Q\u000e\t\u0005\u0003\u000f\u0011I'\u0003\u0003\u0003l\u0005%!a\u0002(pi\"Lgn\u001a\t\u0005\u0003\u000f\u0011y'\u0003\u0003\u0003r\u0005%!aA!os\"I!QO\u0014\u0002\u0002\u0003\u000f!qO\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004C\u0002B=\u0005\u007f\u0012i&\u0004\u0002\u0003|)!!QPA\u0005\u0003\u001d\u0011XM\u001a7fGRLAA!!\u0003|\tA1\t\\1tgR\u000bw\rC\u0004\u00034\u001d\u0002\rA!\u0011\t\u000f\t\u001du\u00051\u0001\u0003\n\u00069A/[7f_V$\bcA$\u0003\f&\u0019!Q\u0012\u001e\u0003\u0015I\u00038\rV5nK>,H/A\u0005tKJL\u0017\r\\5{KR!!1\u0013BP!\u0011\u0011)Ja'\u000e\u0005\t]%\u0002\u0002BM\u0003\u000b\n1A\\5p\u0013\u0011\u0011iJa&\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0004\u0003\"\"\u0002\rA!\u001c\u0002\u000f\r|g\u000e^3oi\u0006y1/\u001a:jC2L'0Z*ue\u0016\fW\u000e\u0006\u0003\u0003(\n5\u0006c\u0001-\u0003*&\u0019!1V-\u0003'M+'/[1mSj\fG/[8o'R\u0014X-Y7\t\u000f\t=\u0016\u00061\u0001\u00032\u0006\u0019q.\u001e;\u0011\t\tM&\u0011X\u0007\u0003\u0005kSAAa.\u0002F\u0005\u0011\u0011n\\\u0005\u0005\u0005w\u0013)L\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.A\u0006eKN,'/[1mSj,W\u0003\u0002Ba\u0005\u000f$bAa1\u0003P\nEG\u0003\u0002Bc\u0005\u0013\u0004BAa\u0018\u0003H\u00129!1\r\u0016C\u0002\t\u0015\u0004\"\u0003BfU\u0005\u0005\t9\u0001Bg\u0003))g/\u001b3f]\u000e,GE\r\t\u0007\u0005s\u0012yH!2\t\u000f\u0005=\"\u00061\u0001\u0003L!9!1\u001b\u0016A\u0002\tM\u0015!\u00022zi\u0016\u001cH\u0003BAv\u0005/Da!a>,\u0001\u0004i\u0018\u0001C:ikR$wn\u001e8\u0015\u0005\u0005\u0015\u0011\u0001E1xC&$H+\u001a:nS:\fG/[8o\u0003\u001d\u0019G.Z1okB,BAa9\u0003hR!!Q\u001dBu!\u0011\u0011yFa:\u0005\u000f\t\rtF1\u0001\u0003f!9!1^\u0018A\u0002\t5\u0018!\u00063fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8BGRLwN\u001c\t\u0007\u0003\u000f\u0011yO!:\n\t\tE\u0018\u0011\u0002\u0002\n\rVt7\r^5p]B\n1BT3uif\u0014\u0006oY#omB\u0011\u0001-M\n\u0005c\te(\n\u0005\u0003\u0002\b\tm\u0018\u0002\u0002B\u007f\u0003\u0013\u0011a!\u00118z%\u00164GC\u0001B{\u0003)\u0019WO\u001d:f]R,eN^\u000b\u0003\u0007\u000b\u0001Raa\u0002\u0004\f}k!a!\u0003\u000b\u0007=\fI!\u0003\u0003\u0004\u000e\r%!a\u0004#z]\u0006l\u0017n\u0019,be&\f'\r\\3\u0002\u0017\r,(O]3oi\u0016sg\u000fI\u0001\u000eGV\u0014(/\u001a8u\u00072LWM\u001c;\u0016\u0005\rU\u0001CBB\u0004\u0007\u0017\u0011Y%\u0001\bdkJ\u0014XM\u001c;DY&,g\u000e\u001e\u0011")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    @Nullable
    private RpcAddress address;
    private final RpcEnvConfig config;
    private final JavaSerializerInstance javaSerializerInstance;
    private final CelebornConf celebornConf;
    private final TransportConf transportConf;
    private final Dispatcher dispatcher;
    private RpcEndpoint worker;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    private transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public RpcEnvConfig config() {
        return this.config;
    }

    public CelebornConf celebornConf() {
        return this.celebornConf;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private RpcEndpoint worker() {
        return this.worker;
    }

    private void worker_$eq(RpcEndpoint x$1) {
        this.worker = x$1;
    }

    private TransportContext transportContext() {
        return this.transportContext;
    }

    public TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    private ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address) {
        block0: {
            Outbox outbox = this.outboxes().remove(address);
            if (outbox == null) break block0;
            outbox.stop();
        }
    }

    public void startServer(String bindAddress, int port) {
        this.server_$eq(this.transportContext().createServer(bindAddress, port));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() != null ? new RpcAddress(this.config().advertiseAddress(), this.server().getPort()) : null;
                this.bitmap$0 = true;
            }
        }
        return this.address;
    }

    @Override
    public RpcAddress address() {
        return !this.bitmap$0 ? this.address$lzycompute() : this.address;
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name, RpcEndpoint endpoint) {
        block0: {
            String string = name;
            String string2 = RpcNameConstants.WORKER_EP;
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            this.worker_$eq(endpoint);
        }
        return this.dispatcher().registerRpcEndpoint(name, endpoint);
    }

    public boolean checkRegistered() {
        return this.worker() == null ? true : this.worker().checkRegistered();
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByAddr(RpcEndpointAddress addr) {
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.celebornConf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(addr.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1<Object, Future> & Serializable & scala.Serializable)find -> NettyRpcEnv.$anonfun$asyncSetupEndpointRefByAddr$1(this, addr, BoxesRunTime.unboxToBoolean(find)), ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        if (receiver.client() != null && receiver.client().isActive()) {
            message.sendWith(receiver.client());
        } else {
            Outbox targetOutbox;
            Outbox outbox;
            Predef$.MODULE$.require(receiver.address() != null, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Cannot send message to client endpoint with no listen address.");
            Outbox outbox2 = this.outboxes().get(receiver.address());
            if (outbox2 == null) {
                Outbox newOutbox = new Outbox(this, receiver.address());
                Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
                outbox = oldOutbox == null ? newOutbox : oldOutbox;
            } else {
                outbox = targetOutbox = outbox2;
            }
            if (this.stopped().get()) {
                this.outboxes().remove(receiver.address());
                targetOutbox.stop();
            } else {
                targetOutbox.send(message);
            }
        }
    }

    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            try {
                this.dispatcher().postOneWayMessage(message);
            }
            catch (RpcEnvStoppedException e) {
                this.logDebug((Function0<String> & Serializable & scala.Serializable)() -> e.getMessage());
            }
        } else {
            this.postToOutbox(message.receiver(), new OneWayOutboxMessage(message.serialize(this)));
        }
    }

    public TransportClient createClient(RpcAddress address) {
        return this.clientFactory().createClient(address.host(), address.port());
    }

    public <T> Future<T> ask(RequestMessage message, RpcTimeout timeout, ClassTag<T> evidence$1) {
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress remoteAddr = message.receiver().address();
        try {
            RpcAddress rpcAddress = remoteAddr;
            RpcAddress rpcAddress2 = this.address();
            if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
                Promise<Object> p = Promise$.MODULE$.apply();
                p.future().onComplete((Function1<Try, Object> & Serializable & scala.Serializable)x0$1 -> {
                    NettyRpcEnv.$anonfun$ask$4(this, promise, x0$1);
                    return BoxedUnit.UNIT;
                }, ThreadUtils$.MODULE$.sameThread());
                this.dispatcher().postLocalMessage(message, p);
            } else {
                RpcOutboxMessage rpcMessage = new RpcOutboxMessage(message.serialize(this), (Function1<Throwable, BoxedUnit>)(Function1<Throwable, Object> & Serializable & scala.Serializable)e -> {
                    this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise);
                    return BoxedUnit.UNIT;
                }, (Function2<TransportClient, ByteBuffer, BoxedUnit>)(Function2<TransportClient, ByteBuffer, Object> & Serializable & scala.Serializable)(client, response) -> {
                    this.onSuccess$1(this.deserialize(client, response, ClassTag$.MODULE$.Any()), promise);
                    return BoxedUnit.UNIT;
                });
                this.postToOutbox(message.receiver(), rpcMessage);
                promise.future().failed().foreach((Function1<Throwable, Object> & Serializable & scala.Serializable)x0$2 -> {
                    NettyRpcEnv.$anonfun$ask$7(rpcMessage, x0$2);
                    return BoxedUnit.UNIT;
                }, ThreadUtils$.MODULE$.sameThread());
            }
            ScheduledFuture<?> timeoutCancelable = this.timeoutScheduler().schedule(new Runnable(this, remoteAddr, timeout, promise){
                private final /* synthetic */ NettyRpcEnv $outer;
                private final RpcAddress remoteAddr$1;
                private final RpcTimeout timeout$1;
                private final Promise promise$1;

                public void run() {
                    this.$outer.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(new TimeoutException(new StringBuilder(34).append("Cannot receive any reply from ").append(this.remoteAddr$1).append(" ").append("in ").append(this.timeout$1.duration()).toString()), this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.remoteAddr$1 = remoteAddr$1;
                    this.timeout$1 = timeout$1;
                    this.promise$1 = promise$1;
                }
            }, timeout.duration().toNanos(), TimeUnit.NANOSECONDS);
            promise.future().onComplete((Function1<Try, Object> & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean(timeoutCancelable.cancel(true)), ThreadUtils$.MODULE$.sameThread());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e2 = option.get();
                this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e2, promise);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        return promise.future().mapTo(evidence$1).recover(timeout.addMessageIfTimeout(), ThreadUtils$.MODULE$.sameThread());
    }

    public ByteBuffer serialize(Object content) {
        return this.javaSerializerInstance.serialize(content, ClassTag$.MODULE$.Any());
    }

    public SerializationStream serializeStream(OutputStream out) {
        return this.javaSerializerInstance.serializeStream(out);
    }

    public <T> T deserialize(TransportClient client, ByteBuffer bytes, ClassTag<T> evidence$2) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue(client, (Function0<Object> & Serializable & scala.Serializable)() -> this.deserialize((Function0<Object> & Serializable & scala.Serializable)() -> $this.javaSerializerInstance.deserialize(bytes, evidence$2)));
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        block5: {
            if (!this.stopped().compareAndSet(false, true)) {
                return;
            }
            for (Outbox outbox : this.outboxes().values()) {
                this.outboxes().remove(outbox.address());
                outbox.stop();
            }
            Object object = this.timeoutScheduler() != null ? this.timeoutScheduler().shutdownNow() : BoxedUnit.UNIT;
            if (this.dispatcher() != null) {
                this.dispatcher().stop();
            }
            if (this.server() != null) {
                this.server().close();
            }
            if (this.clientFactory() != null) {
                this.clientFactory().close();
            }
            if (this.clientConnectionExecutor() == null) break block5;
            this.clientConnectionExecutor().shutdownNow();
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return NettyRpcEnv$.MODULE$.currentEnv().withValue(this, deserializationAction);
    }

    public static final /* synthetic */ Future $anonfun$asyncSetupEndpointRefByAddr$1(NettyRpcEnv $this, RpcEndpointAddress addr$1, boolean find) {
        return find ? Future$.MODULE$.successful(new NettyRpcEndpointRef($this.celebornConf(), addr$1, $this)) : Future$.MODULE$.failed(new RpcEndpointNotFoundException(addr$1.toString()));
    }

    public final void org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(Throwable e, Promise promise$1) {
        block2: {
            if (promise$1.tryFailure(e)) break block2;
            Throwable throwable = e;
            if (throwable instanceof RpcEnvStoppedException) {
                RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)throwable;
                this.logDebug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored failure: ").append(rpcEnvStoppedException).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored failure: ").append(e).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private final void onSuccess$1(Object reply, Promise promise$1) {
        Object object = reply;
        if (object instanceof RpcFailure) {
            RpcFailure rpcFailure = (RpcFailure)object;
            Throwable e = rpcFailure.e();
            this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (!promise$1.trySuccess(object)) {
                this.logWarning((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Ignored message: ").append(reply).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$ask$4(NettyRpcEnv $this, Promise promise$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object response = success.value();
            $this.onSuccess$1(response, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            $this.org$apache$celeborn$common$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    public static final /* synthetic */ void $anonfun$ask$7(RpcOutboxMessage rpcMessage$1, Throwable x0$2) {
        Throwable throwable = x0$2;
        if (throwable instanceof TimeoutException) {
            rpcMessage$1.onTimeout();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public NettyRpcEnv(RpcEnvConfig config, JavaSerializerInstance javaSerializerInstance) {
        this.config = config;
        this.javaSerializerInstance = javaSerializerInstance;
        super(config);
        Logging.$init$(this);
        this.celebornConf = config.conf();
        this.transportConf = Utils$.MODULE$.fromCelebornConf(this.celebornConf().clone(), "rpc", BoxesRunTime.unboxToInt(this.celebornConf().rpcIoThreads().getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> this.config().numUsableCores())));
        this.dispatcher = new Dispatcher(this);
        this.worker = null;
        this.transportContext = new TransportContext(this.transportConf(), new NettyRpcHandler(this.dispatcher(), this));
        this.clientFactory = this.transportContext().createClientFactory();
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("celeborn-netty-rpc-env-timeout-checker");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("celeborn-netty-rpc-connection-executor", this.celebornConf().rpcConnectThreads(), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.stopped = new AtomicBoolean(false);
        this.outboxes = JavaUtils.newConcurrentHashMap();
    }
}

