/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.util.DiskUtils;
import org.apache.commons.lang3.StringUtils;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Double;
import scala.Option;
import scala.Tuple2;

public class SlotsAllocator {
    private static final Logger logger = LoggerFactory.getLogger(SlotsAllocator.class);
    private static final Random rand = new Random();
    private static boolean initialized = false;
    private static double[] taskAllocationRatio = null;

    public static Map<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>> offerSlotsRoundRobin(List<WorkerInfo> workers, List<Integer> partitionIds, boolean shouldReplicate, boolean shouldRackAware, int availableStorageTypes) {
        if (partitionIds.isEmpty()) {
            return new HashMap<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>>();
        }
        if (workers.size() < 2 && shouldReplicate) {
            return new HashMap<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>>();
        }
        HashMap<WorkerInfo, List<UsableDiskInfo>> slotsRestrictions = new HashMap<WorkerInfo, List<UsableDiskInfo>>();
        for (WorkerInfo worker : workers) {
            List usableDisks = slotsRestrictions.computeIfAbsent(worker, v -> new ArrayList());
            for (Map.Entry diskInfoEntry : worker.diskInfos().entrySet()) {
                if (!((DiskInfo)diskInfoEntry.getValue()).status().equals((Object)DiskStatus.HEALTHY)) continue;
                if (StorageInfo.localDiskAvailable((int)availableStorageTypes) && ((DiskInfo)diskInfoEntry.getValue()).storageType() != StorageInfo.Type.HDFS) {
                    usableDisks.add(new UsableDiskInfo((DiskInfo)diskInfoEntry.getValue(), ((DiskInfo)diskInfoEntry.getValue()).availableSlots()));
                    continue;
                }
                if (!StorageInfo.HDFSAvailable((int)availableStorageTypes) || ((DiskInfo)diskInfoEntry.getValue()).storageType() != StorageInfo.Type.HDFS) continue;
                usableDisks.add(new UsableDiskInfo((DiskInfo)diskInfoEntry.getValue(), ((DiskInfo)diskInfoEntry.getValue()).availableSlots()));
            }
        }
        return SlotsAllocator.locateSlots(partitionIds, workers, slotsRestrictions, shouldReplicate, shouldRackAware, availableStorageTypes);
    }

    /*
     * Unable to fully structure code
     */
    public static Map<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>> offerSlotsLoadAware(List<WorkerInfo> workers, List<Integer> partitionIds, boolean shouldReplicate, boolean shouldRackAware, long diskReserveSize, Option<Double> diskReserveRatio, int diskGroupCount, double diskGroupGradient, double flushTimeWeight, double fetchTimeWeight, int availableStorageTypes) {
        if (partitionIds.isEmpty()) {
            return new HashMap<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>>();
        }
        if (workers.size() < 2 && shouldReplicate) {
            return new HashMap<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>>();
        }
        if (StorageInfo.HDFSOnly((int)availableStorageTypes)) {
            return SlotsAllocator.offerSlotsRoundRobin(workers, partitionIds, shouldReplicate, shouldRackAware, availableStorageTypes);
        }
        usableDisks = new ArrayList<DiskInfo>();
        diskToWorkerMap = new HashMap<DiskInfo, WorkerInfo>();
        workers.forEach((Consumer<WorkerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$offerSlotsLoadAware$2(java.util.Map long scala.Option java.util.List org.apache.celeborn.common.meta.WorkerInfo ), (Lorg/apache/celeborn/common/meta/WorkerInfo;)V)(diskToWorkerMap, (long)diskReserveSize, diskReserveRatio, usableDisks));
        if (usableDisks.isEmpty()) ** GOTO lbl-1000
        if (!shouldReplicate) ** GOTO lbl-1000
        if (usableDisks.size() == 1) ** GOTO lbl-1000
        if (usableDisks.stream().map((Function<DiskInfo, WorkerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Lorg/apache/celeborn/common/meta/DiskInfo;)Lorg/apache/celeborn/common/meta/WorkerInfo;)(diskToWorkerMap)).distinct().count() <= 1L) lbl-1000:
        // 3 sources

        {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        noUsableDisks = v0;
        v1 = noAvailableSlots = usableDisks.stream().mapToLong((ToLongFunction<DiskInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)J, availableSlots(), (Lorg/apache/celeborn/common/meta/DiskInfo;)J)()).sum() <= 0L;
        if (noUsableDisks || noAvailableSlots) {
            SlotsAllocator.logger.warn("offer slots for {} fallback to roundrobin because there is no {}", (Object)StringUtils.join(partitionIds, (char)','), (Object)(noUsableDisks != false ? "usable disks" : "available slots"));
            return SlotsAllocator.offerSlotsRoundRobin(workers, partitionIds, shouldReplicate, shouldRackAware, availableStorageTypes);
        }
        if (!SlotsAllocator.initialized) {
            SlotsAllocator.initLoadAwareAlgorithm(diskGroupCount, diskGroupGradient);
        }
        slotsRestrictions = SlotsAllocator.getSlotsRestrictionsByLoadAwareAlgorithm(SlotsAllocator.placeDisksToGroups(usableDisks, diskGroupCount, flushTimeWeight, fetchTimeWeight), diskToWorkerMap, shouldReplicate != false ? partitionIds.size() * 2 : partitionIds.size());
        return SlotsAllocator.locateSlots(partitionIds, workers, slotsRestrictions, shouldReplicate, shouldRackAware, availableStorageTypes);
    }

    private static StorageInfo getStorageInfo(List<WorkerInfo> workers, int workerIndex, Map<WorkerInfo, List<UsableDiskInfo>> restrictions, Map<WorkerInfo, Integer> workerDiskIndex, int availableStorageTypes) {
        StorageInfo storageInfo;
        WorkerInfo selectedWorker = workers.get(workerIndex);
        int diskIndex = workerDiskIndex.computeIfAbsent(selectedWorker, v -> 0);
        if (restrictions != null) {
            List<UsableDiskInfo> usableDiskInfos = restrictions.get(selectedWorker);
            while (usableDiskInfos.get((int)diskIndex).usableSlots <= 0L) {
                diskIndex = (diskIndex + 1) % usableDiskInfos.size();
            }
            --usableDiskInfos.get((int)diskIndex).usableSlots;
            DiskInfo selectedDiskInfo = usableDiskInfos.get((int)diskIndex).diskInfo;
            if (selectedDiskInfo.storageType() == StorageInfo.Type.HDFS) {
                storageInfo = new StorageInfo("", StorageInfo.Type.HDFS, availableStorageTypes);
            } else {
                storageInfo = new StorageInfo(selectedDiskInfo.mountPoint(), selectedDiskInfo.storageType(), availableStorageTypes);
                workerDiskIndex.put(selectedWorker, (diskIndex + 1) % usableDiskInfos.size());
            }
        } else if (StorageInfo.localDiskAvailable((int)availableStorageTypes)) {
            DiskInfo[] diskInfos = selectedWorker.diskInfos().values().stream().filter(p -> p.storageType() != StorageInfo.Type.HDFS).collect(Collectors.toList()).toArray(new DiskInfo[0]);
            storageInfo = new StorageInfo(diskInfos[diskIndex].mountPoint(), diskInfos[diskIndex].storageType(), availableStorageTypes);
            workerDiskIndex.put(selectedWorker, (diskIndex + 1) % diskInfos.length);
        } else {
            storageInfo = new StorageInfo("", StorageInfo.Type.HDFS, availableStorageTypes);
        }
        return storageInfo;
    }

    private static Map<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>> locateSlots(List<Integer> partitionIds, List<WorkerInfo> workersList, Map<WorkerInfo, List<UsableDiskInfo>> slotRestrictions, boolean shouldReplicate, boolean shouldRackAware, int availableStorageTypes) {
        HashMap<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>> slots;
        List<Integer> remain;
        List<WorkerInfo> workersFromSlotRestrictions = new ArrayList<WorkerInfo>(slotRestrictions.keySet());
        List<WorkerInfo> workers = workersList;
        if (shouldReplicate && shouldRackAware) {
            workersFromSlotRestrictions = SlotsAllocator.generateRackAwareWorkers(workersFromSlotRestrictions);
            workers = SlotsAllocator.generateRackAwareWorkers(workers);
        }
        if (!(remain = SlotsAllocator.roundRobin(slots = new HashMap<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>>(), partitionIds, workersFromSlotRestrictions, slotRestrictions, shouldReplicate, shouldRackAware, availableStorageTypes)).isEmpty()) {
            remain = SlotsAllocator.roundRobin(slots, remain, workers, null, shouldReplicate, shouldRackAware, availableStorageTypes);
        }
        if (!remain.isEmpty()) {
            SlotsAllocator.roundRobin(slots, remain, workers, null, shouldReplicate, false, availableStorageTypes);
        }
        return slots;
    }

    static List<WorkerInfo> generateRackAwareWorkers(List<WorkerInfo> workers) {
        HashMap<String, LinkedList> map = new HashMap<String, LinkedList>();
        for (WorkerInfo worker : workers) {
            map.computeIfAbsent(worker.networkLocation(), key -> new LinkedList()).add(worker);
        }
        ArrayList sortedRackToHosts = new ArrayList(map.entrySet());
        sortedRackToHosts.sort((o1, o2) -> Integer.compare(((LinkedList)o2.getValue()).size(), ((LinkedList)o1.getValue()).size()));
        ArrayList result = new ArrayList(workers.size());
        int count = 0;
        int numWorkers = workers.size();
        while (count < numWorkers) {
            Iterator iter = sortedRackToHosts.iterator();
            while (iter.hasNext()) {
                LinkedList workerList = (LinkedList)((Map.Entry)iter.next()).getValue();
                result.add(workerList.removeFirst());
                ++count;
                if (!workerList.isEmpty()) continue;
                iter.remove();
            }
        }
        return Collections.unmodifiableList(result);
    }

    private static List<Integer> roundRobin(Map<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>> slots, List<Integer> partitionIds, List<WorkerInfo> workers, Map<WorkerInfo, List<UsableDiskInfo>> slotsRestrictions, boolean shouldReplicate, boolean shouldRackAware, int availableStorageTypes) {
        HashMap<WorkerInfo, Integer> workerDiskIndexForPrimary = new HashMap<WorkerInfo, Integer>();
        HashMap<WorkerInfo, Integer> workerDiskIndexForReplica = new HashMap<WorkerInfo, Integer>();
        ArrayList<Integer> partitionIdList = new ArrayList<Integer>(partitionIds);
        int workerSize = workers.size();
        IntUnaryOperator incrementIndex = v -> (v + 1) % workerSize;
        int primaryIndex = rand.nextInt(workerSize);
        int replicaIndex = rand.nextInt(workerSize);
        Iterator iter = partitionIdList.iterator();
        block0: while (iter.hasNext()) {
            StorageInfo storageInfo;
            int nextPrimaryInd = primaryIndex;
            int partitionId = (Integer)iter.next();
            if (slotsRestrictions != null && !slotsRestrictions.isEmpty()) {
                while (!SlotsAllocator.haveUsableSlots(slotsRestrictions, workers, nextPrimaryInd)) {
                    if ((nextPrimaryInd = incrementIndex.applyAsInt(nextPrimaryInd)) != primaryIndex) continue;
                    break block0;
                }
                storageInfo = SlotsAllocator.getStorageInfo(workers, nextPrimaryInd, slotsRestrictions, workerDiskIndexForPrimary, availableStorageTypes);
            } else {
                if (StorageInfo.localDiskAvailable((int)availableStorageTypes)) {
                    while (!workers.get(nextPrimaryInd).haveDisk()) {
                        if ((nextPrimaryInd = incrementIndex.applyAsInt(nextPrimaryInd)) != primaryIndex) continue;
                        break block0;
                    }
                }
                storageInfo = SlotsAllocator.getStorageInfo(workers, nextPrimaryInd, null, workerDiskIndexForPrimary, availableStorageTypes);
            }
            PartitionLocation primaryPartition = SlotsAllocator.createLocation(partitionId, workers.get(nextPrimaryInd), null, storageInfo, true);
            if (shouldReplicate) {
                int nextReplicaInd = replicaIndex;
                if (slotsRestrictions != null) {
                    while (nextReplicaInd == nextPrimaryInd || !SlotsAllocator.haveUsableSlots(slotsRestrictions, workers, nextReplicaInd) || !SlotsAllocator.satisfyRackAware(shouldRackAware, workers, nextPrimaryInd, nextReplicaInd)) {
                        if ((nextReplicaInd = incrementIndex.applyAsInt(nextReplicaInd)) != replicaIndex) continue;
                        break block0;
                    }
                    storageInfo = SlotsAllocator.getStorageInfo(workers, nextReplicaInd, slotsRestrictions, workerDiskIndexForReplica, availableStorageTypes);
                } else if (shouldRackAware) {
                    while (nextReplicaInd == nextPrimaryInd || !SlotsAllocator.satisfyRackAware(true, workers, nextPrimaryInd, nextReplicaInd)) {
                        if ((nextReplicaInd = incrementIndex.applyAsInt(nextReplicaInd)) != replicaIndex) continue;
                        break block0;
                    }
                } else {
                    if (StorageInfo.localDiskAvailable((int)availableStorageTypes)) {
                        while (nextReplicaInd == nextPrimaryInd || !workers.get(nextReplicaInd).haveDisk()) {
                            if ((nextReplicaInd = incrementIndex.applyAsInt(nextReplicaInd)) != replicaIndex) continue;
                            break block0;
                        }
                    }
                    storageInfo = SlotsAllocator.getStorageInfo(workers, nextReplicaInd, null, workerDiskIndexForReplica, availableStorageTypes);
                }
                PartitionLocation replicaPartition = SlotsAllocator.createLocation(partitionId, workers.get(nextReplicaInd), primaryPartition, storageInfo, false);
                primaryPartition.setPeer(replicaPartition);
                Tuple2 locations = slots.computeIfAbsent(workers.get(nextReplicaInd), v -> new Tuple2(new ArrayList(), new ArrayList()));
                ((List)locations._2).add(replicaPartition);
                replicaIndex = incrementIndex.applyAsInt(nextReplicaInd);
            }
            Tuple2 locations = slots.computeIfAbsent(workers.get(nextPrimaryInd), v -> new Tuple2(new ArrayList(), new ArrayList()));
            ((List)locations._1).add(primaryPartition);
            primaryIndex = incrementIndex.applyAsInt(nextPrimaryInd);
            iter.remove();
        }
        return partitionIdList;
    }

    private static boolean haveUsableSlots(Map<WorkerInfo, List<UsableDiskInfo>> restrictions, List<WorkerInfo> workers, int index) {
        return restrictions.get(workers.get(index)).stream().mapToLong(i -> i.usableSlots).sum() > 0L;
    }

    private static boolean satisfyRackAware(boolean shouldRackAware, List<WorkerInfo> workers, int primaryIndex, int nextReplicaInd) {
        return !shouldRackAware || !Objects.equals(workers.get(primaryIndex).networkLocation(), workers.get(nextReplicaInd).networkLocation());
    }

    private static void initLoadAwareAlgorithm(int diskGroups, double diskGroupGradient) {
        int i;
        taskAllocationRatio = new double[diskGroups];
        double totalAllocations = 0.0;
        for (i = 0; i < diskGroups; ++i) {
            totalAllocations += Math.pow(1.0 + diskGroupGradient, diskGroups - 1 - i);
        }
        for (i = 0; i < diskGroups; ++i) {
            SlotsAllocator.taskAllocationRatio[i] = Math.pow(1.0 + diskGroupGradient, diskGroups - 1 - i) / totalAllocations;
        }
        logger.info("load-aware offer slots algorithm init with taskAllocationRatio {}", (Object)StringUtils.join((double[])taskAllocationRatio, (char)','));
        initialized = true;
    }

    private static List<List<DiskInfo>> placeDisksToGroups(List<DiskInfo> usableDisks, int diskGroupCount, double flushTimeWeight, double fetchTimeWeight) {
        ArrayList<List<DiskInfo>> diskGroups = new ArrayList<List<DiskInfo>>();
        usableDisks.sort((o1, o2) -> {
            double delta = (double)o1.avgFlushTime() * flushTimeWeight + (double)o1.avgFetchTime() * fetchTimeWeight - ((double)o2.avgFlushTime() * flushTimeWeight + (double)o2.avgFetchTime() * fetchTimeWeight);
            return delta < 0.0 ? -1 : (delta > 0.0 ? 1 : 0);
        });
        int diskCount = usableDisks.size();
        int startIndex = 0;
        int groupSizeSize = (int)Math.ceil((double)usableDisks.size() / (double)diskGroupCount);
        for (int i = 0; i < diskGroupCount; ++i) {
            ArrayList<DiskInfo> diskList = new ArrayList<DiskInfo>();
            if (startIndex >= usableDisks.size()) continue;
            if (startIndex + groupSizeSize <= diskCount) {
                diskList.addAll(usableDisks.subList(startIndex, startIndex + groupSizeSize));
                startIndex += groupSizeSize;
            } else {
                diskList.addAll(usableDisks.subList(startIndex, usableDisks.size()));
                startIndex = usableDisks.size();
            }
            diskGroups.add(diskList);
        }
        return diskGroups;
    }

    private static Map<WorkerInfo, List<UsableDiskInfo>> getSlotsRestrictionsByLoadAwareAlgorithm(List<List<DiskInfo>> groups, Map<DiskInfo, WorkerInfo> diskWorkerMap, int partitionCnt) {
        int i;
        int groupSize = groups.size();
        long[] groupAllocations = new long[groupSize];
        HashMap<WorkerInfo, List<UsableDiskInfo>> restrictions = new HashMap<WorkerInfo, List<UsableDiskInfo>>();
        long[] groupAvailableSlots = new long[groupSize];
        for (int i2 = 0; i2 < groupSize; ++i2) {
            for (DiskInfo disk : groups.get(i2)) {
                int n = i2;
                groupAvailableSlots[n] = groupAvailableSlots[n] + disk.availableSlots();
            }
        }
        double[] currentAllocation = new double[groupSize];
        double currentAllocationSum = 0.0;
        for (i = 0; i < groupSize; ++i) {
            if (groups.get(i).isEmpty()) continue;
            currentAllocationSum += taskAllocationRatio[i];
        }
        for (i = 0; i < groupSize; ++i) {
            if (groups.get(i).isEmpty()) continue;
            currentAllocation[i] = taskAllocationRatio[i] / currentAllocationSum;
        }
        long toNextGroup = 0L;
        long left = partitionCnt;
        for (int i3 = 0; i3 < groupSize && left > 0L; left -= groupAllocations[i3], ++i3) {
            long estimateAllocation = (int)Math.ceil((double)partitionCnt * currentAllocation[i3]);
            if (estimateAllocation > left) {
                estimateAllocation = left;
            }
            if (estimateAllocation + toNextGroup > groupAvailableSlots[i3]) {
                groupAllocations[i3] = groupAvailableSlots[i3];
                toNextGroup = estimateAllocation - groupAvailableSlots[i3] + toNextGroup;
                continue;
            }
            groupAllocations[i3] = estimateAllocation + toNextGroup;
        }
        long groupLeft = 0L;
        for (int i4 = 0; i4 < groups.size(); ++i4) {
            int disksInsideGroup = groups.get(i4).size();
            long groupRequired = groupAllocations[i4] + groupLeft;
            for (DiskInfo disk : groups.get(i4)) {
                if (groupRequired <= 0L) break;
                List diskAllocation = restrictions.computeIfAbsent(diskWorkerMap.get(disk), v -> new ArrayList());
                long allocated = (int)Math.ceil((double)(groupAllocations[i4] + groupLeft) / (double)disksInsideGroup);
                if (allocated > disk.availableSlots()) {
                    allocated = disk.availableSlots();
                }
                if (allocated > groupRequired) {
                    allocated = groupRequired;
                }
                diskAllocation.add(new UsableDiskInfo(disk, Math.toIntExact(allocated)));
                groupRequired -= allocated;
            }
            groupLeft = groupRequired;
        }
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (int i5 = 0; i5 < groups.size(); ++i5) {
                sb.append("| group ").append(i5).append(" ");
                for (DiskInfo diskInfo : groups.get(i5)) {
                    WorkerInfo workerInfo = diskWorkerMap.get(diskInfo);
                    String workerHost = workerInfo.host();
                    long allocation = 0L;
                    if (restrictions.get(workerInfo) != null) {
                        for (UsableDiskInfo usableInfo : (List)restrictions.get(workerInfo)) {
                            if (!usableInfo.diskInfo.equals(diskInfo)) continue;
                            allocation = usableInfo.usableSlots;
                        }
                    }
                    sb.append(workerHost).append("-").append(diskInfo.mountPoint()).append(" flushtime:").append(diskInfo.avgFlushTime()).append(" fetchtime:").append(diskInfo.avgFetchTime()).append(" allocation: ").append(allocation).append(" ");
                }
                sb.append(" | ");
            }
            logger.debug("total {} allocate with group {} with allocations {}", new Object[]{partitionCnt, StringUtils.join((long[])groupAllocations, (char)','), sb});
        }
        return restrictions;
    }

    private static PartitionLocation createLocation(int partitionIndex, WorkerInfo workerInfo, PartitionLocation peer, StorageInfo storageInfo, boolean isPrimary) {
        return new PartitionLocation(partitionIndex, 0, workerInfo.host(), workerInfo.rpcPort(), workerInfo.pushPort(), workerInfo.fetchPort(), workerInfo.replicatePort(), isPrimary ? PartitionLocation.Mode.PRIMARY : PartitionLocation.Mode.REPLICA, peer, storageInfo, new RoaringBitmap());
    }

    public static Map<WorkerInfo, Map<String, Integer>> slotsToDiskAllocations(Map<WorkerInfo, Tuple2<List<PartitionLocation>, List<PartitionLocation>>> slots) {
        Iterator<WorkerInfo> workers = slots.keySet().iterator();
        HashMap<WorkerInfo, Map<String, Integer>> workerToSlots = new HashMap<WorkerInfo, Map<String, Integer>>();
        while (workers.hasNext()) {
            WorkerInfo worker = workers.next();
            Map slotsPerDisk = workerToSlots.computeIfAbsent(worker, v -> new HashMap());
            ArrayList jointLocations = new ArrayList();
            jointLocations.addAll((Collection)slots.get((Object)worker)._1);
            jointLocations.addAll((Collection)slots.get((Object)worker)._2);
            for (PartitionLocation location : jointLocations) {
                String mountPoint = location.getStorageInfo().getMountPoint();
                if (mountPoint.isEmpty()) continue;
                if (slotsPerDisk.containsKey(mountPoint)) {
                    slotsPerDisk.put(mountPoint, (Integer)slotsPerDisk.get(mountPoint) + 1);
                    continue;
                }
                slotsPerDisk.put(mountPoint, 1);
            }
        }
        return workerToSlots;
    }

    private static /* synthetic */ void lambda$offerSlotsLoadAware$2(Map diskToWorkerMap, long diskReserveSize, Option diskReserveRatio, List usableDisks, WorkerInfo i) {
        i.diskInfos().forEach((key, diskInfo) -> {
            diskToWorkerMap.put(diskInfo, i);
            if (diskInfo.actualUsableSpace() > DiskUtils.getMinimumUsableSize((DiskInfo)diskInfo, (long)diskReserveSize, (Option)(diskReserveRatio.isEmpty() ? Option.empty() : Option.apply((Object)diskReserveRatio.get()))) && diskInfo.status().equals((Object)DiskStatus.HEALTHY) && diskInfo.storageType() != StorageInfo.Type.HDFS) {
                usableDisks.add(diskInfo);
            }
        });
    }

    static class UsableDiskInfo {
        DiskInfo diskInfo;
        long usableSlots;

        UsableDiskInfo(DiskInfo diskInfo, long usableSlots) {
            this.diskInfo = diskInfo;
            this.usableSlots = usableSlots;
        }
    }
}

