/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.celeborn.common.internal.config.ConfigEntry;
import org.apache.celeborn.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DynamicConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicConfig.class);
    protected Map<String, String> configs = new HashMap<String, String>();

    public abstract DynamicConfig getParentLevelConfig();

    public <T> T getWithDefaultValue(String configKey, T defaultValue, Class<T> finalType, ConfigType configType) {
        T formatValue;
        String configValue = this.configs.get(configKey);
        T t = formatValue = configValue != null ? (T)this.formatValue(configKey, configValue, finalType, configType) : null;
        if (formatValue == null) {
            return defaultValue;
        }
        return formatValue;
    }

    public <T> T getValue(String configKey, ConfigEntry<Object> configEntry, Class<T> finalType, ConfigType configType) {
        T formatValue;
        String configValue = this.configs.get(configKey);
        T t = formatValue = configValue != null ? (T)this.formatValue(configKey, configValue, finalType, configType) : null;
        if (formatValue == null) {
            DynamicConfig parentLevelConfig = this.getParentLevelConfig();
            return parentLevelConfig != null ? (T)parentLevelConfig.getValue(configKey, configEntry, finalType, configType) : null;
        }
        return formatValue;
    }

    public <T> T formatValue(String configKey, String configValue, Class<T> finalType, ConfigType configType) {
        try {
            if (configValue != null) {
                if (ConfigType.BYTES == configType) {
                    return DynamicConfig.convert(finalType, String.valueOf(Utils.byteStringAsBytes((String)configValue)));
                }
                if (ConfigType.TIME_MS == configType) {
                    return DynamicConfig.convert(finalType, String.valueOf(Utils.timeStringAsMs((String)configValue)));
                }
                return DynamicConfig.convert(finalType, configValue);
            }
        }
        catch (Exception e) {
            LOG.warn("Config {} value format is not valid, refer to parent if exist", (Object)configKey, (Object)e);
        }
        return null;
    }

    public Map<String, String> getConfigs() {
        return this.configs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DynamicConfig{");
        sb.append("configs=").append(this.configs);
        sb.append('}');
        return sb.toString();
    }

    public static <T> T convert(Class<T> clazz, String value) {
        if (Boolean.TYPE == clazz) {
            return (T)Boolean.valueOf(value);
        }
        if (Byte.TYPE == clazz) {
            return (T)Byte.valueOf(value);
        }
        if (Short.TYPE == clazz) {
            return (T)Short.valueOf(value);
        }
        if (Integer.TYPE == clazz) {
            return (T)Integer.valueOf(value);
        }
        if (Long.TYPE == clazz) {
            return (T)Long.valueOf(value);
        }
        if (Float.TYPE == clazz) {
            return (T)Float.valueOf(value);
        }
        if (Double.TYPE == clazz) {
            return (T)Double.valueOf(value);
        }
        return (T)value;
    }

    public static enum ConfigType {
        BYTES,
        STRING,
        TIME_MS;

    }
}

