/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.meta.DeviceInfo;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

public final class DeviceInfo$
implements Serializable {
    public static final DeviceInfo$ MODULE$;
    private final Logger logger;

    static {
        new DeviceInfo$();
    }

    public Logger logger() {
        return this.logger;
    }

    public Tuple2<Map<String, DeviceInfo>, Map<String, DiskInfo>> getDeviceAndDiskInfos(Seq<Tuple4<File, Object, Object, StorageInfo.Type>> workingDirs, CelebornConf conf) {
        HashMap deviceNameToDeviceInfo = new HashMap();
        HashMap mountPointToDeviceInfo = new HashMap();
        String dfResult = Utils$.MODULE$.runCommand("df -ah").trim();
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"df result\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dfResult})));
        Tuple2[] fsMounts = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])dfResult.split("[\n\r]")).tail()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String line) {
                String[] tokens = line.trim().split("[ \t]+");
                return new Tuple2(Predef$.MODULE$.refArrayOps((Object[])tokens).head(), Predef$.MODULE$.refArrayOps((Object[])tokens).last());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        String lsBlockResult = Utils$.MODULE$.runCommand("ls /sys/block/").trim();
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ls block\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lsBlockResult})));
        String[] blocks = lsBlockResult.split("[ \n\r\t]+");
        Predef$.MODULE$.refArrayOps((Object[])fsMounts).foreach((Function1)new Serializable(deviceNameToDeviceInfo, mountPointToDeviceInfo, blocks){
            public static final long serialVersionUID = 0L;
            private final HashMap deviceNameToDeviceInfo$1;
            private final HashMap mountPointToDeviceInfo$1;
            private final String[] blocks$1;

            public final DeviceInfo apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String fileSystem = (String)tuple2._1();
                    String mountPoint = (String)tuple2._2();
                    String deviceName = fileSystem.substring(fileSystem.lastIndexOf(47) + 1);
                    IntRef index = IntRef.create((int)-1);
                    IntRef maxLength = IntRef.create((int)-1);
                    Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.blocks$1).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, deviceName, index, maxLength){
                        public static final long serialVersionUID = 0L;
                        private final String deviceName$1;
                        private final IntRef index$1;
                        private final IntRef maxLength$1;

                        public final void apply(Tuple2<String, Object> block) {
                            if (this.deviceName$1.startsWith((String)block._1()) && ((String)block._1()).length() > this.maxLength$1.elem) {
                                this.index$1.elem = block._2$mcI$sp();
                                this.maxLength$1.elem = ((String)block._1()).length();
                            }
                        }
                        {
                            this.deviceName$1 = deviceName$1;
                            this.index$1 = index$1;
                            this.maxLength$1 = maxLength$1;
                        }
                    });
                    Function<String, DeviceInfo> newDeviceInfoFunc = new Function<String, DeviceInfo>(this, index){
                        private final IntRef index$1;

                        /*
                         * WARNING - void declaration
                         */
                        public DeviceInfo apply(String s) {
                            void var2_2;
                            DeviceInfo deviceInfo = new DeviceInfo(s);
                            if (this.index$1.elem < 0) {
                                deviceInfo.deviceStatAvailable_$eq(false);
                            }
                            return var2_2;
                        }
                        {
                            this.index$1 = index$1;
                        }
                    };
                    DeviceInfo deviceInfo = index.elem >= 0 ? this.deviceNameToDeviceInfo$1.computeIfAbsent(this.blocks$1[index.elem], newDeviceInfoFunc) : this.deviceNameToDeviceInfo$1.computeIfAbsent(deviceName, newDeviceInfoFunc);
                    DeviceInfo deviceInfo2 = this.mountPointToDeviceInfo$1.putIfAbsent(mountPoint, deviceInfo);
                    return deviceInfo2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.deviceNameToDeviceInfo$1 = deviceNameToDeviceInfo$1;
                this.mountPointToDeviceInfo$1 = mountPointToDeviceInfo$1;
                this.blocks$1 = blocks$1;
            }
        });
        ConcurrentHashMap retDeviceInfos = JavaUtils.newConcurrentHashMap();
        ConcurrentHashMap retDiskInfos = JavaUtils.newConcurrentHashMap();
        workingDirs.groupBy((Function1)new Serializable(mountPointToDeviceInfo){
            public static final long serialVersionUID = 0L;
            private final HashMap mountPointToDeviceInfo$1;

            public final String apply(Tuple4<File, Object, Object, StorageInfo.Type> x0$2) {
                Tuple4<File, Object, Object, StorageInfo.Type> tuple4 = x0$2;
                if (tuple4 != null) {
                    File dir = (File)tuple4._1();
                    String string = DeviceInfo$.MODULE$.getMountPoint(dir.getCanonicalPath(), this.mountPointToDeviceInfo$1.keySet());
                    return string;
                }
                throw new MatchError(tuple4);
            }
            {
                this.mountPointToDeviceInfo$1 = mountPointToDeviceInfo$1;
            }
        }).foreach((Function1)new Serializable(conf, mountPointToDeviceInfo, retDiskInfos){
            public static final long serialVersionUID = 0L;
            private final CelebornConf conf$1;
            private final HashMap mountPointToDeviceInfo$1;
            private final ConcurrentHashMap retDiskInfos$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(Tuple2<String, Seq<Tuple4<File, Object, Object, StorageInfo.Type>>> x0$3) {
                Object object;
                Tuple2<String, Seq<Tuple4<File, Object, Object, StorageInfo.Type>>> tuple2 = x0$3;
                if (tuple2 == null) throw new MatchError(tuple2);
                String mountPoint = (String)tuple2._1();
                Seq dirs = (Seq)tuple2._2();
                if (new StringOps(Predef$.MODULE$.augmentString(mountPoint)).nonEmpty()) {
                    Tuple3 tuple3;
                    DeviceInfo deviceInfo = (DeviceInfo)this.mountPointToDeviceInfo$1.get(mountPoint);
                    DiskInfo diskInfo = new DiskInfo(mountPoint, (List<File>)((TraversableOnce)dirs.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final File apply(Tuple4<File, Object, Object, StorageInfo.Type> workingDir) {
                            return new File(((File)workingDir._1()).getCanonicalPath());
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toList(), deviceInfo, this.conf$1);
                    Tuple4 tuple4 = (Tuple4)dirs.apply(0);
                    if (tuple4 == null) throw new MatchError((Object)tuple4);
                    long maxUsableSpace = BoxesRunTime.unboxToLong((Object)tuple4._2());
                    int threadCount = BoxesRunTime.unboxToInt((Object)tuple4._3());
                    StorageInfo.Type storageType = (StorageInfo.Type)((Object)tuple4._4());
                    Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)maxUsableSpace), (Object)BoxesRunTime.boxToInteger((int)threadCount), (Object)((Object)storageType));
                    long maxUsableSpace2 = BoxesRunTime.unboxToLong((Object)tuple32._1());
                    int threadCount2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
                    StorageInfo.Type storageType2 = (StorageInfo.Type)((Object)tuple32._3());
                    diskInfo.configuredUsableSpace_$eq(maxUsableSpace2);
                    diskInfo.threadCount_$eq(threadCount2);
                    diskInfo.storageType_$eq(storageType2);
                    deviceInfo.addDiskInfo(diskInfo);
                    object = this.retDiskInfos$1.put(mountPoint, diskInfo);
                    return object;
                } else {
                    DeviceInfo$.MODULE$.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't find mount point for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)dirs.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple4<File, Object, Object, StorageInfo.Type> x$4) {
                            return ((File)x$4._1()).getCanonicalPath();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(",")})));
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.conf$1 = conf$1;
                this.mountPointToDeviceInfo$1 = mountPointToDeviceInfo$1;
                this.retDiskInfos$1 = retDiskInfos$1;
            }
        });
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(deviceNameToDeviceInfo).asScala()).foreach((Function1)new Serializable(retDeviceInfos){
            public static final long serialVersionUID = 0L;
            private final ConcurrentHashMap retDeviceInfos$1;

            public final Object apply(Tuple2<String, DeviceInfo> x0$4) {
                Tuple2<String, DeviceInfo> tuple2 = x0$4;
                if (tuple2 != null) {
                    DeviceInfo deviceInfo = (DeviceInfo)tuple2._2();
                    BoxedUnit boxedUnit = deviceInfo.diskInfos().nonEmpty() ? this.retDeviceInfos$1.put(deviceInfo.name(), deviceInfo) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.retDeviceInfos$1 = retDeviceInfos$1;
            }
        });
        this.logger().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Device initialization \\n "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " \\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{retDeviceInfos, retDiskInfos}))).toString());
        return new Tuple2(retDeviceInfos, retDiskInfos);
    }

    public String getMountPoint(String absPath, Set<String> mountPoints) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            String string;
            Object object = new Object();
            try {
                IntRef curMax = IntRef.create((int)-1);
                ObjectRef curMount = ObjectRef.create((Object)"");
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(mountPoints).asScala()).foreach((Function1)new Serializable(absPath, curMax, curMount, object){
                    public static final long serialVersionUID = 0L;
                    private final String absPath$1;
                    private final IntRef curMax$1;
                    private final ObjectRef curMount$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(String mount) {
                        block4: {
                            block5: {
                                if (!this.absPath$1.startsWith(mount) || mount.length() <= this.curMax$1.elem) break block4;
                                if (this.absPath$1.length() == mount.length()) {
                                    throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)mount);
                                }
                                if (this.absPath$1.length() <= mount.length()) break block4;
                                String string = mount;
                                String string2 = "/";
                                if (!(string == null ? string2 != null : !string.equals(string2))) break block5;
                                String string3 = this.absPath$1.substring(mount.length(), mount.length() + 1);
                                String string4 = "/";
                                if (string3 != null ? !string3.equals(string4) : string4 != null) break block4;
                            }
                            this.curMax$1.elem = mount.length();
                            this.curMount$1.elem = mount;
                        }
                    }
                    {
                        this.absPath$1 = absPath$1;
                        this.curMax$1 = curMax$1;
                        this.curMount$1 = curMount$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                string = (String)curMount.elem;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                string = (String)nonLocalReturnControl2.value();
            }
            return string;
        }
        throw nonLocalReturnControl2;
    }

    public String getMountPoint(String absPath, Map<String, DiskInfo> diskInfos) {
        return this.getMountPoint(absPath, diskInfos.keySet());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DeviceInfo$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(DeviceInfo.class);
    }
}

