/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.protocol.ShuffleMode;
import org.apache.celeborn.reflect.DynMethods;
import org.apache.spark.MapOutputTrackerMaster;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.DeterministicLevel;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.celeborn.CelebornShuffleFallbackPolicyRunner;
import org.apache.spark.shuffle.celeborn.CelebornShuffleHandle;
import org.apache.spark.shuffle.celeborn.CelebornShuffleReader;
import org.apache.spark.shuffle.celeborn.ExecutorShuffleIdTracker;
import org.apache.spark.shuffle.celeborn.HashBasedShuffleWriter;
import org.apache.spark.shuffle.celeborn.SendBufferPool;
import org.apache.spark.shuffle.celeborn.SortBasedShuffleWriter;
import org.apache.spark.shuffle.celeborn.SparkUtils;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkShuffleManager
implements ShuffleManager {
    private static final Logger logger;
    private static final String SORT_SHUFFLE_MANAGER_NAME = "org.apache.spark.shuffle.sort.SortShuffleManager";
    private static final boolean COLUMNAR_SHUFFLE_CLASSES_PRESENT;
    private final SparkConf conf;
    private final Boolean isDriver;
    private final CelebornConf celebornConf;
    private final int cores;
    private String appUniqueId;
    private LifecycleManager lifecycleManager;
    private ShuffleClient shuffleClient;
    private volatile SortShuffleManager _sortShuffleManager;
    private final ConcurrentHashMap.KeySetView<Integer, Boolean> sortShuffleIds = ConcurrentHashMap.newKeySet();
    private final CelebornShuffleFallbackPolicyRunner fallbackPolicyRunner;
    private long sendBufferPoolCheckInterval;
    private long sendBufferPoolExpireTimeout;
    private ExecutorShuffleIdTracker shuffleIdTracker = new ExecutorShuffleIdTracker();

    public SparkShuffleManager(SparkConf conf, boolean isDriver) {
        if (conf.getBoolean(SQLConf.LOCAL_SHUFFLE_READER_ENABLED().key(), true)) {
            logger.warn("Detected {} (default is true) is enabled, it's highly recommended to disable it when use Celeborn as Remote Shuffle Service to avoid performance degradation.", (Object)SQLConf.LOCAL_SHUFFLE_READER_ENABLED().key());
        }
        if (((Boolean)conf.get(package$.MODULE$.DYN_ALLOCATION_SHUFFLE_TRACKING_ENABLED())).booleanValue()) {
            String key = package$.MODULE$.DYN_ALLOCATION_SHUFFLE_TRACKING_ENABLED().key();
            Boolean defaultValue = (Boolean)package$.MODULE$.DYN_ALLOCATION_SHUFFLE_TRACKING_ENABLED().defaultValue().get();
            logger.warn("Detected {} (default is {}) is enabled, it's highly recommended to disable it when use Celeborn as Remote Shuffle Service to avoid performance degradation.", (Object)key, (Object)defaultValue);
        }
        this.conf = conf;
        this.isDriver = isDriver;
        this.celebornConf = SparkUtils.fromSparkConf(conf);
        this.cores = this.executorCores(conf);
        this.fallbackPolicyRunner = new CelebornShuffleFallbackPolicyRunner(this.celebornConf);
        this.sendBufferPoolCheckInterval = this.celebornConf.clientPushSendBufferPoolExpireCheckInterval();
        this.sendBufferPoolExpireTimeout = this.celebornConf.clientPushSendBufferPoolExpireTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortShuffleManager sortShuffleManager() {
        if (this._sortShuffleManager == null) {
            SparkShuffleManager sparkShuffleManager = this;
            synchronized (sparkShuffleManager) {
                if (this._sortShuffleManager == null) {
                    this._sortShuffleManager = (SortShuffleManager)SparkUtils.instantiateClass(SORT_SHUFFLE_MANAGER_NAME, this.conf, this.isDriver);
                }
            }
        }
        return this._sortShuffleManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLifecycleManager() {
        if (this.isDriver.booleanValue() && this.lifecycleManager == null) {
            SparkShuffleManager sparkShuffleManager = this;
            synchronized (sparkShuffleManager) {
                if (this.lifecycleManager == null) {
                    this.lifecycleManager = new LifecycleManager(this.appUniqueId, this.celebornConf);
                    if (this.celebornConf.clientFetchThrowsFetchFailure()) {
                        MapOutputTrackerMaster mapOutputTracker = (MapOutputTrackerMaster)SparkEnv.get().mapOutputTracker();
                        this.lifecycleManager.registerShuffleTrackerCallback(shuffleId -> SparkUtils.unregisterAllMapOutput(mapOutputTracker, shuffleId));
                    }
                }
            }
        }
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, ShuffleDependency<K, V, C> dependency) {
        this.appUniqueId = SparkUtils.appUniqueId(dependency.rdd().context());
        this.initializeLifecycleManager();
        this.lifecycleManager.registerAppShuffleDeterminate(shuffleId, dependency.rdd().getOutputDeterministicLevel() != DeterministicLevel.INDETERMINATE());
        if (this.fallbackPolicyRunner.applyAllFallbackPolicy(this.lifecycleManager, dependency.partitioner().numPartitions())) {
            if (this.conf.getBoolean("spark.dynamicAllocation.enabled", false) && !this.conf.getBoolean("spark.shuffle.service.enabled", false)) {
                logger.error("DRA is enabled but we fallback to vanilla Spark SortShuffleManager for shuffle: {} due to fallback policy. It may cause block can not found when reducer task fetch data.", (Object)shuffleId);
            } else {
                logger.warn("Fallback to vanilla Spark SortShuffleManager for shuffle: {}", (Object)shuffleId);
            }
            this.sortShuffleIds.add(shuffleId);
            return this.sortShuffleManager().registerShuffle(shuffleId, dependency);
        }
        return new CelebornShuffleHandle<K, V, C>(this.appUniqueId, this.lifecycleManager.getHost(), this.lifecycleManager.getPort(), this.lifecycleManager.getUserIdentifier(), shuffleId, this.celebornConf.clientFetchThrowsFetchFailure(), dependency.rdd().getNumPartitions(), dependency);
    }

    public boolean unregisterShuffle(int appShuffleId) {
        if (this.sortShuffleIds.remove(appShuffleId)) {
            return this.sortShuffleManager().unregisterShuffle(appShuffleId);
        }
        if (this.lifecycleManager != null) {
            this.lifecycleManager.unregisterAppShuffle(appShuffleId, this.celebornConf.clientFetchThrowsFetchFailure());
        }
        if (this.shuffleClient != null) {
            this.shuffleIdTracker.unregisterAppShuffleId(this.shuffleClient, appShuffleId);
        }
        return true;
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        return this.sortShuffleManager().shuffleBlockResolver();
    }

    public void stop() {
        if (this.shuffleClient != null) {
            this.shuffleClient.shutdown();
            ShuffleClient.reset();
            this.shuffleClient = null;
        }
        if (this.lifecycleManager != null) {
            this.lifecycleManager.stop();
            this.lifecycleManager = null;
        }
        if (this._sortShuffleManager != null) {
            this._sortShuffleManager.stop();
            this._sortShuffleManager = null;
        }
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, long mapId, TaskContext context, ShuffleWriteMetricsReporter metrics) {
        try {
            if (handle instanceof CelebornShuffleHandle) {
                CelebornShuffleHandle h = (CelebornShuffleHandle)handle;
                this.shuffleClient = ShuffleClient.get(h.appUniqueId(), h.lifecycleManagerHost(), h.lifecycleManagerPort(), this.celebornConf, h.userIdentifier(), h.extension());
                int shuffleId = SparkUtils.celebornShuffleId(this.shuffleClient, h, context, true);
                this.shuffleIdTracker.track(h.shuffleId(), shuffleId);
                ShuffleMode shuffleMode = this.celebornConf.shuffleWriterMode();
                if (this.celebornConf.dynamicWriteModeEnabled()) {
                    int partitionCount = h.dependency().partitioner().numPartitions();
                    if (partitionCount > this.celebornConf.dynamicWriteModePartitionNumThreshold()) {
                        logger.info("Shuffle {} write mode is changed to SORT because partition count {} is greater than threshold {}", new Object[]{shuffleId, partitionCount, this.celebornConf.dynamicWriteModePartitionNumThreshold()});
                        shuffleMode = ShuffleMode.SORT;
                    } else {
                        logger.info("Shuffle {} write mode is changed to HASH because partition count {} is less than threshold {}", new Object[]{shuffleId, partitionCount, this.celebornConf.dynamicWriteModePartitionNumThreshold()});
                        shuffleMode = ShuffleMode.HASH;
                    }
                }
                if (ShuffleMode.SORT.equals((Object)shuffleMode)) {
                    return new SortBasedShuffleWriter(shuffleId, h.dependency(), h.numMappers(), context, this.celebornConf, this.shuffleClient, metrics, SendBufferPool.get(this.cores, this.sendBufferPoolCheckInterval, this.sendBufferPoolExpireTimeout));
                }
                if (ShuffleMode.HASH.equals((Object)shuffleMode)) {
                    SendBufferPool pool = SendBufferPool.get(this.cores, this.sendBufferPoolCheckInterval, this.sendBufferPoolExpireTimeout);
                    if (COLUMNAR_SHUFFLE_CLASSES_PRESENT && this.celebornConf.columnarShuffleEnabled()) {
                        logger.info("Creating columnar hash shuffle writer for shuffle {}", (Object)shuffleId);
                        return SparkUtils.createColumnarHashBasedShuffleWriter(shuffleId, h, context, this.celebornConf, this.shuffleClient, metrics, pool);
                    }
                    return new HashBasedShuffleWriter(shuffleId, h, context, this.celebornConf, this.shuffleClient, metrics, pool);
                }
                throw new UnsupportedOperationException("Unrecognized shuffle write mode!" + (Object)((Object)this.celebornConf.shuffleWriterMode()));
            }
            this.checkUserClassPathFirst(handle);
            return this.sortShuffleManager().getWriter(handle, mapId, context, metrics);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        if (handle instanceof CelebornShuffleHandle) {
            return this.getCelebornShuffleReader(handle, startPartition, endPartition, startMapIndex, endMapIndex, context, metrics);
        }
        this.checkUserClassPathFirst(handle);
        return SparkUtils.getReader(this.sortShuffleManager(), handle, startPartition, endPartition, startMapIndex, endMapIndex, context, metrics);
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        if (handle instanceof CelebornShuffleHandle) {
            return this.getCelebornShuffleReader(handle, startPartition, endPartition, 0, Integer.MAX_VALUE, context, metrics);
        }
        this.checkUserClassPathFirst(handle);
        return SparkUtils.getReader(this.sortShuffleManager(), handle, startPartition, endPartition, 0, Integer.MAX_VALUE, context, metrics);
    }

    public <K, C> ShuffleReader<K, C> getReaderForRange(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        if (handle instanceof CelebornShuffleHandle) {
            return this.getCelebornShuffleReader(handle, startPartition, endPartition, startMapIndex, endMapIndex, context, metrics);
        }
        this.checkUserClassPathFirst(handle);
        return SparkUtils.getReader(this.sortShuffleManager(), handle, startPartition, endPartition, startMapIndex, endMapIndex, context, metrics);
    }

    public <K, C> ShuffleReader<K, C> getCelebornShuffleReader(ShuffleHandle handle, int startPartition, int endPartition, int startMapIndex, int endMapIndex, TaskContext context, ShuffleReadMetricsReporter metrics) {
        CelebornShuffleHandle h = (CelebornShuffleHandle)handle;
        if (COLUMNAR_SHUFFLE_CLASSES_PRESENT && this.celebornConf.columnarShuffleEnabled()) {
            return SparkUtils.createColumnarShuffleReader(h, startPartition, endPartition, startMapIndex, endMapIndex, context, this.celebornConf, metrics, this.shuffleIdTracker);
        }
        return new CelebornShuffleReader(h, startPartition, endPartition, startMapIndex, endMapIndex, context, this.celebornConf, metrics, this.shuffleIdTracker);
    }

    private int executorCores(SparkConf conf) {
        if (Utils.isLocalMaster((SparkConf)conf)) {
            return (Integer)DynMethods.builder("numDriverCores").impl("org.apache.spark.SparkContext$", String.class).build().bind(SparkContext$.MODULE$).invoke(conf.get("spark.master"));
        }
        return conf.getInt("spark.executor.cores", 1);
    }

    private void checkUserClassPathFirst(ShuffleHandle handle) {
        if (((Boolean)this.conf.get(package$.MODULE$.EXECUTOR_USER_CLASS_PATH_FIRST())).booleanValue() && !Objects.equals(handle.getClass().getClassLoader(), CelebornShuffleHandle.class.getClassLoader())) {
            String key = package$.MODULE$.EXECUTOR_USER_CLASS_PATH_FIRST().key();
            Boolean defaultValue = (Boolean)package$.MODULE$.EXECUTOR_USER_CLASS_PATH_FIRST().defaultValue().get();
            logger.warn("Detected {} (default is {}) is enabled, it's highly recommended to disable it when use Celeborn as Remote Shuffle Service to avoid falling back to vanilla Spark SortShuffleManager for ShuffleManger defined in user jar.", (Object)key, (Object)defaultValue);
        }
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    static {
        boolean present;
        logger = LoggerFactory.getLogger(SparkShuffleManager.class);
        try {
            Class.forName("org.apache.spark.shuffle.celeborn.ColumnarHashBasedShuffleWriter");
            Class.forName("org.apache.spark.shuffle.celeborn.CelebornColumnarShuffleReader");
            present = true;
        }
        catch (ClassNotFoundException e) {
            present = false;
        }
        COLUMNAR_SHUFFLE_CLASSES_PRESENT = present;
    }
}

