/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.meta.DiskFileInfo;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.FileMeta;
import org.apache.celeborn.common.meta.MemoryFileInfo;
import org.apache.celeborn.common.meta.ReduceFileMeta;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.unsafe.Platform;
import org.apache.celeborn.common.util.CelebornExitKind;
import org.apache.celeborn.common.util.FileChannelUtils;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.PbSerDeUtils;
import org.apache.celeborn.common.util.ShuffleBlockInfoUtils;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.service.deploy.worker.ShuffleRecoverHelper;
import org.apache.celeborn.service.deploy.worker.WorkerSource;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.shuffledb.DB;
import org.apache.celeborn.service.deploy.worker.shuffledb.DBBackend;
import org.apache.celeborn.service.deploy.worker.shuffledb.DBIterator;
import org.apache.celeborn.service.deploy.worker.shuffledb.DBProvider;
import org.apache.celeborn.service.deploy.worker.shuffledb.StoreVersion;
import org.apache.celeborn.service.deploy.worker.storage.PartitionFilesCleaner;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionFilesSorter
extends ShuffleRecoverHelper {
    private static final Logger logger = LoggerFactory.getLogger(PartitionFilesSorter.class);
    private static final StoreVersion CURRENT_VERSION = new StoreVersion(1, 0);
    private static final String RECOVERY_SORTED_FILES_FILE_NAME_PREFIX = "sortedFiles";
    private File recoverFile;
    private volatile boolean shutdown = false;
    private final ConcurrentHashMap<String, Set<String>> sortedShuffleFiles = JavaUtils.newConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> sortingShuffleFiles = JavaUtils.newConcurrentHashMap();
    private final Cache<String, Map<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>>> indexCache;
    private final Map<String, Set<String>> indexCacheNames = JavaUtils.newConcurrentHashMap();
    private final LinkedBlockingQueue<FileSorter> shuffleSortTaskDeque = new LinkedBlockingQueue();
    private final PartitionFilesCleaner cleaner;
    private final AtomicInteger sortedFileCount = new AtomicInteger();
    private final AtomicLong sortedFilesSize = new AtomicLong();
    protected final long sortTimeout;
    protected final long shuffleChunkSize;
    protected final double compactionFactor;
    protected final boolean prefetchEnabled;
    protected final long reservedMemoryPerPartition;
    private final long partitionSorterShutdownAwaitTime;
    private DB sortedFilesDb;
    protected final AbstractSource source;
    private final ExecutorService fileSorterExecutors;
    private final ExecutorService fileSorterSchedulerThread;

    public PartitionFilesSorter(MemoryManager memoryManager, CelebornConf conf, AbstractSource source) {
        this.sortTimeout = conf.workerPartitionSorterSortPartitionTimeout();
        this.shuffleChunkSize = conf.shuffleChunkSize();
        this.compactionFactor = conf.workerPartitionSorterShuffleBlockCompactionFactor();
        this.prefetchEnabled = conf.workerPartitionSorterPrefetchEnabled();
        this.reservedMemoryPerPartition = conf.workerPartitionSorterReservedMemoryPerPartition();
        this.partitionSorterShutdownAwaitTime = conf.workerGracefulShutdownPartitionSorterCloseAwaitTimeMs();
        long indexCacheMaxWeight = conf.workerPartitionSorterIndexCacheMaxWeight();
        this.source = source;
        this.cleaner = new PartitionFilesCleaner(this);
        boolean gracefulShutdown = conf.workerGracefulShutdown();
        if (gracefulShutdown) {
            try {
                String recoverPath = conf.workerGracefulShutdownRecoverPath();
                DBBackend dbBackend = DBBackend.byName(conf.workerGracefulShutdownRecoverDbBackend());
                String recoverySortedFilesFileName = dbBackend.fileName(RECOVERY_SORTED_FILES_FILE_NAME_PREFIX);
                this.recoverFile = new File(recoverPath, recoverySortedFilesFileName);
                this.sortedFilesDb = DBProvider.initDB(dbBackend, this.recoverFile, CURRENT_VERSION);
                this.reloadAndCleanSortedShuffleFiles(this.sortedFilesDb);
            }
            catch (Exception e) {
                logger.error("Failed to reload DB for sorted shuffle files from: " + this.recoverFile, (Throwable)e);
                this.sortedFilesDb = null;
            }
        } else {
            this.sortedFilesDb = null;
        }
        this.fileSorterExecutors = ThreadUtils.newDaemonCachedThreadPool((String)"worker-file-sorter-executor", (int)conf.workerPartitionSorterThreads(), (int)120);
        this.indexCache = CacheBuilder.newBuilder().concurrencyLevel(conf.workerPartitionSorterThreads()).expireAfterAccess(conf.workerPartitionSorterIndexExpire(), TimeUnit.MILLISECONDS).maximumWeight(indexCacheMaxWeight).weigher((key, cache) -> ((Map)cache).values().stream().mapToInt(List::size).sum()).build();
        this.fileSorterSchedulerThread = ThreadUtils.newDaemonSingleThreadExecutor((String)"worker-file-sorter-scheduler");
        this.fileSorterSchedulerThread.submit(() -> {
            try {
                while (!this.shutdown) {
                    FileSorter task = this.shuffleSortTaskDeque.take();
                    if (task.isPrefetch) {
                        memoryManager.reserveSortMemory(this.reservedMemoryPerPartition);
                        while (!memoryManager.sortMemoryReady()) {
                            Thread.sleep(20L);
                        }
                    }
                    this.fileSorterExecutors.submit(() -> {
                        try {
                            task.sort();
                        }
                        finally {
                            if (task.isPrefetch) {
                                memoryManager.releaseSortMemory(this.reservedMemoryPerPartition);
                            }
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                logger.warn("Sort scheduler thread is shutting down, detail: ", (Throwable)e);
            }
        });
    }

    public int getSortingCount() {
        return this.shuffleSortTaskDeque.size();
    }

    public int getSortedCount() {
        return this.sortedFileCount.get();
    }

    public long getSortedSize() {
        return this.sortedFilesSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo getSortedFileInfo(String shuffleKey, String fileName, FileInfo fileInfo, int startMapIndex, int endMapIndex) throws IOException {
        if (fileInfo instanceof MemoryFileInfo) {
            MemoryFileInfo memoryFileInfo = (MemoryFileInfo)fileInfo;
            PartitionFilesSorter.sortMemoryShuffleFile(memoryFileInfo);
            Map indexesMap = memoryFileInfo.getSortedIndexes();
            ReduceFileMeta reduceFileMeta = new ReduceFileMeta(ShuffleBlockInfoUtils.getChunkOffsetsFromShuffleBlockInfos((int)startMapIndex, (int)endMapIndex, (long)this.shuffleChunkSize, (Map)indexesMap, (boolean)true), this.shuffleChunkSize);
            CompositeByteBuf targetBuffer = MemoryManager.instance().getStoragePooledByteBufAllocator().compositeBuffer(Integer.MAX_VALUE);
            ShuffleBlockInfoUtils.sliceSortedBufferByMapRange((int)startMapIndex, (int)endMapIndex, (Map)indexesMap, (CompositeByteBuf)memoryFileInfo.getSortedBuffer(), (CompositeByteBuf)targetBuffer);
            return new MemoryFileInfo(memoryFileInfo.getUserIdentifier(), memoryFileInfo.isPartitionSplitEnabled(), (FileMeta)reduceFileMeta, targetBuffer);
        }
        DiskFileInfo diskFileInfo = (DiskFileInfo)fileInfo;
        String fileId = shuffleKey + "-" + fileName;
        UserIdentifier userIdentifier = diskFileInfo.getUserIdentifier();
        Set sorted = this.sortedShuffleFiles.computeIfAbsent(shuffleKey, v -> ConcurrentHashMap.newKeySet());
        Set sorting = this.sortingShuffleFiles.computeIfAbsent(shuffleKey, v -> ConcurrentHashMap.newKeySet());
        String sortedFilePath = Utils.getSortedFilePath((String)diskFileInfo.getFilePath());
        String indexFilePath = Utils.getIndexFilePath((String)diskFileInfo.getFilePath());
        boolean fileSorting = true;
        Set set = sorting;
        synchronized (set) {
            if (sorted.contains(fileId)) {
                fileSorting = false;
            } else if (!sorting.contains(fileId)) {
                try {
                    FileSorter fileSorter = new FileSorter(diskFileInfo, fileId, shuffleKey);
                    sorting.add(fileId);
                    logger.debug("Adding sorter to sort queue shuffle key {}, file name {}", (Object)shuffleKey, (Object)fileName);
                    this.shuffleSortTaskDeque.put(fileSorter);
                }
                catch (InterruptedException e) {
                    logger.error("Sorter scheduler thread is interrupted means worker is shutting down.", (Throwable)e);
                    throw new IOException("Sort scheduler thread is interrupted means worker is shutting down.", e);
                }
                catch (IOException e) {
                    logger.error("File sorter access HDFS failed.", (Throwable)e);
                    throw new IOException("File sorter access HDFS failed.", e);
                }
            }
        }
        if (fileSorting) {
            long sortStartTime = System.currentTimeMillis();
            while (!sorted.contains(fileId)) {
                if (sorting.contains(fileId)) {
                    try {
                        Thread.sleep(50L);
                        if (System.currentTimeMillis() - sortStartTime <= this.sortTimeout) continue;
                        logger.error("Sorting file {} timeout after {}ms", (Object)fileId, (Object)this.sortTimeout);
                        throw new IOException("Sort file " + diskFileInfo.getFilePath() + " timeout after " + this.sortTimeout);
                    }
                    catch (InterruptedException e) {
                        logger.error("Sorter scheduler thread is interrupted means worker is shutting down.", (Throwable)e);
                        throw new IOException("Sorter scheduler thread is interrupted means worker is shutting down.", e);
                    }
                }
                logger.debug("Sorting shuffle file for {} {} failed.", (Object)shuffleKey, (Object)diskFileInfo.getFilePath());
                throw new IOException("Sorting shuffle file for " + shuffleKey + " " + diskFileInfo.getFilePath() + " failed.");
            }
        }
        return this.resolve(shuffleKey, fileId, userIdentifier, sortedFilePath, indexFilePath, startMapIndex, endMapIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sortMemoryShuffleFile(MemoryFileInfo memoryFileInfo) {
        ReduceFileMeta reduceFileMeta = (ReduceFileMeta)memoryFileInfo.getFileMeta();
        AtomicBoolean atomicBoolean = reduceFileMeta.getSorted();
        synchronized (atomicBoolean) {
            if (!reduceFileMeta.getSorted().get()) {
                int compressedSize;
                CompositeByteBuf originBuffer = memoryFileInfo.getBuffer();
                TreeMap<Integer, List> blocksMap = new TreeMap<Integer, List>();
                int originReaderIndex = originBuffer.readerIndex();
                int originWriterIndex = originBuffer.writerIndex();
                int bufLength = originBuffer.readableBytes();
                ByteBuffer headerBuf = ByteBuffer.allocate(16);
                for (int index = 0; index != bufLength; index += 16 + compressedSize) {
                    headerBuf.rewind();
                    originBuffer.readerIndex(index);
                    originBuffer.readBytes(headerBuf);
                    byte[] batchHeader = headerBuf.array();
                    int mapId = Platform.getInt((Object)batchHeader, (long)Platform.BYTE_ARRAY_OFFSET);
                    compressedSize = Platform.getInt((Object)batchHeader, (long)(Platform.BYTE_ARRAY_OFFSET + 12));
                    ShuffleBlockInfoUtils.ShuffleBlockInfo shuffleBlockInfo = new ShuffleBlockInfoUtils.ShuffleBlockInfo();
                    shuffleBlockInfo.offset = index;
                    shuffleBlockInfo.length = 16 + compressedSize;
                    List singleMapIdShuffleBlockList = blocksMap.computeIfAbsent(mapId, v -> new ArrayList());
                    singleMapIdShuffleBlockList.add(shuffleBlockInfo);
                }
                originBuffer.setIndex(originReaderIndex, originWriterIndex);
                CompositeByteBuf sortedBuffer = MemoryManager.instance().getStoragePooledByteBufAllocator().compositeBuffer(0x7FFFFFFE);
                TreeMap sortedBlocks = new TreeMap();
                int sortedBufferIndex = 0;
                for (Map.Entry entry : blocksMap.entrySet()) {
                    int mapId = (Integer)entry.getKey();
                    List blockInfos = (List)entry.getValue();
                    ArrayList<ShuffleBlockInfoUtils.ShuffleBlockInfo> sortedMapBlocks = new ArrayList<ShuffleBlockInfoUtils.ShuffleBlockInfo>(blockInfos.size());
                    sortedBlocks.put(mapId, sortedMapBlocks);
                    for (ShuffleBlockInfoUtils.ShuffleBlockInfo blockInfo : blockInfos) {
                        int offset = (int)blockInfo.offset;
                        int length = (int)blockInfo.length;
                        ByteBuf slice = originBuffer.slice(offset, length);
                        sortedBuffer.addComponent(true, slice);
                        ShuffleBlockInfoUtils.ShuffleBlockInfo shuffleBlockInfo = new ShuffleBlockInfoUtils.ShuffleBlockInfo();
                        shuffleBlockInfo.offset = sortedBufferIndex;
                        shuffleBlockInfo.length = blockInfo.length;
                        sortedBufferIndex += (int)blockInfo.length;
                        sortedMapBlocks.add(shuffleBlockInfo);
                    }
                }
                memoryFileInfo.setSortedBuffer(sortedBuffer);
                memoryFileInfo.setSortedIndexes(sortedBlocks);
                reduceFileMeta.setSorted();
            }
        }
    }

    public void cleanup(HashSet<String> expiredShuffleKeys) {
        for (String expiredShuffleKey : expiredShuffleKeys) {
            this.sortingShuffleFiles.remove(expiredShuffleKey);
            this.deleteSortedShuffleFiles(expiredShuffleKey);
            Set<String> expiredIndexCacheItems = this.indexCacheNames.remove(expiredShuffleKey);
            if (expiredIndexCacheItems == null) continue;
            for (String expiredIndexCacheItem : expiredIndexCacheItems) {
                this.indexCache.invalidate((Object)expiredIndexCacheItem);
            }
        }
    }

    public void close(int exitKind) {
        logger.info("Closing {}", (Object)this.getClass().getSimpleName());
        this.shutdown = true;
        if (exitKind == CelebornExitKind.WORKER_GRACEFUL_SHUTDOWN()) {
            long start = System.currentTimeMillis();
            try {
                this.fileSorterExecutors.shutdown();
                this.fileSorterExecutors.awaitTermination(this.partitionSorterShutdownAwaitTime, TimeUnit.MILLISECONDS);
                if (!this.fileSorterExecutors.isShutdown()) {
                    this.fileSorterExecutors.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                logger.error("Await partition sorter executor shutdown catch exception: ", (Throwable)e);
            }
            if (this.sortedFilesDb != null) {
                try {
                    this.updateSortedShuffleFilesInDB();
                    this.sortedFilesDb.close();
                }
                catch (IOException e) {
                    logger.error("Store recover data to DB failed.", (Throwable)e);
                }
            }
            long end = System.currentTimeMillis();
            logger.info("Await partition sorter executor complete cost {}ms", (Object)(end - start));
        } else {
            this.fileSorterSchedulerThread.shutdownNow();
            this.fileSorterExecutors.shutdownNow();
            this.cleaner.close();
            if (this.sortedFilesDb != null) {
                try {
                    this.sortedFilesDb.close();
                    this.recoverFile.delete();
                }
                catch (IOException e) {
                    logger.error("Clean DB failed.", (Throwable)e);
                }
            }
        }
        this.indexCache.invalidateAll();
    }

    private void reloadAndCleanSortedShuffleFiles(DB db) {
        if (db != null) {
            DBIterator itr = db.iterator();
            itr.seek(this.SHUFFLE_KEY_PREFIX.getBytes(StandardCharsets.UTF_8));
            while (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)itr.next();
                String key = new String((byte[])entry.getKey(), StandardCharsets.UTF_8);
                if (!key.startsWith(this.SHUFFLE_KEY_PREFIX)) continue;
                String shuffleKey = this.parseDbShuffleKey(key);
                try {
                    Set sortedFiles = PbSerDeUtils.fromPbSortedShuffleFileSet((byte[])((byte[])entry.getValue()));
                    logger.debug("Reload DB: {} -> {}", (Object)shuffleKey, (Object)sortedFiles);
                    this.sortedShuffleFiles.put(shuffleKey, sortedFiles);
                    this.sortedFilesDb.delete((byte[])entry.getKey());
                }
                catch (Exception exception) {
                    logger.error("Reload DB: {} failed.", (Object)shuffleKey, (Object)exception);
                }
            }
        }
    }

    @VisibleForTesting
    public void updateSortedShuffleFilesInDB() {
        for (String shuffleKey : this.sortedShuffleFiles.keySet()) {
            try {
                this.sortedFilesDb.put(this.dbShuffleKey(shuffleKey), PbSerDeUtils.toPbSortedShuffleFileSet(this.sortedShuffleFiles.get(shuffleKey)));
                logger.debug("Update DB: {} -> {}", (Object)shuffleKey, this.sortedShuffleFiles.get(shuffleKey));
            }
            catch (Exception exception) {
                logger.error("Update DB: {} failed.", (Object)shuffleKey, (Object)exception);
            }
        }
    }

    @VisibleForTesting
    public void initSortedShuffleFiles(String shuffleKey) {
        this.sortedShuffleFiles.computeIfAbsent(shuffleKey, v -> ConcurrentHashMap.newKeySet());
    }

    @VisibleForTesting
    public void updateSortedShuffleFiles(String shuffleKey, String fileId, long fileLength) {
        this.sortedShuffleFiles.get(shuffleKey).add(fileId);
        this.sortedFileCount.incrementAndGet();
        this.sortedFilesSize.addAndGet(fileLength);
    }

    @VisibleForTesting
    public void deleteSortedShuffleFiles(String expiredShuffleKey) {
        this.sortedShuffleFiles.remove(expiredShuffleKey);
    }

    @VisibleForTesting
    public Set<String> getSortedShuffleFiles(String shuffleKey) {
        return this.sortedShuffleFiles.get(shuffleKey);
    }

    protected void writeIndex(Map<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>> indexMap, String indexFilePath, boolean isHdfs) throws IOException {
        FSDataOutputStream hdfsIndexOutput = null;
        FileChannel indexFileChannel = null;
        if (isHdfs) {
            hdfsIndexOutput = StorageManager.hadoopFs().create(new Path(indexFilePath));
        } else {
            indexFileChannel = FileChannelUtils.createWritableFileChannel((String)indexFilePath);
        }
        int indexSize = 0;
        for (Map.Entry<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>> entry : indexMap.entrySet()) {
            indexSize += 8;
            indexSize += entry.getValue().size() * 16;
        }
        ByteBuffer indexBuf = ByteBuffer.allocate(indexSize);
        for (Map.Entry<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>> entry : indexMap.entrySet()) {
            int mapId = entry.getKey();
            List<ShuffleBlockInfoUtils.ShuffleBlockInfo> list = entry.getValue();
            indexBuf.putInt(mapId);
            indexBuf.putInt(list.size());
            list.forEach(info -> {
                indexBuf.putLong(info.offset);
                indexBuf.putLong(info.length);
            });
        }
        indexBuf.flip();
        if (isHdfs) {
            byte[] byArray = new byte[indexSize];
            indexBuf.get(byArray);
            hdfsIndexOutput.write(byArray);
            hdfsIndexOutput.close();
        } else {
            while (indexBuf.hasRemaining()) {
                indexFileChannel.write(indexBuf);
            }
            indexFileChannel.close();
        }
    }

    protected void readStreamFully(FSDataInputStream stream, ByteBuffer buffer, String path) throws IOException {
        while (buffer.hasRemaining()) {
            if (-1 != stream.read(buffer)) continue;
            throw new IOException("Unexpected EOF, file name : " + path + " position :" + stream.getPos() + " buffer size :" + buffer.limit());
        }
    }

    protected void readChannelFully(FileChannel channel, ByteBuffer buffer, String path) throws IOException {
        while (buffer.hasRemaining()) {
            if (-1 != channel.read(buffer)) continue;
            throw new IOException("Unexpected EOF, file name : " + path + " position :" + channel.position() + " buffer size :" + buffer.limit());
        }
    }

    private long transferStreamFully(FSDataInputStream origin, FSDataOutputStream sorted, long offset, long length) throws IOException {
        byte[] buffer = new byte[Math.toIntExact(length)];
        origin.readFully(offset, buffer);
        sorted.write(buffer);
        return length;
    }

    private long transferChannelFully(FileChannel originChannel, FileChannel targetChannel, long offset, long length) throws IOException {
        long transferredSize;
        for (transferredSize = 0L; transferredSize != length; transferredSize += originChannel.transferTo(offset + transferredSize, length - transferredSize, targetChannel)) {
        }
        return transferredSize;
    }

    public DiskFileInfo resolve(String shuffleKey, String fileId, UserIdentifier userIdentifier, String sortedFilePath, String indexFilePath, int startMapIndex, int endMapIndex) throws IOException {
        Map indexMap;
        try {
            indexMap = (Map)this.indexCache.get((Object)fileId, () -> {
                Map map;
                FileChannel indexChannel = null;
                FSDataInputStream hdfsIndexStream = null;
                boolean isHdfs = Utils.isHdfsPath((String)indexFilePath);
                try {
                    int indexSize;
                    if (isHdfs) {
                        hdfsIndexStream = StorageManager.hadoopFs().open(new Path(indexFilePath));
                        indexSize = (int)StorageManager.hadoopFs().getFileStatus(new Path(indexFilePath)).getLen();
                    } else {
                        indexChannel = FileChannelUtils.openReadableFileChannel((String)indexFilePath);
                        File indexFile = new File(indexFilePath);
                        indexSize = (int)indexFile.length();
                    }
                    ByteBuffer indexBuf = ByteBuffer.allocate(indexSize);
                    if (isHdfs) {
                        this.readStreamFully(hdfsIndexStream, indexBuf, indexFilePath);
                    } else {
                        this.readChannelFully(indexChannel, indexBuf, indexFilePath);
                    }
                    indexBuf.rewind();
                    Map tIndexMap = ShuffleBlockInfoUtils.parseShuffleBlockInfosFromByteBuffer((ByteBuffer)indexBuf);
                    Set indexCacheItemsSet = this.indexCacheNames.computeIfAbsent(shuffleKey, v -> new HashSet());
                    indexCacheItemsSet.add(fileId);
                    map = tIndexMap;
                }
                catch (Exception e) {
                    try {
                        logger.error("Read sorted shuffle file index " + indexFilePath + " error, detail: ", (Throwable)e);
                        throw new IOException("Read sorted shuffle file index failed.", e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly((Closeable)indexChannel, null);
                        IOUtils.closeQuietly(hdfsIndexStream, null);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)indexChannel, null);
                IOUtils.closeQuietly((Closeable)hdfsIndexStream, null);
                return map;
            });
        }
        catch (ExecutionException e) {
            throw new IOException("Read sorted shuffle file index failed.", e);
        }
        ReduceFileMeta reduceFileMeta = new ReduceFileMeta(ShuffleBlockInfoUtils.getChunkOffsetsFromShuffleBlockInfos((int)startMapIndex, (int)endMapIndex, (long)this.shuffleChunkSize, (Map)indexMap, (boolean)false), this.shuffleChunkSize);
        return new DiskFileInfo(userIdentifier, (FileMeta)reduceFileMeta, sortedFilePath);
    }

    public void cleanupExpiredShuffleKey(Set<String> expiredShuffleKeys) {
        this.cleaner.cleanupExpiredShuffleKey(expiredShuffleKeys);
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    class FileSorter {
        private final String originFilePath;
        private final String sortedFilePath;
        private final String indexFilePath;
        private final long originFileLen;
        private final String fileId;
        private final String shuffleKey;
        private final boolean isHdfs;
        private final boolean isPrefetch;
        private final FileInfo originFileInfo;
        private FSDataInputStream hdfsOriginInput = null;
        private FSDataOutputStream hdfsSortedOutput = null;
        private FileChannel originFileChannel = null;
        private FileChannel sortedFileChannel = null;

        FileSorter(DiskFileInfo fileInfo, String fileId, String shuffleKey) throws IOException {
            this.originFileInfo = fileInfo;
            this.originFilePath = fileInfo.getFilePath();
            this.sortedFilePath = Utils.getSortedFilePath((String)this.originFilePath);
            this.isHdfs = fileInfo.isHdfs();
            this.isPrefetch = !this.isHdfs && PartitionFilesSorter.this.prefetchEnabled;
            this.originFileLen = fileInfo.getFileLength();
            this.fileId = fileId;
            this.shuffleKey = shuffleKey;
            this.indexFilePath = Utils.getIndexFilePath((String)this.originFilePath);
            if (!this.isHdfs) {
                File indexFile;
                File sortedFile = new File(this.sortedFilePath);
                if (sortedFile.exists()) {
                    sortedFile.delete();
                }
                if ((indexFile = new File(this.indexFilePath)).exists()) {
                    indexFile.delete();
                }
            } else {
                if (StorageManager.hadoopFs().exists(fileInfo.getHdfsSortedPath())) {
                    StorageManager.hadoopFs().delete(fileInfo.getHdfsSortedPath(), false);
                }
                if (StorageManager.hadoopFs().exists(fileInfo.getHdfsIndexPath())) {
                    StorageManager.hadoopFs().delete(fileInfo.getHdfsIndexPath(), false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sort() {
            PartitionFilesSorter.this.source.startTimer(WorkerSource.SORT_TIME(), this.fileId);
            try {
                int compressedSize;
                this.initializeFiles();
                TreeMap<Integer, List> originShuffleBlockInfos = new TreeMap<Integer, List>();
                HashMap<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>> sortedBlockInfoMap = new HashMap<Integer, List<ShuffleBlockInfoUtils.ShuffleBlockInfo>>();
                int batchHeaderLen = 16;
                ByteBuffer headerBuf = ByteBuffer.allocate(batchHeaderLen);
                ByteBuffer paddingBuf = this.isPrefetch ? ByteBuffer.allocateDirect((int)PartitionFilesSorter.this.reservedMemoryPerPartition) : null;
                for (long index = 0L; index != this.originFileLen; index += (long)(batchHeaderLen + compressedSize)) {
                    long blockStartIndex = index;
                    this.readBufferFully(headerBuf);
                    byte[] batchHeader = headerBuf.array();
                    headerBuf.rewind();
                    int mapId = Platform.getInt((Object)batchHeader, (long)Platform.BYTE_ARRAY_OFFSET);
                    compressedSize = Platform.getInt((Object)batchHeader, (long)(Platform.BYTE_ARRAY_OFFSET + 12));
                    List singleMapIdShuffleBlockList = originShuffleBlockInfos.computeIfAbsent(mapId, v -> new ArrayList());
                    ShuffleBlockInfoUtils.ShuffleBlockInfo blockInfo = new ShuffleBlockInfoUtils.ShuffleBlockInfo();
                    blockInfo.offset = blockStartIndex;
                    blockInfo.length = (long)compressedSize + 16L;
                    singleMapIdShuffleBlockList.add(blockInfo);
                    this.readBufferBySize(paddingBuf, compressedSize);
                }
                long fileIndex = 0L;
                for (Map.Entry originBlockInfoEntry : originShuffleBlockInfos.entrySet()) {
                    int mapId = (Integer)originBlockInfoEntry.getKey();
                    List originShuffleBlocks = (List)originBlockInfoEntry.getValue();
                    ArrayList<ShuffleBlockInfoUtils.ShuffleBlockInfo> sortedShuffleBlocks = new ArrayList<ShuffleBlockInfoUtils.ShuffleBlockInfo>();
                    for (ShuffleBlockInfoUtils.ShuffleBlockInfo blockInfo : originShuffleBlocks) {
                        long offset = blockInfo.offset;
                        long length = blockInfo.length;
                        boolean shuffleBlockCompacted = false;
                        if (!sortedShuffleBlocks.isEmpty()) {
                            ShuffleBlockInfoUtils.ShuffleBlockInfo lastShuffleBlock = (ShuffleBlockInfoUtils.ShuffleBlockInfo)sortedShuffleBlocks.get(sortedShuffleBlocks.size() - 1);
                            if ((double)(lastShuffleBlock.length + length) <= PartitionFilesSorter.this.compactionFactor * (double)PartitionFilesSorter.this.shuffleChunkSize) {
                                lastShuffleBlock.length += length;
                                shuffleBlockCompacted = true;
                            }
                        }
                        if (!shuffleBlockCompacted) {
                            ShuffleBlockInfoUtils.ShuffleBlockInfo sortedBlock = new ShuffleBlockInfoUtils.ShuffleBlockInfo();
                            sortedBlock.offset = fileIndex;
                            sortedBlock.length = length;
                            sortedShuffleBlocks.add(sortedBlock);
                        }
                        fileIndex += this.transferBlock(offset, length);
                    }
                    sortedBlockInfoMap.put(mapId, sortedShuffleBlocks);
                }
                PartitionFilesSorter.this.writeIndex(sortedBlockInfoMap, this.indexFilePath, this.isHdfs);
                PartitionFilesSorter.this.updateSortedShuffleFiles(this.shuffleKey, this.fileId, this.originFileLen);
                this.originFileInfo.getReduceFileMeta().setSorted();
                PartitionFilesSorter.this.cleaner.add(this);
                logger.debug("sort complete for {} {}", (Object)this.shuffleKey, (Object)this.originFilePath);
            }
            catch (Exception e) {
                logger.error("Sorting shuffle file for " + this.fileId + " " + this.originFilePath + " failed, detail: ", (Throwable)e);
            }
            finally {
                Set sorting;
                this.closeFiles();
                Set set = sorting = (Set)PartitionFilesSorter.this.sortingShuffleFiles.get(this.shuffleKey);
                synchronized (set) {
                    sorting.remove(this.fileId);
                }
            }
            PartitionFilesSorter.this.source.stopTimer(WorkerSource.SORT_TIME(), this.fileId);
        }

        public String getShuffleKey() {
            return this.shuffleKey;
        }

        public FileInfo getOriginFileInfo() {
            return this.originFileInfo;
        }

        private void initializeFiles() throws IOException {
            if (this.isHdfs) {
                this.hdfsOriginInput = StorageManager.hadoopFs().open(new Path(this.originFilePath));
                this.hdfsSortedOutput = StorageManager.hadoopFs().create(new Path(this.sortedFilePath), true, 262144);
            } else {
                this.originFileChannel = FileChannelUtils.openReadableFileChannel((String)this.originFilePath);
                this.sortedFileChannel = FileChannelUtils.createWritableFileChannel((String)this.sortedFilePath);
            }
        }

        private void closeFiles() {
            IOUtils.closeQuietly((Closeable)this.hdfsOriginInput, null);
            IOUtils.closeQuietly((Closeable)this.hdfsSortedOutput, null);
            IOUtils.closeQuietly((Closeable)this.originFileChannel, null);
            IOUtils.closeQuietly((Closeable)this.sortedFileChannel, null);
        }

        private void readBufferFully(ByteBuffer buffer) throws IOException {
            if (this.isHdfs) {
                PartitionFilesSorter.this.readStreamFully(this.hdfsOriginInput, buffer, this.originFilePath);
            } else {
                PartitionFilesSorter.this.readChannelFully(this.originFileChannel, buffer, this.originFilePath);
            }
        }

        private long transferBlock(long offset, long length) throws IOException {
            if (this.isHdfs) {
                return PartitionFilesSorter.this.transferStreamFully(this.hdfsOriginInput, this.hdfsSortedOutput, offset, length);
            }
            return PartitionFilesSorter.this.transferChannelFully(this.originFileChannel, this.sortedFileChannel, offset, length);
        }

        public void deleteOriginFiles() throws IOException {
            boolean deleteSuccess = this.isHdfs ? StorageManager.hadoopFs().delete(new Path(this.originFilePath), false) : new File(this.originFilePath).delete();
            if (!deleteSuccess) {
                logger.warn("Clean origin file failed, origin file is : {}", (Object)this.originFilePath);
            }
        }

        protected void readChannelBySize(FileChannel channel, ByteBuffer buffer, String path, int toRead) throws IOException {
            int read = 0;
            if (toRead < buffer.capacity()) {
                buffer.limit(toRead);
            }
            while (read != toRead) {
                int tmpRead = channel.read(buffer);
                if (-1 == tmpRead) {
                    throw new IOException("Unexpected EOF, file name : " + path + " position :" + channel.position() + " read size :" + read);
                }
                read += tmpRead;
                if (buffer.hasRemaining()) continue;
                buffer.clear();
                if (toRead - read >= buffer.capacity()) continue;
                buffer.limit(toRead - read);
            }
        }

        private void readBufferBySize(ByteBuffer buffer, int toRead) throws IOException {
            if (this.isHdfs) {
                this.hdfsOriginInput.seek((long)toRead + this.hdfsOriginInput.getPos());
            } else if (PartitionFilesSorter.this.prefetchEnabled) {
                buffer.clear();
                this.readChannelBySize(this.originFileChannel, buffer, this.originFilePath, toRead);
            } else {
                this.originFileChannel.position((long)toRead + this.originFileChannel.position());
            }
        }
    }
}

