/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import java.util.zip.Checksum;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.Crc16;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.function.Uncheck;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class Crc16Test {
    private static final String BIG_TEXT = (String)Uncheck.get(() -> PathUtils.readString((Path)Paths.get("LICENSE.txt", new String[0]), (Charset)StandardCharsets.US_ASCII));
    private static final byte[] TEST_BYTES = "123456789".getBytes(StandardCharsets.US_ASCII);
    private static final int TEST_BYTES_LEN = TEST_BYTES.length;

    Crc16Test() {
    }

    static Object[][] testArcDefault() {
        return new Object[][]{{"", 0}, {"1", 54465}, {"12", 17812}, {"123", 47620}, {"1234", 5306}, {"12345", 42069}, {"123456", 10724}, {"1234567", 40296}, {"12345678", 15517}, {"123456789", 47933}, {BIG_TEXT, 53276}};
    }

    static Object[][] testCcittDefault() {
        return new Object[][]{{"", 0}, {"1", 8202}, {"12", 48619}, {"123", 23160}, {"1234", 34866}, {"12345", 29751}, {"123456", 4605}, {"1234567", 26951}, {"12345678", 35609}, {"123456789", 8585}, {BIG_TEXT, 43282}};
    }

    static Object[][] testDnpDefault() {
        return new Object[][]{{"", 65535}, {"1", 21093}, {"12", 36808}, {"123", 9975}, {"1234", 16915}, {"12345", 28956}, {"123456", 22494}, {"1234567", 63736}, {"12345678", 6191}, {"123456789", 60034}, {BIG_TEXT, 32307}};
    }

    static Supplier<int[]>[] testGetTables() {
        return new Supplier[]{Crc16::getArcTable, Crc16::getCcittTable, Crc16::getDnpTable, Crc16::getMcrf4xxTable, Crc16::getMaximTable, Crc16::getModbusTable, Crc16::getNrsc5Table};
    }

    static Object[][] testIbmSdlcDefault() {
        return new Object[][]{{"", 0}, {"1", 53362}, {"12", 45740}, {"123", 40116}, {"1234", 29932}, {"12345", 47936}, {"123456", 58994}, {"1234567", 58679}, {"12345678", 2154}, {"123456789", 36974}, {BIG_TEXT, 27711}};
    }

    static Object[][] testMaximDefault() {
        return new Object[][]{{"", 65535}, {"1", 11070}, {"12", 47723}, {"123", 17915}, {"1234", 60229}, {"12345", 23466}, {"123456", 54811}, {"1234567", 25239}, {"12345678", 50018}, {"123456789", 17602}, {BIG_TEXT, 12259}};
    }

    static Object[][] testMcrf4xxDefault() {
        return new Object[][]{{"", 65535}, {"1", 12173}, {"12", 19795}, {"123", 25419}, {"1234", 35603}, {"12345", 17599}, {"123456", 6541}, {"1234567", 6856}, {"12345678", 63381}, {"123456789", 28561}, {BIG_TEXT, 37824}};
    }

    static Object[][] testModbusDefault() {
        return new Object[][]{{"", 65535}, {"1", 38014}, {"12", 62869}, {"123", 31349}, {"1234", 12474}, {"12345", 42097}, {"123456", 13028}, {"1234567", 40307}, {"12345678", 14301}, {"123456789", 19255}, {BIG_TEXT, 60519}};
    }

    static Object[][] testNrsc5Default() {
        return new Object[][]{{"", 65535}, {"1", 2110}, {"12", 56217}, {"123", 33414}, {"1234", 38364}, {"12345", 46124}, {"123456", 31999}, {"1234567", 46437}, {"12345678", 40074}, {"123456789", 41062}, {BIG_TEXT, 10884}};
    }

    static Object[][] testUsbDefault() {
        return new Object[][]{{"", 0}, {"1", 27521}, {"12", 2666}, {"123", 34186}, {"1234", 53061}, {"12345", 23438}, {"123456", 52507}, {"1234567", 25228}, {"12345678", 51234}, {"123456789", 46280}, {BIG_TEXT, 5016}};
    }

    private Supplier<String> messageSupplier(Checksum crc16, long expected) {
        return () -> String.format("Expected %04X but was %s", expected, crc16);
    }

    void stdUpdate(Checksum crc16) {
        crc16.update(TEST_BYTES, 0, TEST_BYTES_LEN);
    }

    @ParameterizedTest
    @MethodSource
    void testArcDefault(String source, long expected) {
        this.testUpdateReset(source, expected, (Checksum)Crc16.arc());
    }

    @ParameterizedTest
    @MethodSource
    void testCcittDefault(String source, long expected) {
        this.testUpdateReset(source, expected, (Checksum)Crc16.ccitt());
    }

    @ParameterizedTest
    @MethodSource
    void testDnpDefault(String source, long expected) {
        this.testUpdateReset(source, expected, (Checksum)Crc16.dnp());
    }

    @ParameterizedTest
    @MethodSource
    void testGetTables(Supplier<int[]> supplier) {
        int[] value1 = supplier.get();
        int[] value2 = supplier.get();
        Assertions.assertNotSame((Object)value1, (Object)value2);
        Assertions.assertArrayEquals((int[])value1, (int[])value2);
    }

    @ParameterizedTest
    @MethodSource
    void testIbmSdlcDefault(String source, long expected) {
        this.testUpdateReset(source, expected, (Checksum)Crc16.ibmSdlc());
    }

    @Test
    void testInit() {
        Crc16 crc16 = Crc16.builder().setTable(Crc16.getModbusTable()).setInit(65535).get();
        this.stdUpdate((Checksum)crc16);
        Assertions.assertEquals((long)19255L, (long)crc16.getValue());
        this.stdUpdate((Checksum)crc16);
        Assertions.assertEquals((long)2314L, (long)crc16.getValue());
        crc16.reset();
        this.stdUpdate((Checksum)crc16);
        Assertions.assertEquals((long)19255L, (long)crc16.getValue());
    }

    @ParameterizedTest
    @MethodSource
    void testMaximDefault(String source, long expected) {
        this.testUpdateReset(source, expected, (Checksum)Crc16.maxim());
    }

    @ParameterizedTest
    @MethodSource
    void testMcrf4xxDefault(String source, long expected) {
        this.testUpdateReset(source, expected, (Checksum)Crc16.mcrf4xx());
    }

    @Test
    void testModbusCustom() {
        Crc16 crc16 = Crc16.builder().setTable(Crc16.getModbusTable()).setInit(65535).get();
        this.stdUpdate((Checksum)crc16);
        Assertions.assertEquals((long)19255L, (long)crc16.getValue());
        this.stdUpdate((Checksum)crc16);
        Assertions.assertEquals((long)2314L, (long)crc16.getValue());
        crc16.reset();
        this.stdUpdate((Checksum)crc16);
        Assertions.assertEquals((long)19255L, (long)crc16.getValue());
    }

    @ParameterizedTest
    @MethodSource
    void testModbusDefault(String source, long expected) {
        this.testUpdateReset(source, expected, (Checksum)Crc16.modbus());
    }

    @ParameterizedTest
    @MethodSource
    void testNrsc5Default(String source, long expected) {
        this.testUpdateReset(source, expected, (Checksum)Crc16.nrsc5());
    }

    @Test
    void testReset() {
        Crc16 crc16 = Crc16.modbus();
        this.stdUpdate((Checksum)crc16);
        Assertions.assertEquals((long)19255L, (long)crc16.getValue());
        this.stdUpdate((Checksum)crc16);
        Assertions.assertEquals((long)2314L, (long)crc16.getValue());
        crc16.reset();
        this.stdUpdate((Checksum)crc16);
        Assertions.assertEquals((long)19255L, (long)crc16.getValue());
    }

    @Test
    void testResetCustomModbus() {
        Crc16 crc16 = Crc16.builder().setTable(Crc16.getModbusTable()).setInit(0).get();
        this.stdUpdate((Checksum)crc16);
        Assertions.assertEquals((long)47933L, (long)crc16.getValue());
        this.stdUpdate((Checksum)crc16);
        Assertions.assertEquals((long)60795L, (long)crc16.getValue());
        crc16.reset();
        this.stdUpdate((Checksum)crc16);
        Assertions.assertEquals((long)47933L, (long)crc16.getValue());
    }

    @Test
    void testUpdateArray() {
        Crc16 crc16 = Crc16.builder().setTable(Crc16.getModbusTable()).setInit(0).get();
        this.stdUpdate((Checksum)crc16);
        Assertions.assertEquals((long)47933L, (long)crc16.getValue());
    }

    @Test
    void testUpdateInt() {
        byte[] bytes;
        Crc16 crc16 = Crc16.builder().setTable(Crc16.getModbusTable()).setInit(0).get();
        for (byte element : bytes = TEST_BYTES) {
            crc16.update(element);
        }
        Assertions.assertEquals((long)47933L, (long)crc16.getValue());
    }

    void testUpdateReset(String source, long expected, Checksum crc16) {
        byte[] bytes = StringUtils.getBytesUsAscii((String)source);
        crc16.update(bytes, 0, bytes.length);
        long actual = crc16.getValue();
        Assertions.assertEquals((long)expected, (long)actual, this.messageSupplier(crc16, expected));
        crc16.reset();
        crc16.update(bytes, 0, bytes.length);
        actual = crc16.getValue();
        Assertions.assertEquals((long)expected, (long)actual, this.messageSupplier(crc16, expected));
    }

    @ParameterizedTest
    @MethodSource
    void testUsbDefault(String source, long expected) {
        this.testUpdateReset(source, expected, (Checksum)Crc16.usb());
    }
}

