/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.examples;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.stream.Stream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.examples.Archiver;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ParameterizedArchiverTest
extends AbstractTest {
    private File target;

    ParameterizedArchiverTest() {
    }

    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{"tar"}), Arguments.of((Object[])new Object[]{"cpio"}), Arguments.of((Object[])new Object[]{"zip"}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void archiveStreamVersion(String format) throws Exception {
        this.setUp(format);
        try (OutputStream os = Files.newOutputStream(this.target.toPath(), new OpenOption[0]);
             ArchiveOutputStream aos = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream(format, os);){
            new Archiver().create(aos, this.getTempDirFile());
        }
        this.verifyContent(format);
    }

    private void assertDir(String expectedName, ArchiveEntry entry) {
        Assertions.assertNotNull((Object)entry, () -> expectedName + " does not exists");
        Assertions.assertEquals((Object)(expectedName + "/"), (Object)entry.getName());
        Assertions.assertTrue((boolean)entry.isDirectory(), (String)(expectedName + " is not a directory"));
    }

    private void assertHelloWorld(String expectedName, String suffix, ArchiveEntry entry, InputStream is) throws IOException {
        Assertions.assertNotNull((Object)entry, () -> expectedName + " does not exists");
        Assertions.assertEquals((Object)expectedName, (Object)entry.getName());
        Assertions.assertFalse((boolean)entry.isDirectory(), (String)(expectedName + " is a directory"));
        byte[] expected = ("Hello, world " + suffix).getBytes(StandardCharsets.UTF_8);
        byte[] actual = IOUtils.toByteArray((InputStream)is);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void channelVersion(String format) throws Exception {
        this.setUp(format);
        try (FileChannel c = FileChannel.open(this.target.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            new Archiver().create(format, (SeekableByteChannel)c, this.getTempDirFile());
        }
        this.verifyContent(format);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void fileVersion(String format) throws Exception {
        this.setUp(format);
        new Archiver().create(format, this.target, this.getTempDirFile());
        this.verifyContent(format);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void outputStreamVersion(String format) throws Exception {
        this.setUp(format);
        try (OutputStream os = Files.newOutputStream(this.target.toPath(), new OpenOption[0]);){
            new Archiver().create(format, os, this.getTempDirFile());
        }
        this.verifyContent(format);
    }

    public void setUp(String format) throws Exception {
        File c = this.newTempFile("a/b/c");
        c.mkdirs();
        try (OutputStream os = Files.newOutputStream(this.newTempFile("a/b/d.txt").toPath(), new OpenOption[0]);){
            os.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
        }
        os = Files.newOutputStream(this.newTempFile("a/b/c/e.txt").toPath(), new OpenOption[0]);
        try {
            os.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        this.target = new File(this.tempResultDir, "test." + format);
    }

    private void verifyContent(String format) throws IOException, ArchiveException {
        try (InputStream is = Files.newInputStream(this.target.toPath(), new OpenOption[0]);
             BufferedInputStream bis = new BufferedInputStream(is);
             ArchiveInputStream ais = ArchiveStreamFactory.DEFAULT.createArchiveInputStream(format, (InputStream)bis);){
            this.assertDir("a", ais.getNextEntry());
            this.assertDir("a/b", ais.getNextEntry());
            ArchiveEntry n = ais.getNextEntry();
            Assertions.assertNotNull((Object)n);
            if (n.getName().endsWith("/")) {
                this.assertDir("a/b/c", n);
                this.assertHelloWorld("a/b/c/e.txt", "2", ais.getNextEntry(), (InputStream)ais);
                this.assertHelloWorld("a/b/d.txt", "1", ais.getNextEntry(), (InputStream)ais);
            } else {
                this.assertHelloWorld("a/b/d.txt", "1", n, (InputStream)ais);
                this.assertDir("a/b/c", ais.getNextEntry());
                this.assertHelloWorld("a/b/c/e.txt", "2", ais.getNextEntry(), (InputStream)ais);
            }
        }
    }
}

