/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.DynamicCombinedConfiguration;
import org.apache.commons.configuration.MultiFileHierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.lang.text.StrLookup;
import org.junit.Assert;
import org.junit.Test;

public class TestDynamicCombinedConfiguration {
    private static String PATTERN = "${sys:Id}";
    private static String PATTERN1 = "target/test-classes/testMultiConfiguration_${sys:Id}.xml";
    private static String DEFAULT_FILE = "target/test-classes/testMultiConfiguration_default.xml";
    private static final File MULTI_TENENT_FILE = new File("conf/testMultiTenentConfigurationBuilder4.xml");
    private static final File MULTI_DYNAMIC_FILE = new File("conf/testMultiTenentConfigurationBuilder5.xml");
    private static final int THREAD_COUNT = 3;
    private static final int LOOP_COUNT = 100;

    @Test
    public void testConfiguration() throws Exception {
        DynamicCombinedConfiguration config = new DynamicCombinedConfiguration();
        XPathExpressionEngine engine = new XPathExpressionEngine();
        config.setExpressionEngine((ExpressionEngine)engine);
        config.setKeyPattern(PATTERN);
        config.setDelimiterParsingDisabled(true);
        MultiFileHierarchicalConfiguration multi = new MultiFileHierarchicalConfiguration(PATTERN1);
        multi.setExpressionEngine((ExpressionEngine)engine);
        config.addConfiguration((AbstractConfiguration)multi, "Multi");
        XMLConfiguration xml = new XMLConfiguration();
        xml.setExpressionEngine((ExpressionEngine)engine);
        xml.setDelimiterParsingDisabled(true);
        xml.setFile(new File(DEFAULT_FILE));
        xml.load();
        config.addConfiguration((AbstractConfiguration)xml, "Default");
        this.verify("1001", config, 15);
        this.verify("1002", config, 25);
        this.verify("1003", config, 35);
        this.verify("1004", config, 50);
        Assert.assertEquals((Object)"a,b,c", (Object)config.getString("split/list3/@values"));
        Assert.assertEquals((long)0L, (long)config.getMaxIndex("split/list3/@values"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)config.getString("split/list4/@values"));
        Assert.assertEquals((Object)"a,b,c", (Object)config.getString("split/list1"));
        Assert.assertEquals((long)0L, (long)config.getMaxIndex("split/list1"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)config.getString("split/list2"));
    }

    @Test
    public void testConcurrentGetAndReload() throws Exception {
        System.getProperties().remove("Id");
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder();
        factory.setFile(MULTI_TENENT_FILE);
        CombinedConfiguration config = factory.getConfiguration(true);
        Assert.assertEquals((Object)config.getString("rowsPerPage"), (Object)"50");
        Thread[] testThreads = new Thread[3];
        int[] failures = new int[3];
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new ReloadThread(config, failures, i, 100, false, null, "50");
            testThreads[i].start();
        }
        int totalFailures = 0;
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i].join();
            totalFailures += failures[i];
        }
        Assert.assertTrue((String)(totalFailures + " failures Occurred"), (totalFailures == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentGetAndReload2() throws Exception {
        System.getProperties().remove("Id");
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder();
        factory.setFile(MULTI_TENENT_FILE);
        CombinedConfiguration config = factory.getConfiguration(true);
        Assert.assertEquals((Object)config.getString("rowsPerPage"), (Object)"50");
        Thread[] testThreads = new Thread[3];
        int[] failures = new int[3];
        System.setProperty("Id", "2002");
        Assert.assertEquals((Object)config.getString("rowsPerPage"), (Object)"25");
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new ReloadThread(config, failures, i, 100, false, null, "25");
            testThreads[i].start();
        }
        int totalFailures = 0;
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i].join();
            totalFailures += failures[i];
        }
        System.getProperties().remove("Id");
        Assert.assertTrue((String)(totalFailures + " failures Occurred"), (totalFailures == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentGetAndReloadMultipleClients() throws Exception {
        int i;
        System.getProperties().remove("Id");
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder();
        factory.setFile(MULTI_TENENT_FILE);
        CombinedConfiguration config = factory.getConfiguration(true);
        Assert.assertEquals((Object)config.getString("rowsPerPage"), (Object)"50");
        Thread[] testThreads = new Thread[3];
        int[] failures = new int[3];
        String[] ids = new String[]{null, "2002", "3001", "3002", "3003"};
        String[] expected = new String[]{"50", "25", "15", "25", "50"};
        for (int i2 = 0; i2 < testThreads.length; ++i2) {
            testThreads[i2] = new ReloadThread(config, failures, i2, 100, true, ids[i2], expected[i2]);
            testThreads[i2].start();
        }
        int totalFailures = 0;
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].join();
            totalFailures += failures[i];
        }
        System.getProperties().remove("Id");
        if (totalFailures != 0) {
            System.out.println("Failures:");
            for (i = 0; i < testThreads.length; ++i) {
                System.out.println("Thread " + i + " " + failures[i]);
            }
        }
        Assert.assertTrue((String)(totalFailures + " failures Occurred"), (totalFailures == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentGetAndReloadFile() throws Exception {
        int i;
        int threadCount = 25;
        System.getProperties().remove("Id");
        File input = new File("target/test-classes/testMultiDynamic_default.xml");
        File output = new File("target/test-classes/testwrite/testMultiDynamic_default.xml");
        output.delete();
        output.getParentFile().mkdir();
        this.copyFile(input, output);
        DefaultConfigurationBuilder factory = new DefaultConfigurationBuilder();
        factory.setFile(MULTI_DYNAMIC_FILE);
        CombinedConfiguration config = factory.getConfiguration(true);
        Assert.assertEquals((Object)config.getString("Product/FIIndex/FI[@id='123456781']"), (Object)"ID0001");
        ReaderThread[] testThreads = new ReaderThread[25];
        for (int i2 = 0; i2 < testThreads.length; ++i2) {
            testThreads[i2] = new ReaderThread(config);
            testThreads[i2].start();
        }
        Thread.sleep(2000L);
        input = new File("target/test-classes/testMultiDynamic_default2.xml");
        this.copyFile(input, output);
        Thread.sleep(2000L);
        String id = config.getString("Product/FIIndex/FI[@id='123456782']");
        Assert.assertNotNull((String)"File did not reload, id is null", (Object)id);
        String rows = config.getString("rowsPerPage");
        Assert.assertTrue((String)"Incorrect value for rowsPerPage", (boolean)"25".equals(rows));
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].shutdown();
            testThreads[i].join();
        }
        for (i = 0; i < testThreads.length; ++i) {
            Assert.assertFalse((boolean)testThreads[i].failed());
        }
        Assert.assertEquals((Object)"ID0002", (Object)config.getString("Product/FIIndex/FI[@id='123456782']"));
        output.delete();
    }

    private void verify(String key, DynamicCombinedConfiguration config, int rows) {
        System.setProperty("Id", key);
        Assert.assertTrue((config.getInt("rowsPerPage") == rows ? 1 : 0) != 0);
    }

    private void copyFile(File input, File output) throws IOException {
        FileReader reader = new FileReader(input);
        FileWriter writer = new FileWriter(output);
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = reader.read(buffer))) {
            ((Writer)writer).write(buffer, 0, n);
        }
        ((Reader)reader).close();
        ((Writer)writer).close();
    }

    public static class ThreadLookup
    extends StrLookup {
        private static ThreadLocal<String> id = new ThreadLocal();

        public static void setId(String value) {
            id.set(value);
        }

        public String lookup(String key) {
            if (key == null || !key.equals("Id")) {
                return null;
            }
            String value = System.getProperty("Id");
            if (value != null) {
                return value;
            }
            return id.get();
        }
    }

    private class ReaderThread
    extends Thread {
        private boolean running = true;
        private boolean failed = false;
        CombinedConfiguration combined;

        public ReaderThread(CombinedConfiguration c) {
            this.combined = c;
        }

        public void run() {
            while (this.running) {
                String bcId = this.combined.getString("Product/FIIndex/FI[@id='123456781']");
                if ("ID0001".equalsIgnoreCase(bcId)) {
                    if (this.failed) {
                        System.out.println("Thread failed, but recovered");
                    }
                    this.failed = false;
                    continue;
                }
                this.failed = true;
            }
        }

        public boolean failed() {
            return this.failed;
        }

        public void shutdown() {
            this.running = false;
        }
    }

    private class ReloadThread
    extends Thread {
        CombinedConfiguration combined;
        int[] failures;
        int index;
        int count;
        String expected;
        String id;
        boolean useId;

        ReloadThread(CombinedConfiguration config, int[] failures, int index, int count, boolean useId, String id, String expected) {
            this.combined = config;
            this.failures = failures;
            this.index = index;
            this.count = count;
            this.expected = expected;
            this.id = id;
            this.useId = useId;
        }

        public void run() {
            this.failures[this.index] = 0;
            if (this.useId) {
                ThreadLookup.setId(this.id);
            }
            for (int i = 0; i < this.count; ++i) {
                try {
                    String value = this.combined.getString("rowsPerPage", null);
                    if (value != null && value.equals(this.expected)) continue;
                    int n = this.index;
                    this.failures[n] = this.failures[n] + 1;
                    continue;
                }
                catch (Exception ex) {
                    int n = this.index;
                    this.failures[n] = this.failures[n] + 1;
                }
            }
        }
    }
}

