/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestEqualBehaviour {
    private Configuration setupSimpleConfiguration() throws Exception {
        String simpleConfigurationFile = ConfigurationAssert.getTestFile("testEqual.properties").getAbsolutePath();
        return new PropertiesConfiguration(simpleConfigurationFile);
    }

    private Configuration setupCompositeConfiguration() throws Exception {
        String compositeConfigurationFile = ConfigurationAssert.getTestFile("testEqualDigester.xml").getAbsolutePath();
        ConfigurationFactory configurationFactory = new ConfigurationFactory();
        configurationFactory.setConfigurationFileName(compositeConfigurationFile);
        return configurationFactory.getConfiguration();
    }

    private void checkEquality(String msg, Configuration c1, Configuration c2) {
        Iterator it1 = c1.getKeys();
        Iterator it2 = c2.getKeys();
        while (it1.hasNext() && it2.hasNext()) {
            String key1 = (String)it1.next();
            String key2 = (String)it2.next();
            Assert.assertEquals((String)(msg + ", Keys: "), (Object)key1, (Object)key2);
            Assert.assertEquals((String)(msg + ", Contains: "), (Object)c1.containsKey(key1), (Object)c2.containsKey(key2));
        }
        Assert.assertEquals((String)(msg + ", Iterator: "), (Object)it1.hasNext(), (Object)it2.hasNext());
    }

    private void checkSameKey(String msg, String key, Configuration c1, Configuration c2) {
        String[] s1 = c1.getStringArray(key);
        String[] s2 = c2.getStringArray(key);
        Assert.assertEquals((String)(msg + ", length: "), (long)s1.length, (long)s2.length);
        for (int i = 0; i < s1.length; ++i) {
            Assert.assertEquals((String)(msg + ", String Array: "), (Object)s1[i], (Object)s2[i]);
        }
        List list1 = c1.getList(key);
        List list2 = c2.getList(key);
        Assert.assertEquals((String)(msg + ", Size: "), (long)list1.size(), (long)list2.size());
        Iterator it1 = list1.iterator();
        Iterator it2 = list2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            String val1 = (String)it1.next();
            String val2 = (String)it2.next();
            Assert.assertEquals((String)(msg + ", List: "), (Object)val1, (Object)val2);
        }
        Assert.assertEquals((String)(msg + ", Iterator End: "), (Object)it1.hasNext(), (Object)it2.hasNext());
    }

    @Test
    public void testLoading() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        this.checkEquality("testLoading", simple, composite);
    }

    @Test
    public void testDeletingExisting() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        String key = "clear.property";
        Assert.assertTrue((boolean)simple.containsKey(key));
        Assert.assertEquals((Object)simple.containsKey(key), (Object)composite.containsKey(key));
        simple.clearProperty(key);
        composite.clearProperty(key);
        Assert.assertFalse((boolean)simple.containsKey(key));
        Assert.assertEquals((Object)simple.containsKey(key), (Object)composite.containsKey(key));
        this.checkEquality("testDeletingExisting", simple, composite);
    }

    @Test
    public void testDeletingNonExisting() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        String key = "nonexisting.clear.property";
        Assert.assertFalse((boolean)simple.containsKey(key));
        Assert.assertEquals((Object)simple.containsKey(key), (Object)composite.containsKey(key));
        simple.clearProperty(key);
        composite.clearProperty(key);
        Assert.assertFalse((boolean)simple.containsKey(key));
        Assert.assertEquals((Object)simple.containsKey(key), (Object)composite.containsKey(key));
        this.checkEquality("testDeletingNonExisting", simple, composite);
    }

    @Test
    public void testSettingNonExisting() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        String key = "nonexisting.property";
        String value = "new value";
        Assert.assertFalse((boolean)simple.containsKey(key));
        Assert.assertEquals((Object)simple.containsKey(key), (Object)composite.containsKey(key));
        simple.setProperty(key, (Object)value);
        composite.setProperty(key, (Object)value);
        Assert.assertTrue((boolean)simple.containsKey(key));
        Assert.assertEquals((Object)simple.containsKey(key), (Object)composite.containsKey(key));
        this.checkSameKey("testSettingNonExisting", key, simple, composite);
        this.checkEquality("testSettingNonExisting", simple, composite);
    }

    @Test
    public void testSettingExisting() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        String key = "existing.property";
        String value = "new value";
        Assert.assertTrue((boolean)simple.containsKey(key));
        Assert.assertFalse((boolean)simple.getString(key).equals(value));
        Assert.assertEquals((Object)simple.containsKey(key), (Object)composite.containsKey(key));
        simple.setProperty(key, (Object)value);
        composite.setProperty(key, (Object)value);
        Assert.assertTrue((boolean)simple.containsKey(key));
        Assert.assertEquals((Object)simple.getString(key), (Object)value);
        Assert.assertEquals((Object)simple.containsKey(key), (Object)composite.containsKey(key));
        this.checkSameKey("testSettingExisting", key, simple, composite);
        this.checkEquality("testSettingExisting", simple, composite);
    }

    @Test
    public void testAddingUnset() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        String key = "nonexisting.property";
        String value = "new value";
        Assert.assertFalse((boolean)simple.containsKey(key));
        Assert.assertEquals((Object)simple.containsKey(key), (Object)composite.containsKey(key));
        simple.addProperty(key, (Object)value);
        composite.addProperty(key, (Object)value);
        this.checkSameKey("testAddingUnset", key, simple, composite);
        this.checkEquality("testAddingUnset", simple, composite);
    }

    @Test
    public void testAddingSet() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        String key = "existing.property";
        String value = "new value";
        Assert.assertTrue((boolean)simple.containsKey(key));
        Assert.assertEquals((Object)simple.containsKey(key), (Object)composite.containsKey(key));
        simple.addProperty(key, (Object)value);
        composite.addProperty(key, (Object)value);
        Assert.assertTrue((boolean)simple.containsKey(key));
        Assert.assertEquals((Object)simple.containsKey(key), (Object)composite.containsKey(key));
        this.checkSameKey("testAddingSet", key, simple, composite);
        this.checkEquality("testAddingSet", simple, composite);
    }
}

