/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.event;

import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.event.ConfigurationListenerTestImpl;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTestConfigurationEvents {
    static final String TEST_PROPNAME = "event.test";
    static final String TEST_PROPVALUE = "a value";
    static final String EXIST_PROPERTY = "event.property";
    protected AbstractConfiguration config;
    protected ConfigurationListenerTestImpl l;

    @Before
    public void setUp() throws Exception {
        this.config = this.createConfiguration();
        this.config.addProperty(EXIST_PROPERTY, (Object)"existing value");
        this.l = new ConfigurationListenerTestImpl(this.config);
        this.config.addConfigurationListener((ConfigurationListener)this.l);
    }

    protected abstract AbstractConfiguration createConfiguration();

    @Test
    public void testAddPropertyEvent() {
        this.config.addProperty(TEST_PROPNAME, (Object)TEST_PROPVALUE);
        this.l.checkEvent(1, TEST_PROPNAME, TEST_PROPVALUE, true);
        this.l.checkEvent(1, TEST_PROPNAME, TEST_PROPVALUE, false);
        this.l.done();
    }

    @Test
    public void testAddPropertyEventWithDetails() {
        this.config.setDetailEvents(true);
        this.config.addProperty(TEST_PROPNAME, (Object)TEST_PROPVALUE);
        this.l.checkEventCount(2);
        this.l.checkEvent(1, TEST_PROPNAME, TEST_PROPVALUE, true);
        this.l.skipToLast(1);
        this.l.checkEvent(1, TEST_PROPNAME, TEST_PROPVALUE, false);
        this.l.done();
    }

    @Test
    public void testClearPropertyEvent() {
        this.config.clearProperty(EXIST_PROPERTY);
        this.l.checkEvent(2, EXIST_PROPERTY, null, true);
        this.l.checkEvent(2, EXIST_PROPERTY, null, false);
        this.l.done();
    }

    @Test
    public void testClearPropertyEventWithDetails() {
        this.config.setDetailEvents(true);
        this.config.clearProperty(EXIST_PROPERTY);
        this.l.checkEventCount(2);
        this.l.checkEvent(2, EXIST_PROPERTY, null, true);
        this.l.skipToLast(2);
        this.l.checkEvent(2, EXIST_PROPERTY, null, false);
        this.l.done();
    }

    @Test
    public void testSetPropertyEvent() {
        this.config.setProperty(EXIST_PROPERTY, (Object)TEST_PROPVALUE);
        this.l.checkEvent(3, EXIST_PROPERTY, TEST_PROPVALUE, true);
        this.l.checkEvent(3, EXIST_PROPERTY, TEST_PROPVALUE, false);
        this.l.done();
    }

    @Test
    public void testSetPropertyEventWithDetails() {
        this.config.setDetailEvents(true);
        this.config.setProperty(EXIST_PROPERTY, (Object)TEST_PROPVALUE);
        this.l.checkEventCount(2);
        this.l.checkEvent(3, EXIST_PROPERTY, TEST_PROPVALUE, true);
        this.l.skipToLast(3);
        this.l.checkEvent(3, EXIST_PROPERTY, TEST_PROPVALUE, false);
        this.l.done();
    }

    @Test
    public void testClearEvent() {
        this.config.clear();
        this.l.checkEvent(4, null, null, true);
        this.l.checkEvent(4, null, null, false);
        this.l.done();
    }

    @Test
    public void testClearEventWithDetails() {
        this.config.setDetailEvents(true);
        this.config.clear();
        this.l.checkEventCount(2);
        this.l.checkEvent(4, null, null, true);
        this.l.skipToLast(4);
        this.l.checkEvent(4, null, null, false);
        this.l.done();
    }
}

