/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.DelegatingPreparedStatement;
import org.apache.commons.dbcp2.DelegatingStatement;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolablePreparedStatement;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPStmtPooling {
    private DataSource createPoolingDataSource() throws Exception {
        DriverManager.registerDriver(new TesterDriver());
        DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver", "u1", "p1");
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)connFactory, null);
        pcf.setPoolStatements(true);
        pcf.setDefaultReadOnly(Boolean.FALSE);
        pcf.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool connPool = new GenericObjectPool((PooledObjectFactory)pcf);
        pcf.setPool((ObjectPool)connPool);
        return new PoolingDataSource((ObjectPool)connPool);
    }

    private PoolablePreparedStatement<?> getPoolablePreparedStatement(Statement s) {
        while (s != null) {
            if (s instanceof PoolablePreparedStatement) {
                return (PoolablePreparedStatement)s;
            }
            if (!(s instanceof DelegatingPreparedStatement)) {
                return null;
            }
            s = ((DelegatingPreparedStatement)s).getDelegate();
        }
        return null;
    }

    @Test
    public void testBatchUpdate() throws Exception {
        DriverManager.registerDriver(new TesterDriver());
        DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver", "u1", "p1");
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)connFactory, null);
        pcf.setPoolStatements(true);
        pcf.setDefaultReadOnly(Boolean.FALSE);
        pcf.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool connPool = new GenericObjectPool((PooledObjectFactory)pcf);
        pcf.setPool((ObjectPool)connPool);
        PoolingDataSource ds = new PoolingDataSource((ObjectPool)connPool);
        Connection conn = ds.getConnection();
        PreparedStatement ps = conn.prepareStatement("select 1 from dual");
        Statement inner = ((DelegatingPreparedStatement)ps).getInnermostDelegate();
        ps.addBatch();
        ps.close();
        conn.close();
        Assertions.assertFalse((boolean)inner.isClosed());
        ds.close();
    }

    @Test
    public void testCallableStatementPooling() throws Exception {
        DriverManager.registerDriver(new TesterDriver());
        DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver", "u1", "p1");
        ObjectName oName = new ObjectName("UnitTests:DataSource=test");
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)connFactory, oName);
        pcf.setPoolStatements(true);
        pcf.setDefaultReadOnly(Boolean.FALSE);
        pcf.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setJmxNameBase("UnitTests:DataSource=test,connectionpool=connections");
        config.setJmxNamePrefix("");
        GenericObjectPool connPool = new GenericObjectPool((PooledObjectFactory)pcf, config);
        pcf.setPool((ObjectPool)connPool);
        PoolingDataSource ds = new PoolingDataSource((ObjectPool)connPool);
        try (Connection conn = ds.getConnection();){
            PreparedStatement stmt1 = conn.prepareStatement("select 1 from dual");
            Statement ustmt1 = ((DelegatingStatement)stmt1).getInnermostDelegate();
            CallableStatement cstmt1 = conn.prepareCall("{call home}");
            Statement ucstmt1 = ((DelegatingStatement)cstmt1).getInnermostDelegate();
            stmt1.close();
            cstmt1.close();
            PreparedStatement stmt2 = conn.prepareStatement("select 1 from dual");
            Statement ustmt2 = ((DelegatingStatement)stmt2).getInnermostDelegate();
            CallableStatement cstmt2 = conn.prepareCall("{call home}");
            Statement ucstmt2 = ((DelegatingStatement)cstmt2).getInnermostDelegate();
            stmt2.close();
            cstmt2.close();
            Assertions.assertSame((Object)ustmt1, (Object)ustmt2);
            Assertions.assertSame((Object)ucstmt1, (Object)ucstmt2);
            CallableStatement stmt3 = conn.prepareCall("select 1 from dual");
            Statement ustmt3 = ((DelegatingStatement)stmt3).getInnermostDelegate();
            stmt3.close();
            Assertions.assertNotSame((Object)ustmt1, (Object)ustmt3);
            Assertions.assertNotSame((Object)ustmt3, (Object)ucstmt1);
        }
        ds.close();
    }

    @Test
    public void testClosePool() throws Exception {
        DriverManager.registerDriver(new TesterDriver());
        DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory("jdbc:apache:commons:testdriver", "u1", "p1");
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)connFactory, null);
        pcf.setPoolStatements(true);
        pcf.setDefaultReadOnly(Boolean.FALSE);
        pcf.setDefaultAutoCommit(Boolean.TRUE);
        GenericObjectPool connPool = new GenericObjectPool((PooledObjectFactory)pcf);
        pcf.setPool((ObjectPool)connPool);
        PoolingDataSource ds = new PoolingDataSource((ObjectPool)connPool);
        ds.setAccessToUnderlyingConnectionAllowed(true);
        Connection conn = ds.getConnection();
        PreparedStatement s = conn.prepareStatement("select 1 from dual");
        if (s != null) {
            s.close();
        }
        Connection poolableConnection = ((DelegatingConnection)conn).getDelegate();
        Connection poolingConnection = ((DelegatingConnection)poolableConnection).getDelegate();
        poolingConnection.close();
        try (PreparedStatement ps = conn.prepareStatement("select 1 from dual");){
            Assertions.fail((String)"Expecting SQLException");
        }
        catch (SQLException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().endsWith("invalid PoolingConnection."));
        }
        ds.close();
    }

    @Test
    public void testMultipleClose() throws Exception {
        DataSource ds = this.createPoolingDataSource();
        Connection conn = ds.getConnection();
        PreparedStatement stmt1 = conn.prepareStatement("select 1 from dual");
        PoolablePreparedStatement<?> pps1 = this.getPoolablePreparedStatement(stmt1);
        conn.close();
        Assertions.assertTrue((boolean)stmt1.isClosed());
        stmt1.close();
        Assertions.assertTrue((boolean)stmt1.isClosed());
        Connection conn2 = ds.getConnection();
        PreparedStatement stmt2 = conn2.prepareStatement("select 1 from dual");
        Assertions.assertSame(pps1, this.getPoolablePreparedStatement(stmt2));
        stmt1.close();
        Assertions.assertFalse((boolean)stmt2.isClosed());
        stmt2.executeQuery();
        conn2.close();
        Assertions.assertTrue((boolean)stmt1.isClosed());
        Assertions.assertTrue((boolean)stmt2.isClosed());
    }

    @Test
    public void testStmtPool() throws Exception {
        DataSource ds = this.createPoolingDataSource();
        try (Connection conn = ds.getConnection();){
            PreparedStatement stmt1 = conn.prepareStatement("select 1 from dual");
            Statement ustmt1 = ((DelegatingStatement)stmt1).getInnermostDelegate();
            stmt1.close();
            PreparedStatement stmt2 = conn.prepareStatement("select 1 from dual");
            Statement ustmt2 = ((DelegatingStatement)stmt2).getInnermostDelegate();
            stmt2.close();
            Assertions.assertSame((Object)ustmt1, (Object)ustmt2);
        }
    }
}

