/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.RowProcessor;

public class ResultSetIterator
implements Iterator<Object[]> {
    private final ResultSet resultSet;
    private final RowProcessor convert;

    public static Iterable<Object[]> iterable(ResultSet resultSet) {
        return () -> new ResultSetIterator(resultSet);
    }

    public ResultSetIterator(ResultSet resultSet) {
        this(resultSet, new BasicRowProcessor());
    }

    public ResultSetIterator(ResultSet resultSet, RowProcessor convert) {
        this.resultSet = resultSet;
        this.convert = convert;
    }

    @Override
    public boolean hasNext() {
        try {
            return !this.resultSet.isLast();
        }
        catch (SQLException e) {
            this.rethrow(e);
            return false;
        }
    }

    @Override
    public Object[] next() {
        try {
            this.resultSet.next();
            return this.convert.toArray(this.resultSet);
        }
        catch (SQLException e) {
            this.rethrow(e);
            return null;
        }
    }

    @Override
    public void remove() {
        try {
            this.resultSet.deleteRow();
        }
        catch (SQLException e) {
            this.rethrow(e);
        }
    }

    protected void rethrow(SQLException e) {
        throw new RuntimeException(e.getMessage());
    }
}

