/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.png.AbstractScanExpediter;
import org.apache.commons.imaging.formats.png.BitParser;
import org.apache.commons.imaging.formats.png.GammaCorrection;
import org.apache.commons.imaging.formats.png.PngColorType;
import org.apache.commons.imaging.formats.png.chunks.PngChunkPlte;
import org.apache.commons.imaging.formats.png.transparencyfilters.AbstractTransparencyFilter;

final class ScanExpediterSimple
extends AbstractScanExpediter {
    ScanExpediterSimple(int width, int height, InputStream is, BufferedImage bi, PngColorType pngColorType, int bitDepth, int bitsPerPixel, PngChunkPlte pngChunkPLTE, GammaCorrection gammaCorrection, AbstractTransparencyFilter abstractTransparencyFilter) {
        super(width, height, is, bi, pngColorType, bitDepth, bitsPerPixel, pngChunkPLTE, gammaCorrection, abstractTransparencyFilter);
    }

    @Override
    public void drive() throws ImagingException, IOException {
        int bitsPerScanLine = this.bitsPerPixel * this.width;
        int pixelBytesPerScanLine = this.getBitsToBytesRoundingUp(bitsPerScanLine);
        byte[] prev = null;
        for (int y = 0; y < this.height; ++y) {
            byte[] unfiltered;
            prev = unfiltered = this.getNextScanline(this.is, pixelBytesPerScanLine, prev, this.bytesPerPixel);
            BitParser bitParser = new BitParser(unfiltered, this.bitsPerPixel, this.bitDepth);
            for (int x = 0; x < this.width; ++x) {
                int rgb = this.getRgb(bitParser, x);
                this.bi.setRGB(x, y, rgb);
            }
        }
    }
}

