/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.test.xml;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.jelly.Jelly;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;

public class TestXMLValidation
extends TestCase {
    Jelly jelly = null;
    JellyContext context = null;
    XMLOutput xmlOutput = null;

    public TestXMLValidation(String name) {
        super(name);
    }

    public static TestSuite suite() throws Exception {
        return new TestSuite(TestXMLValidation.class);
    }

    public void setUp(String scriptName) throws Exception {
        this.context = new JellyContext();
        this.xmlOutput = XMLOutput.createXMLOutput((Writer)new StringWriter());
        this.jelly = new Jelly();
        String script = scriptName;
        URL url = ((Object)((Object)this)).getClass().getResource(script);
        if (url == null) {
            throw new Exception("Could not find Jelly script: " + script + " in package of class: " + ((Object)((Object)this)).getClass().getName());
        }
        this.jelly.setUrl(url);
    }

    public void testInvalidXML1NoValidation() throws Exception {
        this.setUp("invalidScript1.jelly");
        Script script = this.jelly.compileScript();
        script.run(this.context, this.xmlOutput);
        TestXMLValidation.assertTrue((String)"should have set 'foo' variable to 'bar'", (boolean)this.context.getVariable("foo").equals("bar"));
        this.setUp("invalidScript1.jelly");
        this.jelly.setValidateXML(false);
        script = this.jelly.compileScript();
        script.run(this.context, this.xmlOutput);
        TestXMLValidation.assertTrue((String)"should have set 'foo' variable to 'bar'", (boolean)this.context.getVariable("foo").equals("bar"));
    }

    public void testInvalidXML1Validation() throws Exception {
        this.setUp("invalidScript1.jelly");
        this.jelly.setValidateXML(true);
        try {
            Script script = this.jelly.compileScript();
            TestXMLValidation.fail((String)"Invalid scripts should throw JellyException on parse");
        }
        catch (JellyException jellyException) {
            // empty catch block
        }
    }

    public void testValidXML1Validation() throws Exception {
        this.setUp("validScript1.jelly");
        this.jelly.setValidateXML(true);
        Script script = this.jelly.compileScript();
        script.run(this.context, this.xmlOutput);
        TestXMLValidation.assertTrue((String)"should have set 'foo' variable to 'bar'", (boolean)this.context.getVariable("foo").equals("bar"));
    }
}

