/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.nonstiff.MidpointFieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldIntegratorAbstractTest;
import org.apache.commons.math3.util.Decimal64Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidpointFieldIntegratorTest
extends RungeKuttaFieldIntegratorAbstractTest {
    @Override
    protected <T extends RealFieldElement<T>> RungeKuttaFieldIntegrator<T> createIntegrator(Field<T> field, T step) {
        return new MidpointFieldIntegrator(field, step);
    }

    @Override
    public void testNonFieldIntegratorConsistency() {
        this.doTestNonFieldIntegratorConsistency(Decimal64Field.getInstance());
    }

    @Override
    public void testMissedEndEvent() {
        this.doTestMissedEndEvent(Decimal64Field.getInstance(), 1.0E-15, 6.0E-5);
    }

    @Override
    public void testSanityChecks() {
        this.doTestSanityChecks(Decimal64Field.getInstance());
    }

    @Override
    public void testDecreasingSteps() {
        this.doTestDecreasingSteps(Decimal64Field.getInstance(), 1.0, 1.0, 1.0E-10);
    }

    @Override
    public void testSmallStep() {
        this.doTestSmallStep(Decimal64Field.getInstance(), 2.0E-7, 1.0E-6, 1.0E-12, "midpoint");
    }

    @Override
    public void testBigStep() {
        this.doTestBigStep(Decimal64Field.getInstance(), 0.01, 0.05, 1.0E-12, "midpoint");
    }

    @Override
    public void testBackward() {
        this.doTestBackward(Decimal64Field.getInstance(), 6.0E-4, 6.0E-4, 1.0E-12, "midpoint");
    }

    @Override
    public void testKepler() {
        this.doTestKepler(Decimal64Field.getInstance(), 1.19, 0.01);
    }

    @Override
    public void testStepSize() {
        this.doTestStepSize(Decimal64Field.getInstance(), 1.0E-12);
    }

    @Override
    public void testSingleStep() {
        this.doTestSingleStep(Decimal64Field.getInstance(), 0.21);
    }

    @Override
    public void testTooLargeFirstStep() {
        this.doTestTooLargeFirstStep(Decimal64Field.getInstance());
    }

    @Override
    public void testUnstableDerivative() {
        this.doTestUnstableDerivative(Decimal64Field.getInstance(), 1.0E-12);
    }

    @Override
    public void testDerivativesConsistency() {
        this.doTestDerivativesConsistency(Decimal64Field.getInstance(), 1.0E-10);
    }

    @Override
    public void testPartialDerivatives() {
        this.doTestPartialDerivatives(1.7E-4, new double[]{0.001, 2.8E-4, 3.8E-5, 2.8E-4, 2.8E-4});
    }
}

