/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.genetics;

import java.util.ArrayList;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.genetics.Chromosome;
import org.apache.commons.math4.legacy.genetics.ChromosomePair;
import org.apache.commons.math4.legacy.genetics.GeneticAlgorithm;
import org.apache.commons.math4.legacy.genetics.ListPopulation;
import org.apache.commons.math4.legacy.genetics.Population;
import org.apache.commons.math4.legacy.genetics.SelectionPolicy;

public class TournamentSelection
implements SelectionPolicy {
    private int arity;

    public TournamentSelection(int arity) {
        this.arity = arity;
    }

    @Override
    public ChromosomePair select(Population population) throws MathIllegalArgumentException {
        return new ChromosomePair(this.tournament((ListPopulation)population), this.tournament((ListPopulation)population));
    }

    private Chromosome tournament(ListPopulation population) throws MathIllegalArgumentException {
        if (population.getPopulationSize() < this.arity) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.TOO_LARGE_TOURNAMENT_ARITY, new Object[]{this.arity, population.getPopulationSize()});
        }
        ListPopulation tournamentPopulation = new ListPopulation(this.arity){

            @Override
            public Population nextGeneration() {
                return null;
            }
        };
        ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>(population.getChromosomes());
        for (int i = 0; i < this.arity; ++i) {
            int rind = GeneticAlgorithm.getRandomGenerator().nextInt(chromosomes.size());
            tournamentPopulation.addChromosome((Chromosome)chromosomes.get(rind));
            chromosomes.remove(rind);
        }
        return tournamentPopulation.getFittestChromosome();
    }

    public int getArity() {
        return this.arity;
    }

    public void setArity(int arity) {
        this.arity = arity;
    }
}

