/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ml.distance;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.ml.distance.DistanceMeasure;

public class EarthMoversDistance
implements DistanceMeasure {
    @Override
    public double compute(double[] a, double[] b) {
        MathArrays.checkEqualLength((double[])a, (double[])b);
        double lastDistance = 0.0;
        double totalDistance = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double currentDistance = a[i] + lastDistance - b[i];
            totalDistance += JdkMath.abs((double)currentDistance);
            lastDistance = currentDistance;
        }
        return totalDistance;
    }
}

