/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.mail;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.examples.PrintCommandListeners;
import org.apache.commons.net.io.Util;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.commons.net.smtp.SimpleSMTPHeader;

public final class SMTPMail {
    public static void main(String[] args) {
        ArrayList<String> ccList = new ArrayList<String>();
        BufferedReader fileReader = null;
        if (args.length < 1) {
            System.err.println("Usage: SMTPMail <smtpserver>");
            System.exit(1);
        }
        String server = args[0];
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        try {
            System.out.print("From: ");
            System.out.flush();
            String sender = stdin.readLine();
            System.out.print("To: ");
            System.out.flush();
            String recipient = stdin.readLine();
            System.out.print("Subject: ");
            System.out.flush();
            String subject = stdin.readLine();
            SimpleSMTPHeader header = new SimpleSMTPHeader(sender, recipient, subject);
            while (true) {
                System.out.print("CC <enter one address per line, hit enter to end>: ");
                System.out.flush();
                String cc = stdin.readLine();
                if (cc == null || cc.isEmpty()) break;
                header.addCC(cc.trim());
                ccList.add(cc.trim());
            }
            System.out.print("Filename: ");
            System.out.flush();
            String fileName = stdin.readLine();
            try {
                fileReader = Files.newBufferedReader(Paths.get(fileName, new String[0]), Charset.defaultCharset());
            }
            catch (FileNotFoundException e) {
                System.err.println("File not found. " + e.getMessage());
            }
            SMTPClient client = new SMTPClient();
            client.addProtocolCommandListener(PrintCommandListeners.sysOutPrintCommandListener());
            client.connect(server);
            if (!SMTPReply.isPositiveCompletion(client.getReplyCode())) {
                client.disconnect();
                System.err.println("SMTP server refused connection.");
                System.exit(1);
            }
            client.login();
            client.setSender(sender);
            client.addRecipient(recipient);
            for (String recpt : ccList) {
                client.addRecipient(recpt);
            }
            Writer writer = client.sendMessageData();
            if (writer != null) {
                writer.write(header.toString());
                Util.copyReader(fileReader, writer);
                writer.close();
                client.completePendingCommand();
            }
            IOUtils.close((Closeable)fileReader);
            client.logout();
            client.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

