/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.arrays;

import java.util.Arrays;
import org.apache.commons.numbers.arrays.HashIndexSet;

final class Sorting {
    private Sorting() {
    }

    static void sort(double[] x, int left, int right) {
        int i = left;
        while (++i <= right) {
            double v = x[i];
            if (!(v < x[i - 1])) continue;
            int j = i;
            while (--j >= left && v < x[j]) {
                x[j + 1] = x[j];
            }
            x[j + 1] = v;
        }
    }

    static void sort3(double[] x, int a, int b, int c) {
        double u = x[a];
        double v = x[b];
        double w = x[c];
        if (w < u) {
            if (v < w) {
                x[a] = v;
                x[b] = w;
                x[c] = u;
                return;
            }
            if (u < v) {
                x[a] = w;
                x[b] = u;
                x[c] = v;
                return;
            }
            x[a] = w;
            x[c] = u;
            return;
        }
        if (v < u) {
            x[a] = v;
            x[b] = u;
            return;
        }
        if (w < v) {
            x[b] = w;
            x[c] = v;
        }
    }

    static void sort5(double[] x, int a, int b, int c, int d, int e) {
        double v;
        double u;
        if (x[e] < x[b]) {
            u = x[e];
            x[e] = x[b];
            x[b] = u;
        }
        if (x[d] < x[a]) {
            v = x[d];
            x[d] = x[a];
            x[a] = v;
        }
        if (x[d] < x[b]) {
            u = x[d];
            x[d] = x[b];
            x[b] = u;
        }
        if (x[c] < x[a]) {
            v = x[c];
            x[c] = x[a];
            x[a] = v;
        }
        if (x[e] < x[c]) {
            u = x[e];
            x[e] = x[c];
            x[c] = u;
        }
        if (x[b] < x[a]) {
            v = x[b];
            x[b] = x[a];
            x[a] = v;
        }
        if (x[e] < x[d]) {
            u = x[e];
            x[e] = x[d];
            x[d] = u;
        }
        if (x[c] < x[b]) {
            v = x[c];
            x[c] = x[b];
            x[b] = v;
        }
        if (x[d] < x[c]) {
            u = x[d];
            x[d] = x[c];
            x[c] = u;
        }
    }

    static void lowerMedian4(double[] x, int a, int b, int c, int d) {
        double u;
        if (x[d] < x[b]) {
            u = x[d];
            x[d] = x[b];
            x[b] = u;
        }
        if (x[c] < x[a]) {
            double v = x[c];
            x[c] = x[a];
            x[a] = v;
        }
        if (x[c] < x[b]) {
            u = x[c];
            x[c] = x[b];
            x[b] = u;
        } else if (x[b] < x[a]) {
            double xb = x[a];
            x[a] = x[b];
            x[b] = xb;
            if (x[d] < xb) {
                x[b] = x[d];
                x[d] = x[c];
                x[c] = xb;
            }
        }
    }

    static void upperMedian4(double[] x, int a, int b, int c, int d) {
        double u;
        if (x[d] < x[b]) {
            u = x[d];
            x[d] = x[b];
            x[b] = u;
        }
        if (x[c] < x[a]) {
            double v = x[c];
            x[c] = x[a];
            x[a] = v;
        }
        if (x[b] > x[c]) {
            u = x[c];
            x[c] = x[b];
            x[b] = u;
        } else if (x[c] > x[d]) {
            double xc = x[d];
            x[d] = x[c];
            x[c] = xc;
            if (x[a] > xc) {
                x[c] = x[a];
                x[a] = x[b];
                x[b] = xc;
            }
        }
    }

    static void sort(int[] x, int left, int right) {
        int i = left;
        while (++i <= right) {
            int v = x[i];
            if (v >= x[i - 1]) continue;
            int j = i;
            while (--j >= left && v < x[j]) {
                x[j + 1] = x[j];
            }
            x[j + 1] = v;
        }
    }

    static void sort3(int[] x, int a, int b, int c) {
        int u = x[a];
        int v = x[b];
        int w = x[c];
        if (w < u) {
            if (v < w) {
                x[a] = v;
                x[b] = w;
                x[c] = u;
                return;
            }
            if (u < v) {
                x[a] = w;
                x[b] = u;
                x[c] = v;
                return;
            }
            x[a] = w;
            x[c] = u;
            return;
        }
        if (v < u) {
            x[a] = v;
            x[b] = u;
            return;
        }
        if (w < v) {
            x[b] = w;
            x[c] = v;
        }
    }

    static void sort5(int[] x, int a, int b, int c, int d, int e) {
        int v;
        int u;
        if (x[e] < x[b]) {
            u = x[e];
            x[e] = x[b];
            x[b] = u;
        }
        if (x[d] < x[a]) {
            v = x[d];
            x[d] = x[a];
            x[a] = v;
        }
        if (x[d] < x[b]) {
            u = x[d];
            x[d] = x[b];
            x[b] = u;
        }
        if (x[c] < x[a]) {
            v = x[c];
            x[c] = x[a];
            x[a] = v;
        }
        if (x[e] < x[c]) {
            u = x[e];
            x[e] = x[c];
            x[c] = u;
        }
        if (x[b] < x[a]) {
            v = x[b];
            x[b] = x[a];
            x[a] = v;
        }
        if (x[e] < x[d]) {
            u = x[e];
            x[e] = x[d];
            x[d] = u;
        }
        if (x[c] < x[b]) {
            v = x[c];
            x[c] = x[b];
            x[b] = v;
        }
        if (x[d] < x[c]) {
            u = x[d];
            x[d] = x[c];
            x[c] = u;
        }
    }

    static void lowerMedian4(int[] x, int a, int b, int c, int d) {
        int u;
        if (x[d] < x[b]) {
            u = x[d];
            x[d] = x[b];
            x[b] = u;
        }
        if (x[c] < x[a]) {
            int v = x[c];
            x[c] = x[a];
            x[a] = v;
        }
        if (x[c] < x[b]) {
            u = x[c];
            x[c] = x[b];
            x[b] = u;
        } else if (x[b] < x[a]) {
            int xb = x[a];
            x[a] = x[b];
            x[b] = xb;
            if (x[d] < xb) {
                x[b] = x[d];
                x[d] = x[c];
                x[c] = xb;
            }
        }
    }

    static void upperMedian4(int[] x, int a, int b, int c, int d) {
        int u;
        if (x[d] < x[b]) {
            u = x[d];
            x[d] = x[b];
            x[b] = u;
        }
        if (x[c] < x[a]) {
            int v = x[c];
            x[c] = x[a];
            x[a] = v;
        }
        if (x[b] > x[c]) {
            u = x[c];
            x[c] = x[b];
            x[b] = u;
        } else if (x[c] > x[d]) {
            int xc = x[d];
            x[d] = x[c];
            x[c] = xc;
            if (x[a] > xc) {
                x[c] = x[a];
                x[a] = x[b];
                x[b] = xc;
            }
        }
    }

    static int insertionSortIndices(int[] x, int n) {
        int unique = 0;
        int i = 0;
        while (++i < n) {
            int j;
            int v = x[i];
            if (v > x[j = unique++]) {
                x[unique] = v;
                continue;
            }
            if (v >= x[j]) continue;
            while (--j >= 0 && v < x[j]) {
            }
            if (j >= 0 && v == x[j]) continue;
            for (int k = unique; k > j; --k) {
                x[k + 1] = x[k];
            }
            x[j + 1] = v;
            ++unique;
        }
        return unique + 1;
    }

    static int sortIndices(int[] x, int n) {
        HashIndexSet set = HashIndexSet.create(n);
        int i = 0;
        int last = 0;
        set.add(x[0]);
        while (++i < n) {
            int v = x[i];
            if (!set.add(v)) continue;
            x[++last] = v;
        }
        Arrays.sort(x, 0, ++last);
        return last;
    }
}

