/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratSampler;

public final class LevySampler
implements SharedStateContinuousSampler {
    private final NormalizedGaussianSampler gaussian;
    private final double location;
    private final double scale;
    private final UniformRandomProvider rng;

    private LevySampler(UniformRandomProvider rng, double location, double scale) {
        this.gaussian = ZigguratSampler.NormalizedGaussian.of(rng);
        this.location = location;
        this.scale = scale;
        this.rng = rng;
    }

    private LevySampler(UniformRandomProvider rng, LevySampler source) {
        this.gaussian = ZigguratSampler.NormalizedGaussian.of(rng);
        this.location = source.location;
        this.scale = source.scale;
        this.rng = rng;
    }

    @Override
    public double sample() {
        double n = this.gaussian.sample();
        return this.scale / (n * n) + this.location;
    }

    public String toString() {
        return "L\u00e9vy deviate [" + this.rng.toString() + "]";
    }

    @Override
    public LevySampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new LevySampler(rng, this);
    }

    public static LevySampler of(UniformRandomProvider rng, double location, double scale) {
        InternalUtils.requireStrictlyPositive(scale, "scale");
        return new LevySampler(rng, location, scale);
    }
}

