/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import org.apache.commons.rng.JumpableUniformRandomProvider;
import org.apache.commons.rng.LongJumpableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.util.NumberFactory;

abstract class AbstractXoShiRo128
extends IntProvider
implements LongJumpableUniformRandomProvider {
    private static final int SEED_SIZE = 4;
    private static final int[] JUMP_COEFFICIENTS = new int[]{-2023489525, -180170029, 1872770499, 2012404571};
    private static final int[] LONG_JUMP_COEFFICIENTS = new int[]{-1255959250, 191826335, -856317713, 475530850};
    protected int state0;
    protected int state1;
    protected int state2;
    protected int state3;

    AbstractXoShiRo128(int[] seed) {
        if (seed.length < 4) {
            int[] state = new int[4];
            this.fillState(state, seed);
            this.setState(state);
        } else {
            this.setState(seed);
        }
    }

    AbstractXoShiRo128(int seed0, int seed1, int seed2, int seed3) {
        this.state0 = seed0;
        this.state1 = seed1;
        this.state2 = seed2;
        this.state3 = seed3;
    }

    protected AbstractXoShiRo128(AbstractXoShiRo128 source) {
        super(source);
        this.state0 = source.state0;
        this.state1 = source.state1;
        this.state2 = source.state2;
        this.state3 = source.state3;
    }

    private void setState(int[] state) {
        this.state0 = state[0];
        this.state1 = state[1];
        this.state2 = state[2];
        this.state3 = state[3];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new int[]{this.state0, this.state1, this.state2, this.state3}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 16);
        this.setState(NumberFactory.makeIntArray(c[0]));
        super.setStateInternal(c[1]);
    }

    @Override
    public int next() {
        int result = this.nextOutput();
        int t = this.state1 << 9;
        this.state2 ^= this.state0;
        this.state3 ^= this.state1;
        this.state1 ^= this.state2;
        this.state0 ^= this.state3;
        this.state2 ^= t;
        this.state3 = Integer.rotateLeft(this.state3, 11);
        return result;
    }

    protected abstract int nextOutput();

    public UniformRandomProvider jump() {
        AbstractXoShiRo128 copy = this.copy();
        this.performJump(JUMP_COEFFICIENTS);
        return copy;
    }

    public JumpableUniformRandomProvider longJump() {
        AbstractXoShiRo128 copy = this.copy();
        this.performJump(LONG_JUMP_COEFFICIENTS);
        return copy;
    }

    protected abstract AbstractXoShiRo128 copy();

    private void performJump(int[] jumpCoefficients) {
        int s0 = 0;
        int s1 = 0;
        int s2 = 0;
        int s3 = 0;
        for (int jc : jumpCoefficients) {
            for (int b = 0; b < 32; ++b) {
                if ((jc & 1 << b) != 0) {
                    s0 ^= this.state0;
                    s1 ^= this.state1;
                    s2 ^= this.state2;
                    s3 ^= this.state3;
                }
                this.next();
            }
        }
        this.state0 = s0;
        this.state1 = s1;
        this.state2 = s2;
        this.state3 = s3;
        this.resetCachedState();
    }
}

