/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav;

import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.DefaultFileContentInfo;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.webdav.WebdavFileObject;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;

public class WebdavFileContentInfoFactory
implements FileContentInfoFactory {
    public FileContentInfo create(FileContent fileContent) throws FileSystemException {
        WebdavFileObject file = (WebdavFileObject)FileObjectUtils.getAbstractFileObject((FileObject)fileContent.getFile());
        String contentType = null;
        String contentEncoding = null;
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(DavPropertyName.GETCONTENTTYPE);
        DavPropertySet propertySet = file.getProperties((URLFileName)file.getName(), nameSet, true);
        DavProperty property = propertySet.get(DavPropertyName.GETCONTENTTYPE);
        if (property != null) {
            contentType = (String)property.getValue();
        }
        if ((property = propertySet.get(WebdavFileObject.RESPONSE_CHARSET)) != null) {
            contentEncoding = (String)property.getValue();
        }
        return new DefaultFileContentInfo(contentType, contentEncoding);
    }
}

